/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.access.FlowerCrownRenderStateAccess;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.FlowerCrownModel;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesAtlases;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesModelLayers;
import house.greenhouse.bovinesandbuttercups.content.component.FlowerCrown;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FlowerCrownLayer<T extends LivingEntityRenderState, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final TextureAtlas petalsTextureAtlas;
    private final FlowerCrownModel<T> model;

    public FlowerCrownLayer(RenderLayerParent<T, M> renderer, Function<ModelLayerLocation, ModelPart> baker, ModelManager modelManager) {
        super(renderer);
        this.model = new FlowerCrownModel(baker.apply(this.getModelLayerLocation()));
        this.petalsTextureAtlas = modelManager.getAtlas(BovinesAtlases.FLOWER_CROWN_SHEET);
    }

    private ModelLayerLocation getModelLayerLocation() {
        return this.getParentModel() instanceof PiglinModel ? BovinesModelLayers.PIGLIN_FLOWER_CROWN_MODEL_LAYER : BovinesModelLayers.FLOWER_CROWN_MODEL_LAYER;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        FlowerCrown flowerCrown = ((FlowerCrownRenderStateAccess)renderState).bovinesandbuttercups$getFlowerCrown();
        if (flowerCrown == null) {
            return;
        }
        this.model.getHead().copyFrom(((HeadedModel)this.getParentModel()).getHead());
        for (int i = 0; i < 8; ++i) {
            this.renderPart(this.model, poseStack, bufferSource, packedLight, i, flowerCrown);
        }
    }

    private void renderPart(FlowerCrownModel<T> model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int index, @Nullable FlowerCrown crown) {
        TextureAtlasSprite sprite = this.petalsTextureAtlas.getSprite(FlowerCrownLayer.getSpriteTexture(index));
        if (crown != null) {
            sprite = this.petalsTextureAtlas.getSprite(crown.getEquippedTexture(index));
        }
        VertexConsumer consumer = sprite.wrap(buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)BovinesAtlases.FLOWER_CROWN_SHEET)));
        model.renderToBuffer(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY);
    }

    private static ResourceLocation getSpriteTexture(int index) {
        return switch (index) {
            case 0 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/center_left");
            case 1 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/top_left");
            case 2 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/top");
            case 3 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/top_right");
            case 4 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/center_right");
            case 5 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/bottom_right");
            case 6 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/bottom");
            case 7 -> BovinesAndButtercups.asResource("bovinesandbuttercups/flower_crown/models/bottom_left");
            default -> throw new UnsupportedOperationException("Could not get index outside of range 0-7.");
        };
    }
}

