/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.client.BovinesAndButtercupsClient;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSet;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSetRegistry;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.StateDefinitionBovinesModelSetType;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.MoobloomModel;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.state.MoobloomRenderState;
import house.greenhouse.bovinesandbuttercups.content.block.BovinesBlocks;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MoobloomConfiguration;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MoobloomFlowerLayer
extends RenderLayer<MoobloomRenderState, MoobloomModel> {
    private final BlockRenderDispatcher blockRenderer;

    public MoobloomFlowerLayer(RenderLayerParent<MoobloomRenderState, MoobloomModel> context, BlockRenderDispatcher blockRenderer) {
        super(context);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, MoobloomRenderState renderState, float yRot, float xRot) {
        boolean bl;
        boolean bl2 = bl = renderState.appearsGlowing && renderState.isInvisible;
        if (renderState.isInvisible && !bl) {
            return;
        }
        MoobloomConfiguration configuration = (MoobloomConfiguration)((CowVariant)renderState.cowVariant.value()).configuration();
        int m = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)renderState, (float)0.0f);
        BakedModel model = null;
        if (renderState.isBaby) {
            if (configuration.bud().modelSet().isPresent()) {
                BovinesModelSet modelSet = BovinesModelSetRegistry.get(configuration.bud().modelSet().get());
                if (modelSet != null && (model = modelSet.getModel()) == null) {
                    model = StateDefinitionBovinesModelSetType.getBlockModel(BovinesModelSetRegistry.get(BovinesAndButtercups.asResource("missing_flower")), BovinesBlocks.CUSTOM_FLOWER.defaultBlockState());
                }
            } else if (configuration.bud().customType().isPresent() && configuration.bud().customType().orElseThrow().unwrapKey().isPresent()) {
                BovinesModelSet modelSet = BovinesModelSetRegistry.get(((ResourceKey)configuration.bud().customType().orElseThrow().unwrapKey().get()).location());
                if (modelSet != null && (model = StateDefinitionBovinesModelSetType.getBlockModel(modelSet, BovinesBlocks.CUSTOM_FLOWER.defaultBlockState())) == null) {
                    model = StateDefinitionBovinesModelSetType.getBlockModel(BovinesModelSetRegistry.get(BovinesAndButtercups.asResource("missing_flower")), BovinesBlocks.CUSTOM_FLOWER.defaultBlockState());
                }
            } else if (configuration.flower().blockState().isEmpty()) {
                return;
            }
            Optional<BlockState> blockState = configuration.bud().blockState();
            this.handleMoobudRender(poseStack, bufferSource, packedLight, bl, m, blockState, model);
        } else {
            if (configuration.flower().modelSet().isPresent()) {
                BovinesModelSet modelSet = BovinesModelSetRegistry.get(configuration.flower().modelSet().get());
                if (modelSet != null && (model = modelSet.getModel()) == null) {
                    model = StateDefinitionBovinesModelSetType.getBlockModel(BovinesModelSetRegistry.get(BovinesAndButtercups.asResource("missing_flower")), BovinesBlocks.CUSTOM_FLOWER.defaultBlockState());
                }
            } else if (configuration.flower().customType().isPresent() && configuration.flower().customType().orElseThrow().unwrapKey().isPresent()) {
                BovinesModelSet modelSet = BovinesModelSetRegistry.get(((ResourceKey)configuration.flower().customType().orElseThrow().unwrapKey().get()).location());
                if (modelSet != null && (model = StateDefinitionBovinesModelSetType.getBlockModel(modelSet, BovinesBlocks.CUSTOM_FLOWER.defaultBlockState())) == null) {
                    model = StateDefinitionBovinesModelSetType.getBlockModel(BovinesModelSetRegistry.get(BovinesAndButtercups.asResource("missing_flower")), BovinesBlocks.CUSTOM_FLOWER.defaultBlockState());
                }
            } else if (configuration.flower().blockState().isEmpty()) {
                return;
            }
            Optional<BlockState> blockState = configuration.flower().blockState();
            this.handleMoobloomRender(poseStack, bufferSource, packedLight, bl, m, blockState, model);
        }
    }

    private void handleMoobudRender(PoseStack poseStack, MultiBufferSource buffer, int i, boolean outlineAndInvisible, int overlay, Optional<BlockState> blockState, @Nullable BakedModel model) {
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.translate(0.2f, 0.35f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-1.0f, -1.0f, -1.0f);
        poseStack.translate(0.25, 0.37, -0.25);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.2f, 0.35f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-1.0f, -1.0f, -1.0f);
        poseStack.translate(0.25, 0.37, (double)0.05f);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.popPose();
        poseStack.pushPose();
        ((MoobloomModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
        poseStack.translate(0.0, (double)-0.7f, (double)-0.2f);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(-0.05, -0.12, 0.15);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
    }

    private void handleMoobloomRender(PoseStack poseStack, MultiBufferSource buffer, int i, boolean outlineAndInvisible, int overlay, Optional<BlockState> blockState, @Nullable BakedModel model) {
        poseStack.pushPose();
        ((MoobloomModel)this.getParentModel()).getBody().translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.12f, 0.33f);
        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
        poseStack.pushPose();
        poseStack.translate((double)0.2f, (double)-0.35f, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(-0.65, -0.18, -0.55);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((double)0.2f, (double)-0.35f, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(-0.03, -0.18, -0.85);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((double)0.2f, (double)-0.35f, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(0.15, -0.18, -0.2);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.popPose();
        poseStack.pushPose();
        ((MoobloomModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
        poseStack.translate(0.0, (double)-0.7f, (double)-0.2f);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.scale(-0.75f, -0.75f, 0.75f);
        poseStack.translate(-0.5, -0.5, -0.5);
        poseStack.translate(-0.05, -0.17, 0.15);
        this.renderFlowerOrBud(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
    }

    private void renderFlowerOrBud(PoseStack poseStack, MultiBufferSource buffer, int light, boolean outlineAndInvisible, BlockRenderDispatcher blockRenderDispatcher, int overlay, Optional<BlockState> flowerState, BakedModel model) {
        BakedModel flowerModel = flowerState.map(arg_0 -> ((BlockRenderDispatcher)blockRenderDispatcher).getBlockModel(arg_0)).orElse(model);
        if (flowerModel == null) {
            flowerModel = BovinesAndButtercupsClient.getHelper().getModel(BovinesAndButtercups.asResource("bovinesandbuttercups/missing_flower/"));
        }
        if (outlineAndInvisible) {
            blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), null, flowerModel, 0.0f, 0.0f, 0.0f, light, overlay);
        } else if (flowerState.isPresent()) {
            blockRenderDispatcher.renderSingleBlock(flowerState.get(), poseStack, buffer, light, overlay);
        } else {
            blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(Sheets.cutoutBlockSheet()), null, flowerModel, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }
}

