/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.client.api.CowVariantRenderState;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSet;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSetRegistry;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.StateDefinitionBovinesModelSetType;
import house.greenhouse.bovinesandbuttercups.content.block.BovinesBlocks;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MooshroomConfiguration;
import java.util.Optional;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.MushroomCowRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MooshroomDatapackMushroomLayer<T extends MushroomCowRenderState>
extends RenderLayer<T, CowModel> {
    private final BlockRenderDispatcher blockRenderer;

    public MooshroomDatapackMushroomLayer(RenderLayerParent<T, CowModel> context, BlockRenderDispatcher blockRenderer) {
        super(context);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        boolean bl = ((MushroomCowRenderState)renderState).appearsGlowing && ((MushroomCowRenderState)renderState).isInvisible;
        Holder cowVariant = ((CowVariantRenderState)renderState).getCowVariant();
        if (cowVariant == null || ((MushroomCowRenderState)renderState).isInvisible && !bl || ((MushroomCowRenderState)renderState).isBaby || ((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().blockState().isPresent() && ((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).vanillaType().isPresent() && ((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().blockState().get().equals(((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).vanillaType().get().getBlockState())) {
            return;
        }
        int m = LivingEntityRenderer.getOverlayCoords(renderState, (float)0.0f);
        BakedModel model = null;
        if (((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().modelSet().isPresent()) {
            BovinesModelSet modelSet = BovinesModelSetRegistry.get(((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().modelSet().get());
            if (modelSet != null && (model = modelSet.getModel()) == null) {
                model = StateDefinitionBovinesModelSetType.getBlockModel(BovinesModelSetRegistry.get(BovinesAndButtercups.asResource("missing_mushroom")), BovinesBlocks.CUSTOM_MUSHROOM.defaultBlockState());
            }
        } else if (((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().customType().isPresent() && ((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().customType().orElseThrow().unwrapKey().isPresent()) {
            BovinesModelSet modelSet = BovinesModelSetRegistry.get(((ResourceKey)((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().customType().orElseThrow().unwrapKey().get()).location());
            if (modelSet != null && (model = StateDefinitionBovinesModelSetType.getBlockModel(modelSet, BovinesBlocks.CUSTOM_MUSHROOM.defaultBlockState())) == null) {
                model = StateDefinitionBovinesModelSetType.getBlockModel(BovinesModelSetRegistry.get(BovinesAndButtercups.asResource("missing_mushroom")), BovinesBlocks.CUSTOM_MUSHROOM.defaultBlockState());
            }
        } else if (((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().blockState().isEmpty()) {
            return;
        }
        this.handleMooshroomRender(poseStack, bufferSource, packedLight, bl, m, ((MooshroomConfiguration)((CowVariant)cowVariant.value()).configuration()).mushroom().blockState(), model);
    }

    private void handleMooshroomRender(PoseStack poseStack, MultiBufferSource buffer, int i, boolean outlineAndInvisible, int overlay, Optional<BlockState> blockState, @Nullable BakedModel model) {
        poseStack.pushPose();
        poseStack.translate(0.2f, -0.35f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        this.renderMushroomBlock(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.2f, -0.35f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(42.0f));
        poseStack.translate(0.1f, 0.0f, -0.6f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-48.0f));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        this.renderMushroomBlock(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
        poseStack.pushPose();
        ((CowModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.7f, -0.2f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-78.0f));
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        this.renderMushroomBlock(poseStack, buffer, i, outlineAndInvisible, this.blockRenderer, overlay, blockState, model);
        poseStack.popPose();
    }

    private void renderMushroomBlock(PoseStack poseStack, MultiBufferSource buffer, int light, boolean outlineAndInvisible, BlockRenderDispatcher blockRenderDispatcher, int overlay, Optional<BlockState> mushroomState, BakedModel model) {
        BakedModel mushroomModel = mushroomState.map(arg_0 -> ((BlockRenderDispatcher)blockRenderDispatcher).getBlockModel(arg_0)).orElse(model);
        if (outlineAndInvisible) {
            blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), null, mushroomModel, 0.0f, 0.0f, 0.0f, light, overlay);
        } else if (mushroomState.isPresent()) {
            blockRenderDispatcher.renderSingleBlock(mushroomState.get(), poseStack, buffer, light, overlay);
        } else {
            blockRenderDispatcher.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(Sheets.cutoutBlockSheet()), null, mushroomModel, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }
}

