/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.entity.model;

import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.animation.MoobloomAnimations;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.state.MoobloomRenderState;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;

public class MoobloomModel
extends QuadrupedModel<MoobloomRenderState> {
    public MoobloomModel(ModelPart root) {
        super(root);
    }

    public void setupAnim(MoobloomRenderState state) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (this.animateLayingDown(state)) {
            if (state.layDownAnimationState.isStarted()) {
                this.head.xRot *= (float)Math.PI / 180;
                this.head.yRot *= (float)Math.PI / 180;
            }
            return;
        }
        super.setupAnim((LivingEntityRenderState)state);
    }

    protected boolean animateLayingDown(MoobloomRenderState state) {
        if (state.getUpAnimationState.isStarted() || state.layDownAnimationState.isStarted()) {
            this.animate(state.getUpAnimationState, MoobloomAnimations.MOOBLOOM_GET_UP, state.ageInTicks, 1.0f);
            this.animate(state.layDownAnimationState, MoobloomAnimations.MOOBLOOM_LAY_DOWN, state.ageInTicks, 1.0f);
            return true;
        }
        return false;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public ModelPart getBody() {
        return this.body;
    }
}

