/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import house.greenhouse.bovinesandbuttercups.access.MobEffectInstanceLockdownDataAccess;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.block.entity.PlaceableEdibleBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemEdible;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlaceableEdibleBlock
extends BaseEntityBlock {
    public static final MapCodec<PlaceableEdibleBlock> CODEC = PlaceableEdibleBlock.simpleCodec(PlaceableEdibleBlock::new);
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)1, (int)16);
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)15);

    public PlaceableEdibleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BITES, (Comparable)Integer.valueOf(1))).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        PlaceableEdibleBlockEntity blockEntity;
        ItemEdible edible;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof PlaceableEdibleBlockEntity && (edible = (blockEntity = (PlaceableEdibleBlockEntity)blockEntity2).getEdibleType()) != null && edible.holder().isBound()) {
            Optional<Map.Entry> shape = ((EdibleBlockType)edible.holder().value()).shapes().entrySet().stream().filter(entry -> ((EdibleBlockType.BlockValuesEntry)entry.getKey()).test(blockEntity)).findFirst();
            return shape.map(Map.Entry::getValue).orElse(Shapes.block());
        }
        return Shapes.block();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        return PlaceableEdibleBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        PlaceableEdibleBlockEntity be;
        Item item = stack.getItem();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PlaceableEdibleBlockEntity) || (be = (PlaceableEdibleBlockEntity)blockEntity).getEdibleType() == null || !be.getEdibleType().holder().isBound()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        int i = (Integer)state.getValue((Property)BITES);
        if (stack.is((Item)BovinesItems.PLACEABLE_EDIBLE) && be.getEdibleType().equals(stack.getOrDefault(BovinesDataComponents.EDIBLE_TYPE, (Object)new ItemEdible((Holder<EdibleBlockType>)level.registryAccess().lookupOrThrow(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE).getOrThrow(EdibleBlockType.MISSING_KEY), List.of())))) {
            if (i >= ((EdibleBlockType)be.getEdibleType().holder().value()).bites()) {
                return InteractionResult.CONSUME;
            }
            stack.consume(1, (LivingEntity)player);
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            level.playSound(null, pos, this.getSoundType(state).getPlaceSound(), SoundSource.BLOCKS);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        InteractionResult activateResult = be.activate(stack, player, hand, hitResult);
        if (activateResult.consumesAction()) {
            return activateResult;
        }
        InteractionResult addAttachmentResult = be.addAttachmentItem(stack, player);
        if (addAttachmentResult.consumesAction()) {
            return addAttachmentResult;
        }
        InteractionResult removeAttachmentResult = be.removeAttachmentItem(stack);
        if (removeAttachmentResult.consumesAction()) {
            return removeAttachmentResult;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos blockPos, BlockState blockState, boolean includeData) {
        PlaceableEdibleBlockEntity pebe;
        ItemStack itemStack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof PlaceableEdibleBlockEntity && (pebe = (PlaceableEdibleBlockEntity)blockEntity).getEdibleType() != null) {
            itemStack.set(BovinesDataComponents.EDIBLE_TYPE, (Object)pebe.getEdibleType());
        }
        return itemStack;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        PlaceableEdibleBlockEntity edibleBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PlaceableEdibleBlockEntity) || (edibleBlockEntity = (PlaceableEdibleBlockEntity)blockEntity).getParticles() == null) {
            return;
        }
        edibleBlockEntity.getParticles().forEach(particleEntry -> PlaceableEdibleBlock.addParticlesAndSound(particleEntry, level, particleEntry.position().add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), random));
    }

    private static void addParticlesAndSound(EdibleBlockType.ParticleEntry particleEntry, Level level, Vec3 offset, RandomSource random) {
        float f = random.nextFloat();
        if (f < particleEntry.chance()) {
            EdibleBlockType.SoundSettings soundSettings;
            level.addParticle(particleEntry.particle(), offset.x, offset.y, offset.z, particleEntry.speed().x, particleEntry.speed().y, particleEntry.speed().z);
            if (particleEntry.sound().isPresent() && f < (soundSettings = particleEntry.sound().get()).chance()) {
                level.playLocalSound(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5, (SoundEvent)soundSettings.sound().value(), SoundSource.BLOCKS, soundSettings.volume().randomise(level.random), soundSettings.pitch().randomise(level.random), false);
            }
        }
    }

    public static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.CONSUME;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(2, 0.1f);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PlaceableEdibleBlockEntity) {
            PlaceableEdibleBlockEntity blockEntity2 = (PlaceableEdibleBlockEntity)blockEntity;
            blockEntity2.getEdibleType().effects().forEach(mobEffectEntry -> {
                int originalDuration = player.hasEffect(mobEffectEntry.effect().getEffect()) ? player.getEffect(mobEffectEntry.effect().getEffect()).getDuration() : 0;
                MobEffectInstance newEffect = new MobEffectInstance(mobEffectEntry.effect().getEffect(), Math.min(originalDuration + mobEffectEntry.effect().getDuration(), mobEffectEntry.maxDuration()), mobEffectEntry.effect().getAmplifier(), mobEffectEntry.effect().isAmbient(), mobEffectEntry.effect().isVisible(), mobEffectEntry.effect().showIcon());
                if (mobEffectEntry.effect().is(BovinesEffects.LOCKDOWN)) {
                    ((MobEffectInstanceLockdownDataAccess)newEffect).bovinesandbuttercups$setLockdownData(((MobEffectInstanceLockdownDataAccess)mobEffectEntry.effect()).bovinesandbuttercups$getLockdownData());
                }
                player.addEffect(newEffect);
            });
        }
        int i = (Integer)state.getValue((Property)BITES);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i > 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i - 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        LootParams lootParams = params.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        BlockEntity blockEntity = (BlockEntity)lootParams.contextMap().getOptional(LootContextParams.BLOCK_ENTITY);
        if (!(blockEntity instanceof PlaceableEdibleBlockEntity)) {
            return super.getDrops(state, params);
        }
        PlaceableEdibleBlockEntity placeableEdibleBlockEntity = (PlaceableEdibleBlockEntity)blockEntity;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)super.getDrops(state, params));
        builder.addAll(placeableEdibleBlockEntity.getAttachments().values().stream().flatMap(attachmentState -> attachmentState.items().stream()).toList());
        return builder.build();
    }

    protected VoxelShape getOcclusionShape(BlockState state) {
        return Shapes.empty();
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction == Direction.DOWN && !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
        builder.add(new Property[]{LIGHT});
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        PlaceableEdibleBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof PlaceableEdibleBlockEntity) || (be = (PlaceableEdibleBlockEntity)blockEntity).getEdibleType() == null || !be.getEdibleType().holder().isBound()) {
            return 0;
        }
        return (int)Math.min((float)((Integer)blockState.getValue((Property)BITES) / ((EdibleBlockType)be.getEdibleType().holder().value()).bites()) * 15.0f, 15.0f);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BovinesBlockEntityTypes.PLACEABLE_EDIBLE.create(pos, state);
    }
}

