/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomMushroom;
import house.greenhouse.bovinesandbuttercups.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CustomMushroomPotBlockEntity
extends BlockEntity
implements Nameable {
    @Nullable
    private ItemCustomMushroom customMushroom;

    public CustomMushroomPotBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super(BovinesBlockEntityTypes.POTTED_CUSTOM_MUSHROOM, worldPosition, blockState);
    }

    @Nullable
    public ItemCustomMushroom getMushroomType() {
        return this.customMushroom;
    }

    public void setMushroomType(@Nullable ItemCustomMushroom value) {
        if (value != null && !((CustomMushroomType)value.holder().value()).hasPotted()) {
            BovinesAndButtercups.LOG.warn("Failed to set custom mushroom to block at {{},{},{}}. Custom mushroom type \"{}\" does not support potted blocks.", new Object[]{this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ(), value.holder().getRegisteredName()});
            return;
        }
        this.customMushroom = value;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("custom_mushroom")) {
            this.setMushroomType(new ItemCustomMushroom((Holder<CustomMushroomType>)((Holder)((Pair)CustomMushroomType.CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("custom_mushroom")).getOrThrow()).getFirst())));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.getMushroomType() != null) {
            tag.put("custom_mushroom", (Tag)CustomMushroomType.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.getMushroomType().holder()).getOrThrow());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(BovinesDataComponents.CUSTOM_MUSHROOM, (Object)this.getMushroomType());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        this.setMushroomType((ItemCustomMushroom)input.get(BovinesDataComponents.CUSTOM_MUSHROOM));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Component getName() {
        if (this.customMushroom.holder().isBound()) {
            return BlockUtil.getOrCreateBlockNameTranslationKey(((ResourceKey)this.customMushroom.holder().unwrapKey().orElseThrow()).location().withPath(s -> "potted_" + s));
        }
        return BlockUtil.getOrCreateBlockNameTranslationKey(BovinesAndButtercups.asResource("potted_missing_mushroom"));
    }
}

