/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.block.entity;

import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.mixin.DefaultDispenseItemBehaviorAccessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MoobloomEatDispenseBehavior
extends OptionalDispenseItemBehavior {
    public static final MoobloomEatDispenseBehavior INSTANCE = new MoobloomEatDispenseBehavior((DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.BONE_MEAL));
    private final DispenseItemBehavior boneMealBehavior;

    protected MoobloomEatDispenseBehavior(DispenseItemBehavior boneMealBehavior) {
        this.boneMealBehavior = boneMealBehavior;
    }

    public static void registerBehavior(MoobloomEatDispenseBehavior behavior) {
        DispenserBlock.registerBehavior((ItemLike)Items.BONE_MEAL, (DispenseItemBehavior)behavior);
    }

    public ItemStack execute(BlockSource source, ItemStack stack) {
        this.setSuccess(true);
        if (this.handleMoobloom(source, stack)) {
            return stack;
        }
        DispenseItemBehavior dispenseItemBehavior = this.boneMealBehavior;
        if (dispenseItemBehavior instanceof OptionalDispenseItemBehavior) {
            OptionalDispenseItemBehavior optional = (OptionalDispenseItemBehavior)dispenseItemBehavior;
            ((DefaultDispenseItemBehaviorAccessor)optional).bovinesandbuttercups$invokeExecute(source, stack);
            if (!optional.isSuccess()) {
                this.setSuccess(false);
            }
            return stack;
        }
        this.boneMealBehavior.dispense(source, stack);
        return stack;
    }

    private boolean handleMoobloom(BlockSource source, ItemStack stack) {
        BlockPos relativePos;
        ServerLevel level = source.level();
        List mooblooms = level.getEntitiesOfClass(Moobloom.class, new AABB(relativePos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
        if (mooblooms.isEmpty()) {
            return false;
        }
        for (Moobloom moobloom : mooblooms) {
            moobloom.feed();
            stack.shrink(1);
        }
        return true;
    }
}

