/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import house.greenhouse.bovinesandbuttercups.util.TooltipUtil;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record ItemEdible(Holder<EdibleBlockType> holder, List<MobEffectEntry> effects) implements TooltipProvider
{
    public static final Codec<ItemEdible> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EdibleBlockType.CODEC.fieldOf("type").forGetter(ItemEdible::holder), (App)MobEffectEntry.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(ItemEdible::effects)).apply((Applicative)inst, ItemEdible::new));
    public static final Codec<ItemEdible> CODEC = Codec.either(EdibleBlockType.CODEC, DIRECT_CODEC).xmap(either -> (ItemEdible)either.map(holder -> new ItemEdible((Holder<EdibleBlockType>)holder, List.of()), Function.identity()), edible -> {
        if (edible.effects.isEmpty()) {
            return Either.left(edible.holder);
        }
        return Either.right((Object)edible);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEdible> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE), ItemEdible::holder, (StreamCodec)MobEffectEntry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemEdible::effects, ItemEdible::new);

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ItemEdible)) {
            return false;
        }
        ItemEdible otherEdible = (ItemEdible)other;
        return otherEdible.effects.equals(this.effects) && otherEdible.holder.equals(this.holder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.holder, this.effects);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        for (MobEffectEntry entry : this.effects.stream().filter(mobEffectEntry -> mobEffectEntry.showInTooltip() != MobEffectEntry.ShowTooltip.NEVER).toList()) {
            if (!tooltipFlag.isCreative() && entry.showInTooltip() == MobEffectEntry.ShowTooltip.CREATIVE_MENU_ONLY) {
                return;
            }
            TooltipUtil.millisecondAllowedPotionTooltip(List.of(entry.effect), tooltipAdder, 1.0f, context.tickRate());
        }
    }

    public record MobEffectEntry(MobEffectInstance effect, int maxDuration, ShowTooltip showInTooltip) {
        private static final Codec<MobEffectEntry> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)MobEffectInstance.CODEC.fieldOf("effect").forGetter(MobEffectEntry::effect), (App)Codec.INT.optionalFieldOf("max_duration", (Object)Integer.MAX_VALUE).forGetter(MobEffectEntry::maxDuration), (App)ShowTooltip.CODEC.optionalFieldOf("show_in_tooltip", (Object)ShowTooltip.ALWAYS).forGetter(MobEffectEntry::showInTooltip)).apply((Applicative)inst, MobEffectEntry::new));
        public static final Codec<MobEffectEntry> CODEC = Codec.either(DIRECT_CODEC, (Codec)MobEffectInstance.CODEC).xmap(either -> (MobEffectEntry)either.map(mobEffectEntry -> mobEffectEntry, effectInstance -> new MobEffectEntry((MobEffectInstance)effectInstance, Integer.MAX_VALUE, ShowTooltip.ALWAYS)), Either::left);
        public static final StreamCodec<RegistryFriendlyByteBuf, MobEffectEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)MobEffectInstance.STREAM_CODEC, MobEffectEntry::effect, (StreamCodec)ByteBufCodecs.INT, MobEffectEntry::maxDuration, ShowTooltip.STREAM_CODEC, MobEffectEntry::showInTooltip, MobEffectEntry::new);

        public static enum ShowTooltip implements StringRepresentable
        {
            NEVER("never"),
            CREATIVE_MENU_ONLY("creative_menu_only"),
            ALWAYS("always");

            public static final Codec<ShowTooltip> CODEC;
            public static final StreamCodec<ByteBuf, ShowTooltip> STREAM_CODEC;
            final String name;

            private ShowTooltip(String name) {
                this.name = name;
            }

            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(ShowTooltip::values);
                STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
            }
        }
    }
}

