/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.data.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.BovinesCowTypes;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.block.BlockReference;
import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.api.codec.BovinesCodecs;
import house.greenhouse.bovinesandbuttercups.api.variant.CowModelLayer;
import house.greenhouse.bovinesandbuttercups.api.variant.OffspringConditions;
import house.greenhouse.bovinesandbuttercups.api.variant.model.BovinesCowModelTypes;
import house.greenhouse.bovinesandbuttercups.api.variant.model.CowModelType;
import house.greenhouse.bovinesandbuttercups.content.data.modifier.GrassTintTextureModifierFactory;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;

public record MoobloomConfiguration(CowConfiguration.Settings settings, BlockReference<Holder<CustomFlowerType>> flower, BlockReference<Holder<CustomFlowerType>> bud, CowModelType model, List<CowModelLayer> layers, Optional<ItemStack> nectar, Optional<ResourceLocation> lootTable, SimpleWeightedRandomList<Holder<CowVariant<?>>> sculkConverts, OffspringConditions offspringConditions) implements CowConfiguration
{
    public static final MapCodec<MoobloomConfiguration> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CowConfiguration.Settings.CODEC.forGetter(MoobloomConfiguration::settings), (App)BlockReference.createCodec(CustomFlowerType.CODEC, "custom_flower").fieldOf("flower").forGetter(MoobloomConfiguration::flower), (App)BlockReference.createCodec(CustomFlowerType.CODEC, "custom_flower").fieldOf("bud").forGetter(MoobloomConfiguration::bud), (App)BovinesRegistries.MODEL_TYPE.byNameCodec().optionalFieldOf("model", (Object)BovinesCowModelTypes.DEFAULT).forGetter(MoobloomConfiguration::model), (App)CowModelLayer.CODEC.listOf().optionalFieldOf("layers", List.of()).forGetter(MoobloomConfiguration::layers), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.optionalFieldOf("nectar").forGetter(MoobloomConfiguration::nectar), (App)ResourceLocation.CODEC.optionalFieldOf("shearing_loot_table").forGetter(MoobloomConfiguration::lootTable), (App)BovinesCodecs.weightedEntryCodec(CowVariant.CODEC, "type").optionalFieldOf("sculk_conversion_types", (Object)SimpleWeightedRandomList.empty()).forGetter(MoobloomConfiguration::sculkConverts), (App)OffspringConditions.CODEC.optionalFieldOf("offspring_conditions", (Object)OffspringConditions.EMPTY).forGetter(MoobloomConfiguration::offspringConditions)).apply((Applicative)builder, MoobloomConfiguration::new));

    @Override
    public void tick(Entity entity) {
        this.layers.forEach(cowModelLayer -> cowModelLayer.tickTextureModifiers(entity));
    }

    public List<WeightedEntry.Wrapper<Holder<CowVariant<MoobloomConfiguration>>>> filterSculkConverts() {
        return this.sculkConverts.unwrap().stream().filter(holderWrapper -> {
            boolean bl;
            boolean bl2 = bl = ((Holder)holderWrapper.data()).isBound() && ((CowVariant)((Holder)holderWrapper.data()).value()).type() == BovinesCowTypes.MOOBLOOM_TYPE;
            if (!bl) {
                BovinesAndButtercups.LOG.error("Attempted to add CowType '{}', which does not have CowTypeType '{}' to thunder conversion list.", ((Holder)holderWrapper.data()).unwrapKey().map(key -> key.location()).orElse(null), (Object)BovinesRegistries.COW_TYPE.getKey(BovinesCowTypes.MOOBLOOM_TYPE));
            }
            return bl;
        }).toList();
    }

    @Override
    public boolean hasSnow(Entity entity) {
        Moobloom moobloom;
        return entity instanceof Moobloom && (moobloom = (Moobloom)entity).hasSnow();
    }

    @Override
    public boolean allowsConversion(Entity entity) {
        Moobloom moobloom;
        return entity instanceof Moobloom && (moobloom = (Moobloom)entity).shouldAllowConversion();
    }

    public static MoobloomConfiguration createMissing(RegistryOps.RegistryInfoLookup lookup) {
        return new MoobloomConfiguration(new CowConfiguration.Settings(Optional.of(BovinesAndButtercups.asResource("bovinesandbuttercups/moobloom/missing_moobloom")), (SimpleWeightedRandomList<HolderSet<Biome>>)SimpleWeightedRandomList.empty(), SimpleWeightedRandomList.empty(), Optional.empty()), new BlockReference<Holder.Reference>(Optional.empty(), Optional.empty(), Optional.of(((RegistryOps.RegistryInfo)lookup.lookup(BovinesRegistryKeys.CUSTOM_FLOWER_TYPE).orElseThrow()).getter().getOrThrow(CustomFlowerType.MISSING_KEY))), new BlockReference<Holder.Reference>(Optional.empty(), Optional.empty(), Optional.of(((RegistryOps.RegistryInfo)lookup.lookup(BovinesRegistryKeys.CUSTOM_FLOWER_TYPE).orElseThrow()).getter().getOrThrow(CustomFlowerType.MISSING_KEY))), BovinesCowModelTypes.DEFAULT, List.of(new CowModelLayer(BovinesAndButtercups.asResource("bovinesandbuttercups/moobloom/moobloom_grass_layer"), List.of(new GrassTintTextureModifierFactory()))), Optional.empty(), Optional.empty(), SimpleWeightedRandomList.empty(), OffspringConditions.EMPTY);
    }
}

