/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.data.flowercrown;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record FlowerCrownMaterial(ItemStack ingredient, ItemTextures itemTextures, EquippedTextures equippedTextures, Component description) {
    public static final Codec<FlowerCrownMaterial> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("ingredient").forGetter(FlowerCrownMaterial::ingredient), (App)ItemTextures.CODEC.fieldOf("item_textures").forGetter(FlowerCrownMaterial::itemTextures), (App)EquippedTextures.CODEC.fieldOf("equipped_textures").forGetter(FlowerCrownMaterial::equippedTextures), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(FlowerCrownMaterial::description)).apply((Applicative)inst, FlowerCrownMaterial::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlowerCrownMaterial> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, FlowerCrownMaterial::ingredient, ItemTextures.STREAM_CODEC, FlowerCrownMaterial::itemTextures, EquippedTextures.STREAM_CODEC, FlowerCrownMaterial::equippedTextures, (StreamCodec)ComponentSerialization.STREAM_CODEC, FlowerCrownMaterial::description, FlowerCrownMaterial::new);
    public static final Codec<Holder<FlowerCrownMaterial>> CODEC = RegistryFileCodec.create(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<FlowerCrownMaterial>> STREAM_CODEC = ByteBufCodecs.holder(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL, DIRECT_STREAM_CODEC);

    public record ItemTextures(ResourceLocation topLeft, ResourceLocation top, ResourceLocation topRight, ResourceLocation centerLeft, ResourceLocation centerRight, ResourceLocation bottomLeft, ResourceLocation bottom, ResourceLocation bottomRight) {
        public static final Codec<ItemTextures> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("top_left").forGetter(ItemTextures::topLeft), (App)ResourceLocation.CODEC.fieldOf("top").forGetter(ItemTextures::top), (App)ResourceLocation.CODEC.fieldOf("top_right").forGetter(ItemTextures::topRight), (App)ResourceLocation.CODEC.fieldOf("center_left").forGetter(ItemTextures::centerLeft), (App)ResourceLocation.CODEC.fieldOf("center_right").forGetter(ItemTextures::centerRight), (App)ResourceLocation.CODEC.fieldOf("bottom_left").forGetter(ItemTextures::bottomLeft), (App)ResourceLocation.CODEC.fieldOf("bottom").forGetter(ItemTextures::bottom), (App)ResourceLocation.CODEC.fieldOf("bottom_right").forGetter(ItemTextures::bottomRight)).apply((Applicative)inst, ItemTextures::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemTextures> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemTextures>(){

            public ItemTextures decode(RegistryFriendlyByteBuf buffer) {
                return new ItemTextures(buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation());
            }

            public void encode(RegistryFriendlyByteBuf buffer, ItemTextures value) {
                buffer.writeResourceLocation(value.topLeft());
                buffer.writeResourceLocation(value.top());
                buffer.writeResourceLocation(value.topRight());
                buffer.writeResourceLocation(value.centerLeft());
                buffer.writeResourceLocation(value.centerRight());
                buffer.writeResourceLocation(value.bottomLeft());
                buffer.writeResourceLocation(value.bottom());
                buffer.writeResourceLocation(value.bottomRight());
            }
        };
    }

    public record EquippedTextures(ResourceLocation topLeft, ResourceLocation top, ResourceLocation topRight, ResourceLocation centerLeft, ResourceLocation centerRight, ResourceLocation bottomLeft, ResourceLocation bottom, ResourceLocation bottomRight) {
        public static final Codec<EquippedTextures> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("top_left").forGetter(EquippedTextures::topLeft), (App)ResourceLocation.CODEC.fieldOf("top").forGetter(EquippedTextures::top), (App)ResourceLocation.CODEC.fieldOf("top_right").forGetter(EquippedTextures::topRight), (App)ResourceLocation.CODEC.fieldOf("center_left").forGetter(EquippedTextures::centerLeft), (App)ResourceLocation.CODEC.fieldOf("center_right").forGetter(EquippedTextures::centerRight), (App)ResourceLocation.CODEC.fieldOf("bottom_left").forGetter(EquippedTextures::bottomLeft), (App)ResourceLocation.CODEC.fieldOf("bottom").forGetter(EquippedTextures::bottom), (App)ResourceLocation.CODEC.fieldOf("bottom_right").forGetter(EquippedTextures::bottomRight)).apply((Applicative)inst, EquippedTextures::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EquippedTextures> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EquippedTextures>(){

            public EquippedTextures decode(RegistryFriendlyByteBuf buffer) {
                return new EquippedTextures(buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation(), buffer.readResourceLocation());
            }

            public void encode(RegistryFriendlyByteBuf buffer, EquippedTextures value) {
                buffer.writeResourceLocation(value.topLeft());
                buffer.writeResourceLocation(value.top());
                buffer.writeResourceLocation(value.topRight());
                buffer.writeResourceLocation(value.centerLeft());
                buffer.writeResourceLocation(value.centerRight());
                buffer.writeResourceLocation(value.bottomLeft());
                buffer.writeResourceLocation(value.bottom());
                buffer.writeResourceLocation(value.bottomRight());
            }
        };

        public ResourceLocation get(int i) {
            return List.of(this.centerLeft, this.topLeft, this.top, this.topRight, this.centerRight, this.bottomRight, this.bottom, this.bottomLeft).get(i);
        }
    }
}

