/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.BovinesCowTypes;
import house.greenhouse.bovinesandbuttercups.api.BovinesCowVariants;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.api.variant.OffspringConditions;
import house.greenhouse.bovinesandbuttercups.content.advancement.criterion.BreedCowWithVariantTrigger;
import house.greenhouse.bovinesandbuttercups.content.block.BovinesBlocks;
import house.greenhouse.bovinesandbuttercups.content.block.entity.CustomFlowerBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomFlower;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MoobloomConfiguration;
import house.greenhouse.bovinesandbuttercups.content.entity.BovinesEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.loot.BovinesLootContextParamSets;
import house.greenhouse.bovinesandbuttercups.content.loot.BovinesLootContextParams;
import house.greenhouse.bovinesandbuttercups.content.sound.BovinesSoundEvents;
import house.greenhouse.bovinesandbuttercups.mixin.EntityAccessor;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncMoobloomSnowLayerClientboundPacket;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import house.greenhouse.bovinesandbuttercups.util.SnowLayerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Moobloom
extends Cow {
    private static final EntityDataAccessor<Integer> FLOWER_SPREAD_ATTEMPTS = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> POLLINATED_RESET_TICKS = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STANDING_STILL_FOR_BEE_TICKS = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ALLOW_SHEARING = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ALLOW_CONVERSION = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_SNOW = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SNOW_LAYER_PERSISTENT = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final int TICKS_UNTIL_SPREAD = 80;
    @Nullable
    public Bee bee = null;
    private boolean hasRefreshedDimensionsForLaying;
    @Nullable
    private BlockPos previousPos = null;
    private int ticksUntilSpread = -1;
    @Nullable
    private UUID lastLightningBoltUUID;
    private final Map<Holder<CowVariant<?>>, List<Vec3>> particlePositions = new HashMap();
    public final AnimationState layDownAnimationState = new AnimationState();
    public final AnimationState getUpAnimationState = new AnimationState();

    public Moobloom(EntityType<? extends Moobloom> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLOWER_SPREAD_ATTEMPTS, (Object)0);
        builder.define(POLLINATED_RESET_TICKS, (Object)0);
        builder.define(STANDING_STILL_FOR_BEE_TICKS, (Object)0);
        builder.define(ALLOW_SHEARING, (Object)true);
        builder.define(ALLOW_CONVERSION, (Object)true);
        builder.define(HAS_SNOW, (Object)false);
        builder.define(SNOW_LAYER_PERSISTENT, (Object)false);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new LookAtBeeGoal());
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Moobloom.class, 2.0f, 1.0, 1.0, moobloomEntity -> moobloomEntity instanceof Moobloom && ((Moobloom)((Object)moobloomEntity)).getStandingStillForBeeTicks() > 0));
        super.registerGoals();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("flower_spread_attempts", this.getFlowerSpreadAttempts());
        if (this.previousPos != null) {
            tag.put("previous_flower_pos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.previousPos).getOrThrow());
        }
        tag.putInt("ticks_until_spread", this.ticksUntilSpread);
        tag.putInt("pollinated_reset_ticks", this.getPollinatedResetTicks());
        tag.putBoolean("allow_shearing", this.shouldAllowShearing());
        tag.putBoolean("allow_conversion", this.shouldAllowConversion());
        tag.putBoolean("has_snow", this.hasSnow());
        if (this.isSnowLayerPersistent()) {
            tag.putBoolean("snow_layer_persistent", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.backwardsCompat(tag);
        if (tag.contains("flower_spread_attempts", 3)) {
            this.setFlowerSpreadAttempts(tag.getInt("flower_spread_attempts"));
        }
        if (tag.contains("previous_flower_pos", 11)) {
            this.previousPos = (BlockPos)((Pair)BlockPos.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("previous_flower_pos")).getOrThrow()).getFirst();
        }
        if (tag.contains("ticks_until_spread", 3)) {
            this.ticksUntilSpread = tag.getInt("ticks_until_spread");
        }
        if (tag.contains("pollinated_reset_ticks", 3)) {
            this.setPollinatedResetTicks(tag.getInt("pollinated_reset_ticks"));
        }
        if (tag.contains("allow_shearing", 1)) {
            this.setAllowShearing(tag.getBoolean("allow_shearing"));
        }
        if (tag.contains("allow_conversion", 1)) {
            this.setAllowConversion(tag.getBoolean("allow_conversion"));
        }
        if (tag.contains("has_snow", 1)) {
            this.setSnow(tag.getBoolean("has_snow"));
        }
        if (tag.contains("snow_layer_persistent", 1)) {
            this.setPersistentSnowLayer(tag.getBoolean("snow_layer_persistent"));
        }
    }

    public void backwardsCompat(CompoundTag tag) {
        if (tag.contains("Type", 8)) {
            Optional cowVariant = this.level().registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).get(ResourceLocation.parse((String)tag.getString("Type")));
            if (cowVariant.isEmpty()) {
                BovinesAndButtercups.LOG.error("Could not deserialize legacy cow type tag \"{}\" into a cow type holder.", (Object)tag.getString("Type"));
                return;
            }
            if (!((Holder.Reference)cowVariant.get()).isBound() || ((CowVariant)((Holder.Reference)cowVariant.get()).value()).type() != BovinesCowTypes.MOOBLOOM_TYPE) {
                BovinesAndButtercups.LOG.error("Cow Variant \"{}\" is not bound or is not a moobloom.", (Object)cowVariant);
                return;
            }
            if (tag.contains("PreviousType", 8)) {
                Optional previousCowType = this.level().registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).get(ResourceLocation.parse((String)tag.getString("Type")));
                if (previousCowType.isEmpty()) {
                    BovinesAndButtercups.LOG.error("Could not deserialize legacy cow type tag \"{}\" into a cow type holder.", (Object)tag.getString("Type"));
                    return;
                }
                if (!((Holder.Reference)previousCowType.get()).isBound() || ((CowVariant)((Holder.Reference)previousCowType.get()).value()).type() != BovinesCowTypes.MOOBLOOM_TYPE) {
                    BovinesAndButtercups.LOG.error("Previous Cow Variant \"{}\" is not bound or is not a moobloom.", (Object)cowVariant);
                    return;
                }
                BovinesAndButtercups.getHelper().setCowVariantAttachment((LivingEntity)this, new CowVariantAttachment((Holder)cowVariant.get(), previousCowType.map(cowVariantReference -> cowVariantReference)));
                CowVariantAttachment.sync((LivingEntity)this);
            } else {
                this.setCowVariant((Holder<CowVariant<MoobloomConfiguration>>)((Holder)cowVariant.get()));
                CowVariantAttachment.sync((LivingEntity)this);
            }
        }
        if (tag.contains("PollinatedResetTicks", 3)) {
            this.setPollinatedResetTicks(tag.getInt("PollinatedResetTicks"));
        }
        if (tag.contains("AllowShearing", 1)) {
            this.setAllowShearing(tag.getBoolean("AllowShearing"));
        }
    }

    public void setBee(@Nullable Bee value) {
        this.bee = value;
    }

    public static boolean canMoobloomSpawn(EntityType<? extends Moobloom> type, LevelAccessor level, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && Animal.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos) && Moobloom.getTotalSpawnWeight(level, pos) > 0;
    }

    public void thunderHit(ServerLevel level, LightningBolt bolt) {
        UUID uuid = bolt.getUUID();
        if (this.getCowVariant().isBound() && ((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).allowsConversion((Entity)this) && !uuid.equals(this.lastLightningBoltUUID)) {
            if (this.getPreviousCowVariant() == null) {
                if (((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).settings().thunderConverts().isEmpty()) {
                    super.thunderHit(level, bolt);
                    return;
                }
                List compatibleList = ((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).settings().filterThunderConverts(BovinesCowTypes.MOOBLOOM_TYPE);
                if (compatibleList.isEmpty()) {
                    super.thunderHit(level, bolt);
                    return;
                }
                if (compatibleList.size() == 1) {
                    this.setCurrentWithPreviousCowType((Holder<CowVariant<MoobloomConfiguration>>)((Holder)compatibleList.getFirst().data()));
                    CowVariantAttachment.sync((LivingEntity)this);
                } else {
                    int totalWeight = level.getRandom().nextInt(compatibleList.stream().map(holderWrapper -> holderWrapper.weight().asInt()).reduce(Integer::sum).orElse(0).intValue());
                    for (WeightedEntry.Wrapper cct : compatibleList) {
                        if ((totalWeight -= cct.weight().asInt()) >= 0) continue;
                        this.setCurrentWithPreviousCowType((Holder<CowVariant<MoobloomConfiguration>>)((Holder)cct.data()));
                        CowVariantAttachment.sync((LivingEntity)this);
                        break;
                    }
                }
            } else {
                this.setCowVariant(this.getPreviousCowVariant());
                CowVariantAttachment.sync((LivingEntity)this);
            }
            this.lastLightningBoltUUID = uuid;
            this.playSound(BovinesSoundEvents.MOOBLOOM_CONVERT, 2.0f, 1.0f);
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.isInvulnerableTo(level, source)) {
            return false;
        }
        if (this.bee != null) {
            this.setStandingStillForBeeTicks(0);
            this.bee = null;
        }
        return super.hurtServer(level, source, amount);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.getStandingStillForBeeTicks() > 0) {
                this.layDownAnimationState.startIfStopped(this.tickCount);
            } else if (this.layDownAnimationState.isStarted() && this.getStandingStillForBeeTicks() == 0) {
                this.layDownAnimationState.stop();
                this.getUpAnimationState.startIfStopped(this.tickCount);
            }
            if (this.getUpAnimationState.isStarted() && this.getUpAnimationState.getTimeInMillis((float)this.level().getGameTime()) >= 1000L) {
                this.getUpAnimationState.stop();
            }
        } else {
            if (this.ticksUntilSpread > 0) {
                --this.ticksUntilSpread;
            }
            if ((this.previousPos == null || this.blockPosition().distSqr((Vec3i)this.previousPos) > 4.0 || this.ticksUntilSpread == 0) && this.getFlowerSpreadAttempts() > 0) {
                if (this.spreadFlowers()) {
                    this.level().playSound(null, this.blockPosition(), BovinesSoundEvents.MOOBLOOM_PLANT, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.9f);
                    this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
                    this.setFlowerSpreadAttempts(this.getFlowerSpreadAttempts() - 1);
                    this.ticksUntilSpread = 80;
                    this.previousPos = this.blockPosition();
                }
                if (this.getFlowerSpreadAttempts() <= 0) {
                    this.previousPos = null;
                    this.ticksUntilSpread = -1;
                }
            }
            if (this.bee != null && !this.bee.isAlive()) {
                this.setStandingStillForBeeTicks(0);
                this.bee = null;
            }
            if (this.getStandingStillForBeeTicks() > 0 && !this.level().isClientSide()) {
                this.setStandingStillForBeeTicks(this.getStandingStillForBeeTicks() - 1);
            }
            if (!this.hasSnow() && this.isInSnowyWeather() && !this.isSnowLayerPersistent() && !this.level().isClientSide() && this.random.nextFloat() < 0.4f) {
                this.setSnow(true);
                BovinesAndButtercups.getHelper().sendTrackingClientboundPacket((Entity)this, new SyncMoobloomSnowLayerClientboundPacket(this.getId(), true));
            }
            if (this.hasSnow() && !this.isSnowLayerPersistent() && this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS) && this.random.nextFloat() < 0.4f) {
                this.setSnow(false);
                BovinesAndButtercups.getHelper().sendTrackingClientboundPacket((Entity)this, new SyncMoobloomSnowLayerClientboundPacket(this.getId(), false));
            }
            if (this.getPollinatedResetTicks() > 0) {
                this.setPollinatedResetTicks(this.getPollinatedResetTicks() - 1);
            }
        }
        if (this.getStandingStillForBeeTicks() > 0) {
            if (!this.hasRefreshedDimensionsForLaying) {
                this.refreshDimensions();
                ((EntityAccessor)((Object)this)).bovinesandbuttercups$setEyeHeight(this.getDimensions(this.getPose()).height() * 0.85f);
                this.hasRefreshedDimensionsForLaying = true;
            }
            if (!this.level().isClientSide() && this.bee != null) {
                this.getLookControl().setLookAt((Entity)this.bee);
            }
        } else if (this.hasRefreshedDimensionsForLaying) {
            this.refreshDimensions();
            ((EntityAccessor)((Object)this)).bovinesandbuttercups$setEyeHeight(this.getDimensions(this.getPose()).height() * 0.85f);
            this.hasRefreshedDimensionsForLaying = false;
        }
    }

    public boolean isInSnowyWeather() {
        BlockPos pos = this.blockPosition();
        if (this.isSnowingAt(pos)) {
            return true;
        }
        pos = BlockPos.containing((double)this.blockPosition().getX(), (double)this.getBoundingBox().maxY, (double)this.blockPosition().getZ());
        return this.isSnowingAt(pos);
    }

    private boolean isSnowingAt(BlockPos pos) {
        if (!this.level().isRaining()) {
            return false;
        }
        if (!this.level().canSeeSky(pos)) {
            return false;
        }
        if (this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return false;
        }
        Biome biome = (Biome)this.level().getBiome(pos).value();
        return biome.getPrecipitationAt(pos, this.level().getSeaLevel()) == Biome.Precipitation.SNOW;
    }

    public boolean spreadFlowers() {
        if (this.level().isClientSide) {
            return true;
        }
        BlockState state = null;
        if (((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).flower().blockState().isPresent()) {
            state = ((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).flower().blockState().get().getBlock().defaultBlockState();
        } else if (((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).flower().customType().isPresent()) {
            state = BovinesBlocks.CUSTOM_FLOWER.defaultBlockState();
        }
        if (state == null) {
            BovinesAndButtercups.LOG.warn("Moobloom with type '{}' tried to spread flowers without a valid flower type.", (Object)this.getCowVariant().getRegisteredName());
            return true;
        }
        int maxTries = 5;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        boolean hasSetAFlower = false;
        for (int i = 0; i < maxTries; ++i) {
            if (this.random.nextFloat() > 0.75f) continue;
            pos.setWithOffset((Vec3i)this.blockPosition(), this.random.nextIntBetweenInclusive(-1, 1), 0, this.random.nextIntBetweenInclusive(-1, 1));
            if (!this.level().getBlockState((BlockPos)pos).isAir() || !state.canSurvive((LevelReader)this.level(), (BlockPos)pos)) {
                pos.offset(0, 1, 0);
            }
            if (!state.canSurvive((LevelReader)this.level(), (BlockPos)pos) || !this.level().getBlockState((BlockPos)pos).isAir()) continue;
            this.setBlockToFlower(state, pos.immutable());
            hasSetAFlower = true;
        }
        this.gameEvent((Holder)GameEvent.BLOCK_PLACE, (Entity)this);
        return hasSetAFlower;
    }

    public void setBlockToFlower(BlockState state, BlockPos pos) {
        if (this.level().isClientSide || !state.canSurvive((LevelReader)this.level(), pos.below())) {
            return;
        }
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.3, (double)pos.getZ() + 0.5, 4, 0.2, 0.1, 0.2, 0.0);
        if (state.getBlock() == BovinesBlocks.CUSTOM_FLOWER && ((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).flower().customType().isPresent()) {
            this.level().setBlock(pos, state, 3);
            BlockEntity blockEntity = this.level().getBlockEntity(pos);
            if (blockEntity instanceof CustomFlowerBlockEntity) {
                CustomFlowerBlockEntity customFlowerBlockEntity = (CustomFlowerBlockEntity)blockEntity;
                customFlowerBlockEntity.setFlowerType(new ItemCustomFlower(((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).flower().customType().get()));
                customFlowerBlockEntity.setChanged();
            }
        } else {
            this.level().setBlock(pos, state, 3);
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.getStandingStillForBeeTicks() > 0) {
            return super.getDefaultDimensions(pose).scale(1.0f, 0.7f);
        }
        return super.getDefaultDimensions(pose);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isBaby()) {
            if (stack.is(Items.BONE_MEAL) && this.feed()) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.is(Items.BOWL)) {
                if (!((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).nectar().isPresent()) {
                    return InteractionResult.PASS;
                }
                ItemStack stack2 = ((MoobloomConfiguration)((CowVariant)this.getCowVariant().value()).configuration()).nectar().get();
                ItemStack stack3 = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)stack2, (boolean)false);
                player.setItemInHand(hand, stack3);
                this.playSound(BovinesSoundEvents.MOOBLOOM_MILK, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if ((result = SnowLayerUtil.removeSnowIfShovel((Entity)this, player, hand, stack)) != InteractionResult.PASS) {
            return result;
        }
        return super.mobInteract(player, hand);
    }

    public boolean feed() {
        if (this.getFlowerSpreadAttempts() >= 8) {
            return false;
        }
        if (!this.level().isClientSide) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.position().x(), this.position().y() + 1.6, this.position().z(), 8, 0.5, 0.1, 0.4, 0.0);
            this.previousPos = this.blockPosition();
            this.ticksUntilSpread = 80;
            this.setFlowerSpreadAttempts(this.getFlowerSpreadAttempts() + 8);
        }
        this.playSound(BovinesSoundEvents.MOOBLOOM_EAT, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
        return true;
    }

    public Pair<Holder<CowVariant<MoobloomConfiguration>>, Optional<Holder<CowVariant<MoobloomConfiguration>>>> chooseBabyType(ServerLevel level, Moobloom otherParent, Moobloom child) {
        ArrayList<Holder.Reference> eligibleCowTypes = new ArrayList<Holder.Reference>();
        Iterator<Holder.Reference> iterator = level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).registryKeySet().stream().map(key -> this.level().registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(key)).filter(type -> type.isBound() && ((CowVariant)type.value()).type() == BovinesCowTypes.MOOBLOOM_TYPE && ((MoobloomConfiguration)((CowVariant)type.value()).configuration()).offspringConditions() != OffspringConditions.EMPTY).toList().iterator();
        while (iterator.hasNext()) {
            Holder.Reference cowVariant;
            Holder.Reference moobloomType = cowVariant = iterator.next();
            OffspringConditions conditions = ((MoobloomConfiguration)((CowVariant)moobloomType.value()).configuration()).offspringConditions();
            LootParams.Builder params = new LootParams.Builder(level);
            params.withParameter(LootContextParams.THIS_ENTITY, (Object)this);
            params.withParameter(BovinesLootContextParams.PARTNER, (Object)otherParent);
            params.withParameter(BovinesLootContextParams.CHILD, (Object)child);
            params.withParameter(LootContextParams.ORIGIN, (Object)this.position());
            params.withParameter(BovinesLootContextParams.BREEDING_TYPE, (Object)cowVariant);
            LootContext thisContext = new LootContext.Builder(params.create(BovinesLootContextParamSets.BREEDING)).create(Optional.empty());
            params.withParameter(LootContextParams.THIS_ENTITY, (Object)otherParent);
            params.withParameter(BovinesLootContextParams.PARTNER, (Object)this);
            LootContext otherContext = new LootContext.Builder(params.create(BovinesLootContextParamSets.BREEDING)).create(Optional.empty());
            if ((!conditions.thisConditions().stream().allMatch(condition -> condition.test((Object)thisContext)) || !conditions.otherConditions().stream().allMatch(condition -> condition.test((Object)otherContext))) && (!conditions.thisConditions().stream().allMatch(condition -> condition.test((Object)otherContext)) || !conditions.otherConditions().stream().allMatch(condition -> condition.test((Object)thisContext)))) continue;
            eligibleCowTypes.add(moobloomType);
        }
        if (!eligibleCowTypes.isEmpty()) {
            int random = this.getRandom().nextInt(eligibleCowTypes.size());
            Holder randomType = (Holder)eligibleCowTypes.get(random);
            child.createParticles((Holder<CowVariant<MoobloomConfiguration>>)randomType, this.position());
            if (this.getLoveCause() != null) {
                BreedCowWithVariantTrigger.INSTANCE.trigger(this.getLoveCause(), (Animal)this, (Animal)otherParent, (AgeableMob)child, true, randomType);
            }
            return ((MoobloomConfiguration)((CowVariant)randomType.value()).configuration()).offspringConditions().inheritance().handleInheritance(randomType, BovinesAndButtercups.getHelper().getCowVariantAttachment((LivingEntity)this), BovinesAndButtercups.getHelper().getCowVariantAttachment((LivingEntity)otherParent));
        }
        child.particlePositions.clear();
        if (!otherParent.getCowVariant().equals(this.getCowVariant()) && this.getRandom().nextBoolean()) {
            if (this.getLoveCause() != null) {
                BreedCowWithVariantTrigger.INSTANCE.trigger(this.getLoveCause(), (Animal)this, (Animal)otherParent, (AgeableMob)child, false, otherParent.getCowVariant());
            }
            return Pair.of(otherParent.getCowVariant(), Optional.ofNullable(otherParent.getPreviousCowVariant()));
        }
        if (this.getLoveCause() != null) {
            BreedCowWithVariantTrigger.INSTANCE.trigger(this.getLoveCause(), (Animal)this, (Animal)otherParent, (AgeableMob)child, false, this.getCowVariant());
        }
        return Pair.of(this.getCowVariant(), Optional.ofNullable(this.getPreviousCowVariant()));
    }

    public void addParticlePosition(Holder<CowVariant<?>> type, Vec3 pos) {
        this.particlePositions.computeIfAbsent(type, holder -> new ArrayList()).add(pos);
    }

    public void createParticles(Holder<CowVariant<MoobloomConfiguration>> type, Vec3 parentPos) {
        if (!type.isBound() || ((MoobloomConfiguration)((CowVariant)type.value()).configuration()).settings().particle().isEmpty()) {
            return;
        }
        if (this.particlePositions.isEmpty() && !this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles(((MoobloomConfiguration)((CowVariant)type.value()).configuration()).settings().particle().get(), this.getX(), this.getY(0.5), this.getZ(), 6, 0.05, 0.05, 0.05, 0.01);
        } else {
            for (Vec3 pos : this.particlePositions.get(type)) {
                this.createParticleTrail(pos, parentPos, ((MoobloomConfiguration)((CowVariant)type.value()).configuration()).settings().particle().get());
            }
        }
        this.particlePositions.clear();
    }

    public void createParticleTrail(Vec3 pos, Vec3 parentPos, ParticleOptions options) {
        double value = (1.0 - 1.0 / (pos.distanceTo(this.position()) + 1.0)) / 4.0;
        for (double d = 0.0; d < 1.0; d += value) {
            ((ServerLevel)this.level()).sendParticles(options, Mth.lerp((double)d, (double)pos.x(), (double)parentPos.x()), Mth.lerp((double)d, (double)pos.y(), (double)parentPos.y()), Mth.lerp((double)d, (double)pos.z(), (double)parentPos.z()), 1, 0.05, 0.05, 0.05, 0.01);
        }
    }

    public Moobloom getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        Moobloom moobloom = (Moobloom)BovinesEntityTypes.MOOBLOOM.create((Level)level, EntitySpawnReason.BREEDING);
        Pair<Holder<CowVariant<MoobloomConfiguration>>, Optional<Holder<CowVariant<MoobloomConfiguration>>>> pair = this.chooseBabyType(level, (Moobloom)otherParent, moobloom);
        CowVariantAttachment.setCowVariant((LivingEntity)moobloom, (Holder)pair.getFirst(), (Optional)pair.getSecond());
        return moobloom;
    }

    public Holder<CowVariant<MoobloomConfiguration>> getCowVariant() {
        return (Holder)Optional.ofNullable(CowVariantAttachment.getCowVariantHolderFromEntity((LivingEntity)this, BovinesCowTypes.MOOBLOOM_TYPE)).orElse(this.level().registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(BovinesCowVariants.MoobloomKeys.MISSING_MOOBLOOM));
    }

    @Nullable
    public Holder<CowVariant<MoobloomConfiguration>> getPreviousCowVariant() {
        return CowVariantAttachment.getPreviousCowVariantHolderFromEntity((LivingEntity)this, BovinesCowTypes.MOOBLOOM_TYPE);
    }

    public void setCowVariant(Holder<CowVariant<MoobloomConfiguration>> value) {
        CowVariantAttachment.setCowVariant((LivingEntity)this, value);
    }

    public void setCowVariant(Holder<CowVariant<MoobloomConfiguration>> value, Holder<CowVariant<MoobloomConfiguration>> previous) {
        CowVariantAttachment.setCowVariant((LivingEntity)this, value, previous);
    }

    public void setCurrentWithPreviousCowType(Holder<CowVariant<MoobloomConfiguration>> value) {
        CowVariantAttachment.setCowVariant((LivingEntity)this, value, this.getCowVariant());
    }

    public int getFlowerSpreadAttempts() {
        return (Integer)this.entityData.get(FLOWER_SPREAD_ATTEMPTS);
    }

    public void setFlowerSpreadAttempts(int value) {
        this.entityData.set(FLOWER_SPREAD_ATTEMPTS, (Object)value);
    }

    public int getPollinatedResetTicks() {
        return (Integer)this.entityData.get(POLLINATED_RESET_TICKS);
    }

    public void setPollinatedResetTicks(int value) {
        this.entityData.set(POLLINATED_RESET_TICKS, (Object)value);
    }

    public int getStandingStillForBeeTicks() {
        return (Integer)this.entityData.get(STANDING_STILL_FOR_BEE_TICKS);
    }

    public void setStandingStillForBeeTicks(int value) {
        this.entityData.set(STANDING_STILL_FOR_BEE_TICKS, (Object)value);
    }

    public boolean shouldAllowShearing() {
        return (Boolean)this.entityData.get(ALLOW_SHEARING);
    }

    public void setAllowShearing(boolean value) {
        this.entityData.set(ALLOW_SHEARING, (Object)value);
    }

    public boolean shouldAllowConversion() {
        return (Boolean)this.entityData.get(ALLOW_CONVERSION);
    }

    public void setAllowConversion(boolean value) {
        this.entityData.set(ALLOW_CONVERSION, (Object)value);
    }

    public boolean hasSnow() {
        return (Boolean)this.entityData.get(HAS_SNOW);
    }

    public void setSnow(boolean value) {
        this.entityData.set(HAS_SNOW, (Object)value);
    }

    public boolean isSnowLayerPersistent() {
        return (Boolean)this.entityData.get(SNOW_LAYER_PERSISTENT);
    }

    public void setPersistentSnowLayer(boolean value) {
        this.entityData.set(SNOW_LAYER_PERSISTENT, (Object)value);
    }

    public static int getTotalSpawnWeight(LevelAccessor level, BlockPos pos) {
        int totalWeight = 0;
        for (CowVariant cowVariant2 : level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).stream().filter(cowVariant -> cowVariant.configuration() instanceof MoobloomConfiguration).toList()) {
            MoobloomConfiguration configuration;
            Optional<WeightedEntry.Wrapper> biome;
            Object c = cowVariant2.configuration();
            if (!(c instanceof MoobloomConfiguration) || !(biome = (configuration = (MoobloomConfiguration)c).settings().biomes().unwrap().stream().filter(holderSetWrapper -> ((HolderSet)holderSetWrapper.data()).contains(level.getBiome(pos))).findFirst()).isPresent()) continue;
            totalWeight += biome.get().weight().asInt();
        }
        return totalWeight;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnType, @Nullable SpawnGroupData data) {
        if (spawnType != EntitySpawnReason.STRUCTURE) {
            if (data == null) {
                data = new MoobloomGroupData();
            }
            this.setCowVariant(((MoobloomGroupData)((Object)data)).getSpawnType(this.blockPosition(), level, level.getRandom()));
        }
        CowVariantAttachment.sync((LivingEntity)this);
        return super.finalizeSpawn(level, difficulty, spawnType, data);
    }

    public class LookAtBeeGoal
    extends Goal {
        public LookAtBeeGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return Moobloom.this.getStandingStillForBeeTicks() > 0;
        }

        public void start() {
            Moobloom.this.getNavigation().stop();
        }
    }

    public static class MoobloomGroupData
    extends AgeableMob.AgeableMobGroupData {
        public MoobloomGroupData() {
            super(true);
        }

        public Holder<CowVariant<MoobloomConfiguration>> getSpawnType(BlockPos pos, ServerLevelAccessor level, RandomSource random) {
            if (Moobloom.getTotalSpawnWeight((LevelAccessor)level, pos) > 0) {
                return this.getMoobloomSpawnTypeDependingOnBiome(level, pos, random);
            }
            return this.getMostCommonMoobloomSpawnVariant(level, random);
        }

        public Holder<CowVariant<MoobloomConfiguration>> getMostCommonMoobloomSpawnVariant(ServerLevelAccessor level, RandomSource random) {
            Registry registry = level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT);
            int largestWeight = 0;
            Holder.Reference finalCowVariant = registry.getOrThrow(BovinesCowVariants.MoobloomKeys.MISSING_MOOBLOOM);
            for (Holder holder : registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(cowVariant -> cowVariant.isBound() && ((CowVariant)cowVariant.value()).configuration() instanceof MoobloomConfiguration && ((CowVariant)cowVariant.value()).configuration() != ((CowVariant)cowVariant.value()).type().defaultConfig()).toList()) {
                MoobloomConfiguration configuration;
                int max;
                Object c = ((CowVariant)holder.value()).configuration();
                if (!(c instanceof MoobloomConfiguration) || (max = (configuration = (MoobloomConfiguration)c).settings().biomes().unwrap().stream().map(wrapper -> wrapper.weight().asInt()).max(Comparator.comparingInt(value -> value)).orElse(0).intValue()) <= largestWeight) continue;
                finalCowVariant = holder;
                largestWeight = max;
            }
            return finalCowVariant;
        }

        public Holder<CowVariant<MoobloomConfiguration>> getMoobloomSpawnTypeDependingOnBiome(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
            Registry registry = level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT);
            ArrayList<Holder.Reference> moobloomList = new ArrayList<Holder.Reference>();
            int totalWeight = 0;
            for (Holder.Reference cowVariant2 : registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(cowVariant -> cowVariant.isBound() && ((CowVariant)cowVariant.value()).configuration() instanceof MoobloomConfiguration && ((CowVariant)cowVariant.value()).configuration() != ((CowVariant)cowVariant.value()).type().defaultConfig()).toList()) {
                MoobloomConfiguration moobloomConfiguration;
                Optional<WeightedEntry.Wrapper> biome;
                Object c = ((CowVariant)cowVariant2.value()).configuration();
                if (!(c instanceof MoobloomConfiguration) || !(biome = (moobloomConfiguration = (MoobloomConfiguration)c).settings().biomes().unwrap().stream().filter(holderSetWrapper -> ((HolderSet)holderSetWrapper.data()).contains(level.getBiome(pos))).findFirst()).isPresent()) continue;
                moobloomList.add(cowVariant2);
                totalWeight += biome.get().weight().asInt();
            }
            if (moobloomList.size() == 1) {
                return (Holder)moobloomList.getFirst();
            }
            if (!moobloomList.isEmpty()) {
                int r = Mth.nextInt((RandomSource)random, (int)0, (int)(totalWeight - 1));
                for (Holder holder : moobloomList) {
                    int max = ((MoobloomConfiguration)((CowVariant)holder.value()).configuration()).settings().biomes().unwrap().stream().filter(wrapper -> ((HolderSet)wrapper.data()).contains(level.getBiome(pos))).map(wrapper -> wrapper.weight().asInt()).max(Comparator.comparingInt(value -> value)).orElse(0);
                    if (!((double)(r -= max) < 0.0)) continue;
                    return holder;
                }
            }
            return registry.getOrThrow(BovinesCowVariants.MoobloomKeys.MISSING_MOOBLOOM);
        }
    }
}

