/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.entity.goal;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.mixin.BeeAccessor;
import house.greenhouse.bovinesandbuttercups.mixin.MobAccessor;
import java.util.EnumSet;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.Vec3;

public class MoveToMoobloomGoal
extends Bee.BaseBeeGoal {
    private int ticks;
    private final Bee bee;

    public MoveToMoobloomGoal(Bee bee) {
        super(bee);
        this.bee = bee;
        this.ticks = bee.level().random.nextInt(10);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canBeeUse() {
        return !this.bee.hasRestriction() && this.shouldMoveToMoobloom() && BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).isPresent() && ((ServerLevel)this.bee.level()).getEntity(BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).get()) != null && !this.bee.blockPosition().closerToCenterThan((Position)((ServerLevel)this.bee.level()).getEntity(BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).get()).position(), 2.0);
    }

    public boolean canBeeContinueToUse() {
        return this.canBeeUse();
    }

    public void start() {
        this.ticks = 0;
        super.start();
    }

    public void stop() {
        this.ticks = 0;
        ((MobAccessor)this.bee).bovinesandbuttercups$getNavigation().stop();
        ((MobAccessor)this.bee).bovinesandbuttercups$getNavigation().resetMaxVisitedNodesMultiplier();
    }

    public void tick() {
        if (BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).isEmpty()) {
            return;
        }
        Entity entity = ((ServerLevel)this.bee.level()).getEntity(BovinesAndButtercups.getHelper().getPollinatingMoobloom(this.bee).get());
        if (!(entity instanceof Moobloom)) {
            return;
        }
        Moobloom moobloom = (Moobloom)entity;
        ++this.ticks;
        if (this.ticks > this.adjustedTickDelay(600)) {
            BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, null);
            return;
        }
        if (((MobAccessor)this.bee).bovinesandbuttercups$getNavigation().isInProgress()) {
            return;
        }
        if (!this.bee.position().closerThan((Position)moobloom.position(), 32.0)) {
            BovinesAndButtercups.getHelper().setPollinatingMoobloom(this.bee, null);
            return;
        }
        this.startMovingTo(this.bee, moobloom.position().add(0.0, moobloom.getBoundingBox().getYsize() * 1.5, 0.0));
    }

    void startMovingTo(Bee bee, Vec3 pos) {
        Vec3 vec32;
        int i = 0;
        Vec3 beePos = bee.position();
        double j = pos.y - beePos.y;
        if (j > 2.0) {
            i = 4;
        } else if (j < -2.0) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        double m = beePos.distanceToSqr(pos);
        if (m < 15.0) {
            k = (int)Math.round(m / 2.0);
            l = (int)Math.round(m / 2.0);
        }
        if ((vec32 = AirRandomPos.getPosTowards((PathfinderMob)bee, (int)k, (int)l, (int)i, (Vec3)pos, (double)0.3141592741012573)) != null) {
            ((MobAccessor)bee).bovinesandbuttercups$getNavigation().setMaxVisitedNodesMultiplier(0.5f);
            ((MobAccessor)bee).bovinesandbuttercups$getNavigation().moveTo(vec32.x, vec32.y, vec32.z, 1.0);
        }
    }

    private boolean shouldMoveToMoobloom() {
        return ((BeeAccessor)this.bee).bovinesandbuttercups$getTicksWithoutNectarSinceExitingHive() > 2400;
    }
}

