/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.item;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomFlower;
import house.greenhouse.bovinesandbuttercups.util.BlockUtil;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.block.Block;

public class CustomFlowerItem
extends BlockItem {
    public CustomFlowerItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public Component getName(ItemStack stack) {
        ItemCustomFlower flower;
        if (stack.has(BovinesDataComponents.CUSTOM_FLOWER) && (flower = (ItemCustomFlower)stack.get(BovinesDataComponents.CUSTOM_FLOWER)).holder().isBound()) {
            return BlockUtil.getOrCreateItemNameTranslationKey(((ResourceKey)flower.holder().unwrapKey().orElseThrow()).location());
        }
        return BlockUtil.getOrCreateItemNameTranslationKey(BovinesAndButtercups.asResource("missing_flower"));
    }

    public static Optional<SuspiciousStewEffects> getSuspiciousStewEffects(ItemStack stack) {
        ItemCustomFlower flower;
        if (stack.has(BovinesDataComponents.CUSTOM_FLOWER) && (flower = (ItemCustomFlower)stack.get(BovinesDataComponents.CUSTOM_FLOWER)).holder().isBound()) {
            SuspiciousStewEffects effects = ((CustomFlowerType)flower.holder().value()).stewEffectInstances();
            return effects.effects().isEmpty() ? Optional.empty() : Optional.of(effects);
        }
        return Optional.empty();
    }
}

