/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.item;

import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NectarBowlItem
extends Item {
    public NectarBowlItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        Consumable consumable = (Consumable)stack.get(DataComponents.CONSUMABLE);
        if (consumable != null) {
            for (ConsumeEffect effect : consumable.onConsumeEffects()) {
                if (!(effect instanceof ApplyStatusEffectsConsumeEffect)) continue;
                ApplyStatusEffectsConsumeEffect applyEffect = (ApplyStatusEffectsConsumeEffect)effect;
                for (MobEffectInstance instance : applyEffect.effects()) {
                    components.add((Component)Component.translatable((String)"potion.bovinesandbuttercups.lockdown", (Object[])new Object[]{Component.translatable((String)instance.getDescriptionId()), MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)context.tickRate())}).withStyle(((MobEffect)BovinesEffects.LOCKDOWN.value()).getCategory().getTooltipFormatting()));
                }
            }
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity living) {
        return 32;
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }
}

