/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.codec.BovinesCodecs;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.content.loot.BovinesLootContextParams;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import java.util.Comparator;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public record BlockInRadiusCondition(BlockPredicate predicate, AABB radius) implements LootItemCondition
{
    public static final MapCodec<BlockInRadiusCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockPredicate.CODEC.fieldOf("block").forGetter(BlockInRadiusCondition::predicate), (App)BovinesCodecs.AABB.fieldOf("radius").forGetter(BlockInRadiusCondition::radius)).apply((Applicative)inst, BlockInRadiusCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public boolean test(LootContext context) {
        Vec3 origin = (Vec3)context.getParameter(LootContextParams.ORIGIN);
        AABB aabb = this.radius.move(origin);
        return BlockPos.betweenClosedStream((AABB)aabb).map(BlockPos::immutable).sorted(Comparator.comparing(pos -> origin.distanceTo(pos.getCenter()))).toList().stream().anyMatch(pos -> {
            BlockState state = context.getLevel().getBlockState(pos);
            boolean bl = this.predicate.matches(context.getLevel(), pos);
            if (bl && context.hasParameter(BovinesLootContextParams.BREEDING_TYPE) && context.hasParameter(BovinesLootContextParams.CHILD)) {
                Entity child = (Entity)context.getParameter(BovinesLootContextParams.CHILD);
                if (child instanceof Moobloom) {
                    Moobloom moobloom = (Moobloom)child;
                    VoxelShape shape = state.getCollisionShape((BlockGetter)context.getLevel(), pos);
                    moobloom.addParticlePosition((Holder)context.getParameter(BovinesLootContextParams.BREEDING_TYPE), shape.isEmpty() || state.isCollisionShapeFullBlock((BlockGetter)context.getLevel(), pos) ? pos.getCenter() : shape.bounds().getCenter().add(Vec3.atLowerCornerOf((Vec3i)pos)));
                } else if (child instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)child;
                    if (BovinesRegistries.COW_TYPE.stream().anyMatch(cowType -> cowType.isApplicable(child))) {
                        VoxelShape shape = state.getCollisionShape((BlockGetter)context.getLevel(), pos);
                        BovinesAndButtercups.getHelper().addParticlePosition(living, (Holder)context.getParameter(BovinesLootContextParams.BREEDING_TYPE), shape.isEmpty() || state.isCollisionShapeFullBlock((BlockGetter)context.getLevel(), pos) ? pos.getCenter() : shape.bounds().getCenter().add(Vec3.atLowerCornerOf((Vec3i)pos)));
                    }
                }
            }
            return bl;
        });
    }

    public LootItemConditionType getType() {
        return TYPE;
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final BlockPredicate block;
        private AABB radius = AABB.ofSize((Vec3)Vec3.ZERO, (double)0.0, (double)0.0, (double)0.0);

        public Builder(BlockPredicate block) {
            this.block = block;
        }

        public Builder(BlockPredicate.Builder block) {
            this.block = block.build();
        }

        public Builder withRadius(double xz, double y) {
            this.radius = AABB.ofSize((Vec3)Vec3.ZERO, (double)xz, (double)y, (double)xz);
            return this;
        }

        public Builder withOffset(double x, double y, double z) {
            this.radius = this.radius.move(x, y, z);
            return this;
        }

        public LootItemCondition build() {
            return new BlockInRadiusCondition(this.block, this.radius);
        }
    }
}

