/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record CowSubPredicate(Optional<Holder<CowVariant<?>>> type, Optional<Boolean> hasSnow) implements EntitySubPredicate
{
    public static final MapCodec<CowSubPredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RegistryFixedCodec.create(BovinesRegistryKeys.COW_VARIANT).optionalFieldOf("variant").forGetter(CowSubPredicate::type), (App)Codec.BOOL.optionalFieldOf("has_snow").forGetter(CowSubPredicate::hasSnow)).apply((Applicative)inst, CowSubPredicate::new));

    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        CowVariantAttachment attachment;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (level.registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).stream().noneMatch(cowVariant -> cowVariant.type().isApplicable(entity))) {
            return false;
        }
        if (this.type.isPresent()) {
            attachment = BovinesAndButtercups.getHelper().getCowVariantAttachment(living);
            if (attachment == null) {
                return false;
            }
            if (attachment.cowVariant().isBound() && ((CowVariant)attachment.cowVariant().value()).type().isApplicable(entity) && attachment.cowVariant().is(this.type.get())) {
                return false;
            }
        }
        if (this.hasSnow.isPresent()) {
            attachment = BovinesAndButtercups.getHelper().getCowVariantAttachment(living);
            if (attachment == null) {
                return false;
            }
            if (attachment.cowVariant().isBound() && !((CowVariant)attachment.cowVariant().value()).configuration().hasSnow(entity)) {
                return false;
            }
        }
        return true;
    }
}

