/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.content.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemEdible;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import house.greenhouse.bovinesandbuttercups.content.recipe.BovinesRecipeSerializers;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SuspiciousEdibleRecipe
extends CustomRecipe {
    private final ShapedRecipePattern pattern;
    private final Holder<EdibleBlockType> edibleType;
    private final String group;
    private final boolean symmetrical;
    @Nullable
    private PlacementInfo placementInfo;

    public SuspiciousEdibleRecipe(CraftingBookCategory category, ShapedRecipePattern pattern, Holder<EdibleBlockType> edibleType, String group) {
        super(category);
        this.pattern = pattern;
        this.edibleType = edibleType;
        this.group = group;
        this.symmetrical = Util.isSymmetrical((int)pattern.width(), (int)pattern.height(), (List)pattern.ingredients());
    }

    public boolean matches(CraftingInput input, Level level) {
        if ((long)input.ingredientCount() != this.pattern.ingredients().stream().flatMap(Optional::stream).count()) {
            return false;
        }
        for (int i = 0; i < this.pattern.height(); ++i) {
            for (int j = 0; j < this.pattern.width(); ++j) {
                ItemStack stack;
                Optional ingredient = this.symmetrical ? (Optional)this.pattern.ingredients().get(this.pattern.width() - j - 1 + i * this.pattern.width()) : (Optional)this.pattern.ingredients().get(j + i * this.pattern.width());
                if (Ingredient.testOptionalIngredient((Optional)ingredient, (ItemStack)(stack = input.getItem(j, i))) || stack.is(Items.SUSPICIOUS_STEW) && Ingredient.testOptionalIngredient((Optional)ingredient, (ItemStack)new ItemStack((ItemLike)Items.SUSPICIOUS_STEW))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack suspiciousStew = input.items().stream().filter(stack -> stack.is(Items.SUSPICIOUS_STEW)).findFirst().orElse(new ItemStack((ItemLike)Items.SUSPICIOUS_STEW));
        ItemStack returnStack = new ItemStack((ItemLike)BovinesItems.PLACEABLE_EDIBLE);
        List<ItemEdible.MobEffectEntry> entries = ((SuspiciousStewEffects)suspiciousStew.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)SuspiciousStewEffects.EMPTY)).effects().stream().map(entry -> new ItemEdible.MobEffectEntry(new MobEffectInstance(entry.effect(), Mth.ceil((float)((float)entry.duration() / 4.0f))), entry.duration(), ItemEdible.MobEffectEntry.ShowTooltip.CREATIVE_MENU_ONLY)).toList();
        returnStack.set(BovinesDataComponents.EDIBLE_TYPE, (Object)new ItemEdible(this.edibleType, entries));
        return returnStack.copyWithCount(4);
    }

    public ShapedRecipePattern getPattern() {
        return this.pattern;
    }

    public Holder<EdibleBlockType> getEdibleType() {
        return this.edibleType;
    }

    public String group() {
        return this.group;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals((List)this.pattern.ingredients());
        }
        return this.placementInfo;
    }

    public RecipeSerializer<SuspiciousEdibleRecipe> getSerializer() {
        return BovinesRecipeSerializers.SUSPICIOUS_EDIBLE;
    }

    public static class Serializer
    implements RecipeSerializer<SuspiciousEdibleRecipe> {
        public static final MapCodec<SuspiciousEdibleRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.fieldOf("pattern").forGetter(SuspiciousEdibleRecipe::getPattern), (App)EdibleBlockType.CODEC.fieldOf("result").forGetter(SuspiciousEdibleRecipe::getEdibleType), (App)Codec.STRING.fieldOf("group").forGetter(SuspiciousEdibleRecipe::group)).apply((Applicative)inst, SuspiciousEdibleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SuspiciousEdibleRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CustomRecipe::category, (StreamCodec)ShapedRecipePattern.STREAM_CODEC, SuspiciousEdibleRecipe::getPattern, (StreamCodec)ByteBufCodecs.holderRegistry(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE), SuspiciousEdibleRecipe::getEdibleType, (StreamCodec)ByteBufCodecs.STRING_UTF8, SuspiciousEdibleRecipe::group, SuspiciousEdibleRecipe::new);

        public MapCodec<SuspiciousEdibleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SuspiciousEdibleRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

