/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.integration.recipe;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.FlowerCrown;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.BovinesFlowerCrownMaterials;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.FlowerCrownMaterial;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BovinesRecipeViewerUtil {
    private static final ResourceKey<FlowerCrownMaterial> MONOCOLOR = ResourceKey.create(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL, (ResourceLocation)BovinesAndButtercups.asResource("monocolor"));
    private static final ResourceKey<FlowerCrownMaterial> RANDOM_TWO = ResourceKey.create(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL, (ResourceLocation)BovinesAndButtercups.asResource("random_two"));
    private static final ResourceKey<FlowerCrownMaterial> RANDOM_FOUR = ResourceKey.create(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL, (ResourceLocation)BovinesAndButtercups.asResource("random_four"));
    private static final List<List<ResourceKey<FlowerCrownMaterial>>> COMBINATIONS = List.of(List.of(MONOCOLOR), List.of(RANDOM_TWO), List.of(RANDOM_FOUR), List.of(BovinesFlowerCrownMaterials.FREESIA, BovinesFlowerCrownMaterials.BIRD_OF_PARADISE, BovinesFlowerCrownMaterials.BUTTERCUP, BovinesFlowerCrownMaterials.LIMELIGHT, BovinesFlowerCrownMaterials.CHARGELILY, BovinesFlowerCrownMaterials.TROPICAL_BLUE, BovinesFlowerCrownMaterials.HYACINTH, BovinesFlowerCrownMaterials.PINK_DAISY), List.of(BovinesFlowerCrownMaterials.CHARGELILY, BovinesFlowerCrownMaterials.PINK_DAISY, BovinesFlowerCrownMaterials.SNOWDROP, BovinesFlowerCrownMaterials.PINK_DAISY, BovinesFlowerCrownMaterials.CHARGELILY, BovinesFlowerCrownMaterials.PINK_DAISY, BovinesFlowerCrownMaterials.SNOWDROP, BovinesFlowerCrownMaterials.PINK_DAISY));

    public static ItemStack generateRandomFlowerCrown(Random random, Item item) {
        Holder centerLeft;
        Holder topLeft;
        Registry registry = Minecraft.getInstance().level.registryAccess().lookupOrThrow(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL);
        ItemStack stack = new ItemStack((ItemLike)item);
        if (registry.registryKeySet().isEmpty()) {
            return stack;
        }
        List<ResourceKey<FlowerCrownMaterial>> materials = COMBINATIONS.get(random.nextInt(COMBINATIONS.size()));
        Holder top = topLeft = (centerLeft = (Holder)registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).findFirst().orElseThrow());
        Holder topRight = topLeft;
        Holder centerRight = topLeft;
        Holder bottomLeft = topLeft;
        Holder bottom = topLeft;
        Holder bottomRight = topLeft;
        if (materials.size() == 1) {
            if (materials.getFirst().equals(MONOCOLOR)) {
                topLeft = centerLeft = (Holder)registry.get(random.nextInt(registry.size())).orElseThrow();
                top = centerLeft;
                topRight = centerLeft;
                centerRight = centerLeft;
                bottomRight = centerLeft;
                bottom = centerLeft;
                bottomLeft = centerLeft;
            } else if (materials.getFirst().equals(RANDOM_TWO)) {
                Holder finalCenterLeft = centerLeft = (Holder)registry.get(random.nextInt(registry.size())).orElseThrow();
                List<Holder.Reference> topLeftMaterials = registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(reference -> !reference.is(finalCenterLeft)).toList();
                topLeft = (Holder)topLeftMaterials.get(random.nextInt(topLeftMaterials.size()));
                top = centerLeft;
                topRight = topLeft;
                centerRight = centerLeft;
                bottomRight = topLeft;
                bottom = centerLeft;
                bottomLeft = topLeft;
            } else if (materials.getFirst().equals(RANDOM_FOUR)) {
                Holder finalCenterLeft = centerLeft = (Holder)registry.get(random.nextInt(registry.size())).orElseThrow();
                List<Holder.Reference> topLeftMaterials = registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(reference -> !reference.is(finalCenterLeft)).toList();
                Holder finalTopLeft = topLeft = (Holder)topLeftMaterials.get(random.nextInt(topLeftMaterials.size()));
                List<Holder.Reference> topMaterials = registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(reference -> !reference.is(finalCenterLeft) && !reference.is(finalTopLeft)).toList();
                Holder finalTop = top = (Holder)topMaterials.get(random.nextInt(topMaterials.size()));
                List<Holder.Reference> topRightMaterials = registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(reference -> !reference.is(finalCenterLeft) && !reference.is(finalTopLeft) && !reference.is(finalTop)).toList();
                topRight = (Holder)topRightMaterials.get(random.nextInt(topRightMaterials.size()));
                centerRight = centerLeft;
                bottomRight = topLeft;
                bottom = top;
                bottomLeft = topRight;
            }
        } else if (materials.size() == 8) {
            centerLeft = registry.getOrThrow(materials.get(0));
            topLeft = registry.getOrThrow(materials.get(1));
            top = registry.getOrThrow(materials.get(2));
            topRight = registry.getOrThrow(materials.get(3));
            centerRight = registry.getOrThrow(materials.get(4));
            bottomRight = registry.getOrThrow(materials.get(5));
            bottom = registry.getOrThrow(materials.get(6));
            bottomLeft = registry.getOrThrow(materials.get(7));
        } else {
            return stack;
        }
        stack.set(BovinesDataComponents.FLOWER_CROWN, (Object)new FlowerCrown((Holder<FlowerCrownMaterial>)topLeft, (Holder<FlowerCrownMaterial>)top, (Holder<FlowerCrownMaterial>)topRight, (Holder<FlowerCrownMaterial>)centerLeft, (Holder<FlowerCrownMaterial>)centerRight, (Holder<FlowerCrownMaterial>)bottomLeft, (Holder<FlowerCrownMaterial>)bottom, (Holder<FlowerCrownMaterial>)bottomRight));
        return stack;
    }
}

