/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.mixin;

import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.content.block.BovinesBlocks;
import house.greenhouse.bovinesandbuttercups.content.block.entity.CustomFlowerPotBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.block.entity.CustomMushroomPotBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomFlower;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomMushroom;
import house.greenhouse.bovinesandbuttercups.content.item.CustomFlowerItem;
import house.greenhouse.bovinesandbuttercups.content.item.CustomMushroomItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlowerPotBlock.class})
public abstract class FlowerPotBlockMixin {
    @Shadow
    protected abstract boolean isEmpty();

    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;defaultBlockState()Lnet/minecraft/world/level/block/state/BlockState;")}, cancellable=true)
    private void bovinesandbuttercups$useDataDefinedItemOnPot(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (stack.getItem() instanceof CustomFlowerItem && stack.has(BovinesDataComponents.CUSTOM_FLOWER) && ((ItemCustomFlower)stack.get(BovinesDataComponents.CUSTOM_FLOWER)).holder().isBound() && ((CustomFlowerType)((ItemCustomFlower)stack.get(BovinesDataComponents.CUSTOM_FLOWER)).holder().value()).hasPotted()) {
            if (this.isEmpty()) {
                level.setBlock(pos, BovinesBlocks.POTTED_CUSTOM_FLOWER.defaultBlockState(), 3);
                level.sendBlockUpdated(pos, state, level.getBlockState(pos), 3);
                if (stack.has(BovinesDataComponents.CUSTOM_FLOWER)) {
                    ((CustomFlowerPotBlockEntity)level.getBlockEntity(pos)).setFlowerType((ItemCustomFlower)stack.get(BovinesDataComponents.CUSTOM_FLOWER));
                }
                level.getBlockEntity(pos).setChanged();
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.POT_FLOWER);
                stack.consume(1, (LivingEntity)player);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else {
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            }
        } else if (stack.getItem() instanceof CustomMushroomItem && stack.has(BovinesDataComponents.CUSTOM_MUSHROOM) && ((ItemCustomMushroom)stack.get(BovinesDataComponents.CUSTOM_MUSHROOM)).holder().isBound() && ((CustomMushroomType)((ItemCustomMushroom)stack.get(BovinesDataComponents.CUSTOM_MUSHROOM)).holder().value()).hasPotted()) {
            if (this.isEmpty()) {
                level.setBlock(pos, BovinesBlocks.POTTED_CUSTOM_MUSHROOM.defaultBlockState(), 3);
                level.sendBlockUpdated(pos, state, level.getBlockState(pos), 3);
                if (stack.has(BovinesDataComponents.CUSTOM_MUSHROOM)) {
                    ((CustomMushroomPotBlockEntity)level.getBlockEntity(pos)).setMushroomType((ItemCustomMushroom)stack.get(BovinesDataComponents.CUSTOM_MUSHROOM));
                }
                level.getBlockEntity(pos).setChanged();
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.POT_FLOWER);
                stack.consume(1, (LivingEntity)player);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            } else {
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            }
        }
    }
}

