/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.mixin;

import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomFlower;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomMushroom;
import house.greenhouse.bovinesandbuttercups.content.component.ItemEdible;
import house.greenhouse.bovinesandbuttercups.content.item.CustomFlowerItem;
import house.greenhouse.bovinesandbuttercups.content.item.CustomHugeMushroomItem;
import house.greenhouse.bovinesandbuttercups.content.item.CustomMushroomItem;
import house.greenhouse.bovinesandbuttercups.content.item.PlaceableEdibleItem;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    @Final
    PatchedDataComponentMap components;

    @Shadow
    public abstract Item getItem();

    @Inject(method={"set"}, at={@At(value="TAIL")})
    private <T> void bovinesandbuttercups$setDependencyComponents(DataComponentType<? super T> component, T value, CallbackInfoReturnable<T> cir) {
        DataComponentPatch.Builder patch = DataComponentPatch.builder();
        if (this.getItem() instanceof CustomFlowerItem && component == BovinesDataComponents.CUSTOM_FLOWER && !this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
            patch.set(DataComponents.ITEM_MODEL, (Object)((CustomFlowerType)((ItemCustomFlower)value).holder().value()).itemModel());
        }
        if (component == BovinesDataComponents.CUSTOM_MUSHROOM && (this.getItem() instanceof CustomMushroomItem || this.getItem() instanceof CustomHugeMushroomItem)) {
            ItemCustomMushroom customMushroom = (ItemCustomMushroom)value;
            if (!(this.getItem() instanceof CustomHugeMushroomItem) || ((CustomMushroomType)customMushroom.holder().value()).hasHugeBlock()) {
                ResourceLocation itemModel;
                ResourceLocation resourceLocation = itemModel = this.getItem() instanceof CustomHugeMushroomItem ? ((CustomMushroomType)customMushroom.holder().value()).hugeBlockItemModel().orElse(((CustomMushroomType)customMushroom.holder().value()).itemModel()) : ((CustomMushroomType)customMushroom.holder().value()).itemModel();
                if (!this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
                    patch.set(DataComponents.ITEM_MODEL, (Object)itemModel);
                }
            }
        }
        if (component == BovinesDataComponents.EDIBLE_TYPE && this.getItem() instanceof PlaceableEdibleItem) {
            ItemEdible edible = (ItemEdible)value;
            if (!this.components.hasNonDefault(DataComponents.ITEM_MODEL) && ((EdibleBlockType)edible.holder().value()).itemModel().isPresent()) {
                patch.set(DataComponents.ITEM_MODEL, (Object)((EdibleBlockType)edible.holder().value()).itemModel().get());
            }
            if (!this.components.hasNonDefault(DataComponents.MAX_STACK_SIZE)) {
                patch.set(DataComponents.MAX_STACK_SIZE, (Object)((EdibleBlockType)edible.holder().value()).maxStackSize());
            }
        }
        this.components.applyPatch(patch.build());
    }

    @Inject(method={"applyComponents(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;verifyComponentsAfterLoad(Lnet/minecraft/world/item/ItemStack;)V")})
    private void bovinesandbuttercups$applyDependencyComponents(DataComponentPatch components, CallbackInfo ci) {
        Optional edibleType;
        Optional customMushroom;
        DataComponentPatch.Builder patch = DataComponentPatch.builder();
        Optional customFlower = components.get(BovinesDataComponents.CUSTOM_FLOWER);
        if (this.getItem() instanceof CustomFlowerItem && customFlower != null) {
            if (customFlower.isPresent()) {
                if (!this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
                    patch.set(DataComponents.ITEM_MODEL, (Object)((CustomFlowerType)((ItemCustomFlower)customFlower.get()).holder().value()).itemModel());
                }
            } else if (this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
                ItemCustomFlower existing = (ItemCustomFlower)this.components.get(BovinesDataComponents.CUSTOM_FLOWER);
                if (Optional.ofNullable((ResourceLocation)this.components.get(DataComponents.ITEM_MODEL)).map(rl -> existing != null && rl == ((CustomFlowerType)existing.holder().value()).itemModel()).orElse(false).booleanValue()) {
                    patch.remove(DataComponents.ITEM_MODEL);
                }
            }
        }
        if ((customMushroom = components.get(BovinesDataComponents.CUSTOM_MUSHROOM)) != null && (this.getItem() instanceof CustomMushroomItem || this.getItem() instanceof CustomHugeMushroomItem)) {
            if (customMushroom.isPresent() && (!(this.getItem() instanceof CustomHugeMushroomItem) || ((CustomMushroomType)((ItemCustomMushroom)customMushroom.get()).holder().value()).hasHugeBlock())) {
                ResourceLocation itemModel;
                ResourceLocation resourceLocation = itemModel = this.getItem() instanceof CustomHugeMushroomItem ? ((CustomMushroomType)((ItemCustomMushroom)customMushroom.get()).holder().value()).hugeBlockItemModel().orElse(((CustomMushroomType)((ItemCustomMushroom)customMushroom.get()).holder().value()).itemModel()) : ((CustomMushroomType)((ItemCustomMushroom)customMushroom.get()).holder().value()).itemModel();
                if (!this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
                    patch.set(DataComponents.ITEM_MODEL, (Object)itemModel);
                }
            } else if (this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
                ItemCustomMushroom existing = (ItemCustomMushroom)this.components.get(BovinesDataComponents.CUSTOM_MUSHROOM);
                if (Optional.ofNullable((ResourceLocation)this.components.get(DataComponents.ITEM_MODEL)).map(rl -> existing != null && rl == ((CustomMushroomType)existing.holder().value()).itemModel()).orElse(false).booleanValue()) {
                    patch.remove(DataComponents.ITEM_MODEL);
                }
            }
        }
        if ((edibleType = components.get(BovinesDataComponents.EDIBLE_TYPE)) != null && this.getItem() instanceof PlaceableEdibleItem) {
            if (edibleType.isPresent()) {
                if (!this.components.hasNonDefault(DataComponents.ITEM_MODEL) && ((EdibleBlockType)((ItemEdible)edibleType.get()).holder().value()).itemModel().isPresent()) {
                    patch.set(DataComponents.ITEM_MODEL, (Object)((EdibleBlockType)((ItemEdible)edibleType.get()).holder().value()).itemModel().get());
                }
                if (!this.components.hasNonDefault(DataComponents.MAX_STACK_SIZE)) {
                    patch.set(DataComponents.MAX_STACK_SIZE, (Object)((EdibleBlockType)((ItemEdible)edibleType.get()).holder().value()).maxStackSize());
                }
            } else if (this.components.hasNonDefault(DataComponents.ITEM_MODEL)) {
                ItemEdible existing = (ItemEdible)this.components.get(BovinesDataComponents.EDIBLE_TYPE);
                if (Optional.ofNullable((ResourceLocation)this.components.get(DataComponents.ITEM_MODEL)).map(rl -> existing != null && ((EdibleBlockType)existing.holder().value()).itemModel().isPresent() && rl == ((EdibleBlockType)existing.holder().value()).itemModel().get()).orElse(false).booleanValue()) {
                    patch.remove(DataComponents.ITEM_MODEL);
                }
                if (Optional.ofNullable((Integer)this.components.get(DataComponents.MAX_STACK_SIZE)).map(size -> existing != null && ((EdibleBlockType)existing.holder().value()).maxStackSize() == size.intValue()).orElse(false).booleanValue()) {
                    patch.remove(DataComponents.MAX_STACK_SIZE);
                }
            }
        }
        this.components.applyPatch(patch.build());
    }
}

