/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.access.MobEffectInstanceLockdownDataAccess;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.util.LockdownData;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEffectInstance.class})
public abstract class MobEffectInstanceMixin
implements MobEffectInstanceLockdownDataAccess {
    @Shadow
    @Final
    private Holder<MobEffect> effect;
    @Unique
    private List<LockdownData> bovinesandbuttercups$lockdownData;

    @Shadow
    public abstract Holder<MobEffect> getEffect();

    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/codecs/RecordCodecBuilder;create(Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;")})
    private static Codec<MobEffectInstance> bovinesandbuttercups$addLockdownDataToInstanceCodec(Codec<MobEffectInstance> original) {
        return Codec.pair(original, LockdownData.ADDITIONAL_CODEC).xmap(pair -> {
            MobEffectInstance instance = (MobEffectInstance)pair.getFirst();
            ((MobEffectInstanceLockdownDataAccess)instance).bovinesandbuttercups$setLockdownData((List)pair.getSecond());
            return instance;
        }, instance -> {
            List<LockdownData> data = ((MobEffectInstanceLockdownDataAccess)instance).bovinesandbuttercups$getLockdownData();
            return Pair.of((Object)instance, data);
        });
    }

    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/codec/StreamCodec;composite(Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Ljava/util/function/BiFunction;)Lnet/minecraft/network/codec/StreamCodec;")})
    private static StreamCodec<RegistryFriendlyByteBuf, MobEffectInstance> bovinesandbuttercups$addLockdownDataToStreamCodec(StreamCodec<RegistryFriendlyByteBuf, MobEffectInstance> original) {
        return StreamCodec.composite(original, instance -> instance, (StreamCodec)LockdownData.STREAM_CODEC.apply(ByteBufCodecs.list()), instance -> ((MobEffectInstanceLockdownDataAccess)instance).bovinesandbuttercups$getLockdownData(), (mobEffectInstance, lockdownData) -> {
            ((MobEffectInstanceLockdownDataAccess)mobEffectInstance).bovinesandbuttercups$setLockdownData((List<LockdownData>)lockdownData);
            return mobEffectInstance;
        });
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;tickDownDuration()I")}, cancellable=true)
    private void bovinesandbuttercups$lockDuration(LivingEntity living, Runnable runnable, CallbackInfoReturnable<Boolean> cir) {
        if (living.hasEffect(BovinesEffects.LOCKDOWN) && BovinesAndButtercups.getHelper().getLockdownAttachment(living).effects().containsKey(this.getEffect())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setDetailsFrom"}, at={@At(value="TAIL")})
    private void bovinesandbuttercups$setLockdownDataFromOtherEffect(MobEffectInstance effectInstance, CallbackInfo ci) {
        if (this.effect.is(BovinesEffects.LOCKDOWN) && effectInstance.is(BovinesEffects.LOCKDOWN)) {
            this.bovinesandbuttercups$setLockdownData(((MobEffectInstanceLockdownDataAccess)effectInstance).bovinesandbuttercups$getLockdownData());
        }
    }

    @Override
    public List<LockdownData> bovinesandbuttercups$getLockdownData() {
        if (this.effect == null || !this.effect.is(BovinesEffects.LOCKDOWN) || this.bovinesandbuttercups$lockdownData == null) {
            return List.of();
        }
        return this.bovinesandbuttercups$lockdownData;
    }

    @Override
    public MobEffectInstance bovinesandbuttercups$setLockdownData(List<LockdownData> data) {
        if (this.effect == null || this.effect.is(BovinesEffects.LOCKDOWN)) {
            this.bovinesandbuttercups$lockdownData = data;
        }
        return (MobEffectInstance)this;
    }
}

