/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.network.clientbound;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.api.variant.CowModelLayer;
import house.greenhouse.bovinesandbuttercups.api.variant.modifier.TextureModifierFactory;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record SyncCowVariantClientboundPacket(int entityId, CowVariantAttachment attachment, boolean onTracking) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("sync_cow_variant");
    public static final CustomPacketPayload.Type<SyncCowVariantClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCowVariantClientboundPacket> STREAM_CODEC = StreamCodec.of(SyncCowVariantClientboundPacket::write, SyncCowVariantClientboundPacket::new);
    private static final Object2IntArrayMap<Pair<Integer, CowVariantAttachment>> RETRIES = new Object2IntArrayMap();

    public SyncCowVariantClientboundPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), (CowVariantAttachment)((Pair)CowVariantAttachment.DIRECT_CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)buf.registryAccess()), (Object)buf.readNbt()).getOrThrow()).getFirst(), buf.readBoolean());
    }

    public static void write(RegistryFriendlyByteBuf buf, SyncCowVariantClientboundPacket packet) {
        buf.writeInt(packet.entityId);
        buf.writeNbt((Tag)CowVariantAttachment.DIRECT_CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)buf.registryAccess()), (Object)packet.attachment).getOrThrow());
        buf.writeBoolean(packet.onTracking);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
            if (!(entity instanceof LivingEntity)) {
                if (this.onTracking) {
                    RETRIES.put((Object)Pair.of((Object)this.entityId, (Object)this.attachment), 0);
                }
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            BovinesAndButtercups.getHelper().setCowVariantAttachment(living, this.attachment);
            for (CowModelLayer layer : ((CowVariant)BovinesAndButtercups.getHelper().getCowVariantAttachment(living).cowVariant().value()).configuration().layers()) {
                for (TextureModifierFactory<?> modifier : layer.textureModifiers()) {
                    modifier.init((Entity)living);
                }
            }
        });
    }

    public static void retry(ClientLevel level) {
        if (RETRIES.isEmpty() || level.getLevelData().getGameTime() % 5L != 0L) {
            return;
        }
        for (Map.Entry pair : RETRIES.object2IntEntrySet()) {
            Entity entity = Minecraft.getInstance().level.getEntity(((Integer)((Pair)pair.getKey()).getFirst()).intValue());
            if (!(entity instanceof LivingEntity)) {
                RETRIES.put((Object)((Pair)pair.getKey()), (Integer)pair.getValue() + 1);
                continue;
            }
            LivingEntity living = (LivingEntity)entity;
            BovinesAndButtercups.getHelper().setCowVariantAttachment(living, (CowVariantAttachment)((Pair)pair.getKey()).getSecond());
            for (CowModelLayer layer : ((CowVariant)BovinesAndButtercups.getHelper().getCowVariantAttachment(living).cowVariant().value()).configuration().layers()) {
                for (TextureModifierFactory<?> modifier : layer.textureModifiers()) {
                    modifier.init((Entity)living);
                }
            }
            RETRIES.object2IntEntrySet().removeIf(p -> pair.getKey() == p.getKey());
        }
        RETRIES.values().removeIf(integer -> {
            boolean bl;
            boolean bl2 = bl = integer > 5;
            if (bl) {
                BovinesAndButtercups.LOG.warn("Failed to sync Cow Variant Attachment on entity.");
            }
            return bl;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

