/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.network.clientbound;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.attachment.MooshroomExtrasAttachment;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;

public record SyncMooshroomExtrasClientboundPacket(int entityId, MooshroomExtrasAttachment attachment, boolean onTracking) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("sync_mooshroom_extras");
    public static final CustomPacketPayload.Type<SyncMooshroomExtrasClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncMooshroomExtrasClientboundPacket> STREAM_CODEC = StreamCodec.of(SyncMooshroomExtrasClientboundPacket::write, SyncMooshroomExtrasClientboundPacket::new);
    private static final Object2IntArrayMap<Pair<Integer, MooshroomExtrasAttachment>> RETRIES = new Object2IntArrayMap();

    public SyncMooshroomExtrasClientboundPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), (MooshroomExtrasAttachment)ByteBufCodecs.fromCodec(MooshroomExtrasAttachment.CODEC).decode((Object)buf), buf.readBoolean());
    }

    public static void write(RegistryFriendlyByteBuf buf, SyncMooshroomExtrasClientboundPacket packet) {
        buf.writeInt(packet.entityId);
        ByteBufCodecs.fromCodec(MooshroomExtrasAttachment.CODEC).encode((Object)buf, (Object)packet.attachment);
        buf.writeBoolean(packet.onTracking);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
            if (!(entity instanceof LivingEntity)) {
                if (this.onTracking) {
                    RETRIES.put((Object)Pair.of((Object)this.entityId, (Object)this.attachment), 0);
                }
                return;
            }
            if (entity.getType() == EntityType.MOOSHROOM && entity instanceof MushroomCow) {
                MushroomCow mooshroom = (MushroomCow)entity;
                BovinesAndButtercups.getHelper().setMooshroomExtrasAttachment((LivingEntity)mooshroom, this.attachment);
            }
        });
    }

    public static void retry(ClientLevel level) {
        if (RETRIES.isEmpty() || level.getLevelData().getGameTime() % 5L != 0L) {
            return;
        }
        for (Map.Entry pair : RETRIES.object2IntEntrySet()) {
            Entity entity = Minecraft.getInstance().level.getEntity(((Integer)((Pair)pair.getKey()).getFirst()).intValue());
            if (!(entity instanceof LivingEntity)) {
                RETRIES.put((Object)((Pair)pair.getKey()), (Integer)pair.getValue() + 1);
                continue;
            }
            LivingEntity living = (LivingEntity)entity;
            BovinesAndButtercups.getHelper().setMooshroomExtrasAttachment(living, (MooshroomExtrasAttachment)((Pair)pair.getKey()).getSecond());
            RETRIES.object2IntEntrySet().removeIf(p -> pair.getKey() == p.getKey());
        }
        RETRIES.values().removeIf(integer -> {
            boolean bl;
            boolean bl2 = bl = integer > 5;
            if (bl) {
                BovinesAndButtercups.LOG.warn("Failed to sync Mooshroom Extras Attachment on entity.");
            }
            return bl;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

