/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.platform;

import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.api.attachment.LockdownAttachment;
import house.greenhouse.bovinesandbuttercups.api.attachment.MooshroomExtrasAttachment;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.content.recipe.ingredient.RemainderIngredient;
import house.greenhouse.bovinesandbuttercups.platform.BovinesPlatform;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface BovinesPlatformHelper {
    public BovinesPlatform getPlatform();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public <T> Registry<T> createRegistry(ResourceKey<Registry<T>> var1);

    public String getAttachmentKey();

    public LockdownAttachment getLockdownAttachment(LivingEntity var1);

    public CowVariantAttachment getCowVariantAttachment(LivingEntity var1);

    public void setCowVariantAttachment(LivingEntity var1, CowVariantAttachment var2);

    public boolean hasMooshroomExtrasAttachment(LivingEntity var1);

    public MooshroomExtrasAttachment getMooshroomExtrasAttachment(LivingEntity var1);

    public void setMooshroomExtrasAttachment(LivingEntity var1, MooshroomExtrasAttachment var2);

    public void sendClientboundPacket(ServerPlayer var1, CustomPacketPayload ... var2);

    public void sendTrackingClientboundPacket(Entity var1, CustomPacketPayload ... var2);

    public void sendTrackingClientboundPacket(BlockEntity var1, CustomPacketPayload ... var2);

    public boolean producesRichHoney(BeehiveBlockEntity var1);

    public boolean producesRichHoney(Entity var1);

    public void setProducesRichHoney(BeehiveBlockEntity var1, boolean var2);

    public void setProducesRichHoney(Entity var1, boolean var2);

    public Optional<UUID> getPollinatingMoobloom(Bee var1);

    public void setPollinatingMoobloom(Bee var1, @Nullable UUID var2);

    public Map<Holder<CowVariant<?>>, List<Vec3>> getParticlePositions(LivingEntity var1);

    public void addParticlePosition(LivingEntity var1, Holder<CowVariant<?>> var2, Vec3 var3);

    public void clearParticlePositions(LivingEntity var1);

    public Moobloom createMoobloom(EntityType<Moobloom> var1, Level var2);

    public boolean canStickToRichHoney(BlockState var1, BlockState var2);

    @Nullable
    public RemainderIngredient getRemainderIngredient(Ingredient var1);
}

