/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.registry;

import house.greenhouse.bovinesandbuttercups.api.BovinesCowTypes;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.api.variant.model.BovinesCowModelTypes;
import house.greenhouse.bovinesandbuttercups.content.advancement.criterion.BovinesCriteriaTriggers;
import house.greenhouse.bovinesandbuttercups.content.attachment.BovinesAttachments;
import house.greenhouse.bovinesandbuttercups.content.block.BovinesBlocks;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.FlowerCrownMaterial;
import house.greenhouse.bovinesandbuttercups.content.data.modifier.BovinesTextureModifierFactories;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.content.entity.BovinesEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import house.greenhouse.bovinesandbuttercups.content.particle.BovinesParticleTypes;
import house.greenhouse.bovinesandbuttercups.content.predicate.BovinesEntitySubPredicateTypes;
import house.greenhouse.bovinesandbuttercups.content.predicate.BovinesLootItemConditionTypes;
import house.greenhouse.bovinesandbuttercups.content.recipe.BovinesRecipeSerializers;
import house.greenhouse.bovinesandbuttercups.content.recipe.ingredient.BovinesIngredients;
import house.greenhouse.bovinesandbuttercups.content.sound.BovinesSoundEvents;
import house.greenhouse.bovinesandbuttercups.content.worldgen.BovinesBiomeModifierSerializers;
import house.greenhouse.bovinesandbuttercups.content.worldgen.BovinesStructureTypes;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import house.greenhouse.bovinesandbuttercups.registry.HolderRegistrationCallback;
import house.greenhouse.bovinesandbuttercups.registry.RegistrationCallback;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="bovinesandbuttercups", bus=EventBusSubscriber.Bus.MOD)
public class BovinesRegistryEvents {
    @SubscribeEvent
    public static void registerContent(RegisterEvent event) {
        BovinesRegistryEvents.register(event, BovinesAttachments::registerAll);
        BovinesRegistryEvents.register(event, BovinesBiomeModifierSerializers::registerAll);
        BovinesRegistryEvents.register(event, BovinesBlockEntityTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesBlocks::registerAll);
        BovinesRegistryEvents.register(event, BovinesCowTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesCriteriaTriggers::registerAll);
        BovinesRegistryEvents.register(event, BovinesDataComponents::registerAll);
        BovinesRegistryEvents.register(event, BovinesEntitySubPredicateTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesEntityTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesIngredients::registerAll);
        BovinesRegistryEvents.register(event, BovinesLootItemConditionTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesParticleTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesRecipeSerializers::registerAll);
        BovinesRegistryEvents.register(event, BovinesSoundEvents::registerAll);
        BovinesRegistryEvents.register(event, BovinesStructureTypes::registerAll);
        BovinesRegistryEvents.register(event, BovinesTextureModifierFactories::registerAll);
        BovinesRegistryEvents.register(event, BovinesCowModelTypes::registerAll);
        if (event.getRegistryKey() == Registries.SOUND_EVENT) {
            BovinesRegistryEvents.registerHolders(BovinesSoundEvents::registerHolders);
            BovinesItems.registerAll(Registry::register);
        }
        if (event.getRegistryKey() == Registries.MOB_EFFECT) {
            BovinesRegistryEvents.registerHolders(BovinesEffects::registerAll);
        }
    }

    private static <T> void register(RegisterEvent event, Consumer<RegistrationCallback<T>> consumer) {
        consumer.accept((registry, id, value) -> event.register(registry.key(), id, () -> value));
    }

    private static <T> void registerHolders(Consumer<HolderRegistrationCallback<T>> consumer) {
        consumer.accept((registry, id, value) -> {
            Registry.register((Registry)registry, (ResourceLocation)id, (Object)value);
            return DeferredHolder.create((ResourceKey)registry.key(), (ResourceLocation)id);
        });
    }

    @SubscribeEvent
    public static void createNewRegistries(NewRegistryEvent event) {
        event.register(BovinesRegistries.COW_TYPE);
        event.register(BovinesRegistries.MODEL_TYPE);
        event.register(BovinesRegistries.TEXTURE_MODIFIER);
    }

    @SubscribeEvent
    public static void createNewDataPackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(BovinesRegistryKeys.COW_VARIANT, CowVariant.DIRECT_CODEC, CowVariant.DIRECT_CODEC);
        event.dataPackRegistry(BovinesRegistryKeys.CUSTOM_FLOWER_TYPE, CustomFlowerType.DIRECT_CODEC, CustomFlowerType.DIRECT_CODEC);
        event.dataPackRegistry(BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE, CustomMushroomType.DIRECT_CODEC, CustomMushroomType.DIRECT_CODEC);
        event.dataPackRegistry(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE, EdibleBlockType.DIRECT_CODEC, EdibleBlockType.DIRECT_CODEC);
        event.dataPackRegistry(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL, FlowerCrownMaterial.DIRECT_CODEC, FlowerCrownMaterial.DIRECT_CODEC);
    }
}

