/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.access.VoxelShapeFunctionAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockUtil {
    private static final Codec<BooleanOp> BOOLEAN_OP_CODEC = new Codec<BooleanOp>(){

        public <T> DataResult<Pair<BooleanOp, T>> decode(DynamicOps<T> ops, T input) {
            DataResult dataResult = ops.getStringValue(input);
            if (dataResult.isError()) {
                return DataResult.error(() -> "BooleanOp value must be a string.");
            }
            BooleanOp op = null;
            switch ((String)dataResult.getOrThrow()) {
                case "false": {
                    op = BooleanOp.FALSE;
                    break;
                }
                case "not_or": {
                    op = BooleanOp.NOT_OR;
                    break;
                }
                case "only_second": {
                    op = BooleanOp.ONLY_SECOND;
                    break;
                }
                case "not_First": {
                    op = BooleanOp.NOT_FIRST;
                    break;
                }
                case "only_first": {
                    op = BooleanOp.ONLY_FIRST;
                    break;
                }
                case "not_second": {
                    op = BooleanOp.NOT_SECOND;
                    break;
                }
                case "not_same": {
                    op = BooleanOp.NOT_SAME;
                    break;
                }
                case "not_and": {
                    op = BooleanOp.NOT_AND;
                    break;
                }
                case "and": {
                    op = BooleanOp.AND;
                    break;
                }
                case "same": {
                    op = BooleanOp.SAME;
                    break;
                }
                case "causes": {
                    op = BooleanOp.CAUSES;
                    break;
                }
                case "first": {
                    op = BooleanOp.FIRST;
                    break;
                }
                case "caused_by": {
                    op = BooleanOp.CAUSED_BY;
                    break;
                }
                case "or": {
                    op = BooleanOp.OR;
                    break;
                }
                case "true": {
                    op = BooleanOp.TRUE;
                    break;
                }
            }
            if (op != null) {
                return DataResult.success((Object)Pair.of((Object)op, input));
            }
            return DataResult.error(() -> "Could not get BooleanOp value from " + (String)dataResult.getOrThrow() + ".");
        }

        public <T> DataResult<T> encode(BooleanOp input, DynamicOps<T> ops, T prefix) {
            return null;
        }
    };
    private static final Codec<VoxelShape> DIRECT_VOXEL_SHAPE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Vec3.CODEC.fieldOf("min").forGetter(voxelShape -> new Vec3(voxelShape.min(Direction.Axis.X), voxelShape.min(Direction.Axis.Y), voxelShape.min(Direction.Axis.Z))), (App)Vec3.CODEC.fieldOf("max").forGetter(voxelShape -> new Vec3(voxelShape.max(Direction.Axis.X), voxelShape.max(Direction.Axis.Y), voxelShape.max(Direction.Axis.Z)))).apply((Applicative)inst, (t1, t2) -> Shapes.create((double)t1.x, (double)t1.y, (double)t1.z, (double)t2.x, (double)t2.y, (double)t2.z)));
    private static final Codec<VoxelShape> JOINED_VOXEL_SHAPE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DIRECT_VOXEL_SHAPE_CODEC.listOf().fieldOf("shapes").forGetter(BlockUtil::shapes), (App)BOOLEAN_OP_CODEC.optionalFieldOf("function", (Object)BooleanOp.OR).forGetter(BlockUtil::operator)).apply((Applicative)inst, BlockUtil::createJoined));
    public static final Codec<VoxelShape> VOXEL_SHAPE_CODEC = Codec.either(JOINED_VOXEL_SHAPE_CODEC, DIRECT_VOXEL_SHAPE_CODEC).xmap(either -> (VoxelShape)either.map(shape -> shape, Function.identity()), shape -> {
        if (((VoxelShapeFunctionAccess)shape).bovinesandbuttercups$getJoinFunction() != null) {
            return Either.left((Object)shape);
        }
        return Either.right((Object)shape);
    });

    public static Component getOrCreateBlockNameTranslationKey(ResourceLocation location) {
        return Component.translatable((String)("item." + location.getNamespace() + "." + location.getPath()));
    }

    public static Component getOrCreateItemNameTranslationKey(ResourceLocation location) {
        return Component.translatable((String)("item." + location.getNamespace() + "." + location.getPath()));
    }

    private static List<VoxelShape> shapes(VoxelShape shape) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> shapes.add(Shapes.create((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ)));
        return shapes;
    }

    private static BooleanOp operator(VoxelShape shape) {
        return ((VoxelShapeFunctionAccess)shape).bovinesandbuttercups$getJoinFunction();
    }

    private static VoxelShape createJoined(List<VoxelShape> shapes, BooleanOp function) {
        ArrayList<VoxelShape> otherShapes = new ArrayList<VoxelShape>(shapes);
        otherShapes.removeFirst();
        return otherShapes.stream().reduce(shapes.getFirst(), (shape, shape2) -> Shapes.join((VoxelShape)shape, (VoxelShape)shape2, (BooleanOp)function));
    }
}

