/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.api.BovinesTags;
import house.greenhouse.bovinesandbuttercups.api.block.CustomFlowerType;
import house.greenhouse.bovinesandbuttercups.api.block.CustomMushroomType;
import house.greenhouse.bovinesandbuttercups.api.block.EdibleBlockType;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.FlowerCrown;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomFlower;
import house.greenhouse.bovinesandbuttercups.content.component.ItemCustomMushroom;
import house.greenhouse.bovinesandbuttercups.content.component.ItemEdible;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.FlowerCrownMaterial;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import house.greenhouse.bovinesandbuttercups.content.item.FlowerCrownItem;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import house.greenhouse.bovinesandbuttercups.util.CreativeModeTabEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.apache.commons.lang3.mutable.MutableObject;

public class CreativeTabHelper {
    public static List<ItemStack> getFlowersForCreativeTab(HolderLookup.Provider lookup) {
        return List.of(BovinesItems.FREESIA.getDefaultInstance(), BovinesItems.BIRD_OF_PARADISE.getDefaultInstance(), BovinesItems.BUTTERCUP.getDefaultInstance(), BovinesItems.LIMELIGHT.getDefaultInstance(), BovinesItems.LINGHOLM.getDefaultInstance(), BovinesItems.CHARGELILY.getDefaultInstance(), BovinesItems.TROPICAL_BLUE.getDefaultInstance(), BovinesItems.HYACINTH.getDefaultInstance(), BovinesItems.CAMELLIA.getDefaultInstance(), BovinesItems.PINK_DAISY.getDefaultInstance(), BovinesItems.SNOWDROP.getDefaultInstance(), BovinesItems.NIGHTSHADE.getDefaultInstance(), BovinesItems.SOMBERCUP.getDefaultInstance());
    }

    public static List<ItemStack> getCustomFlowersForCreativeTab(HolderLookup.Provider lookup) {
        return lookup.lookupOrThrow(BovinesRegistryKeys.CUSTOM_FLOWER_TYPE).listElements().filter(flowerType -> flowerType.isBound() && !((CustomFlowerType)flowerType.value()).equals(CustomFlowerType.MISSING)).map(flowerType -> {
            ItemStack stack = new ItemStack((ItemLike)BovinesItems.CUSTOM_FLOWER);
            stack.set(BovinesDataComponents.CUSTOM_FLOWER, (Object)new ItemCustomFlower((Holder<CustomFlowerType>)flowerType));
            return stack;
        }).toList();
    }

    public static List<ItemStack> getCustomMushroomsForCreativeTab(HolderLookup.Provider lookup) {
        return lookup.lookupOrThrow(BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE).listElements().filter(mushroomType -> mushroomType.isBound() && !((CustomMushroomType)mushroomType.value()).equals(CustomMushroomType.MISSING)).map(mushroomType -> {
            ItemStack stack = new ItemStack((ItemLike)BovinesItems.CUSTOM_MUSHROOM);
            stack.set(BovinesDataComponents.CUSTOM_MUSHROOM, (Object)new ItemCustomMushroom((Holder<CustomMushroomType>)mushroomType));
            return stack;
        }).toList();
    }

    public static List<ItemStack> getCustomMushroomBlocksForCreativeTab(HolderLookup.Provider lookup) {
        return lookup.lookupOrThrow(BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE).listElements().filter(mushroomType -> mushroomType.isBound() && !((CustomMushroomType)mushroomType.value()).equals(CustomMushroomType.MISSING)).map(mushroomType -> {
            ItemStack stack = new ItemStack((ItemLike)BovinesItems.CUSTOM_MUSHROOM_BLOCK);
            stack.set(BovinesDataComponents.CUSTOM_MUSHROOM, (Object)new ItemCustomMushroom((Holder<CustomMushroomType>)mushroomType));
            return stack;
        }).toList();
    }

    public static List<ItemStack> getNectarBowlsForCreativeTab(HolderLookup.Provider lookup) {
        return List.of(BovinesItems.FREESIA_NECTAR_BOWL.getDefaultInstance(), BovinesItems.BIRD_OF_PARADISE_NECTAR_BOWL.getDefaultInstance(), BovinesItems.BUTTERCUP_NECTAR_BOWL.getDefaultInstance(), BovinesItems.LIMELIGHT_NECTAR_BOWL.getDefaultInstance(), BovinesItems.LINGHOLM_NECTAR_BOWL.getDefaultInstance(), BovinesItems.CHARGELILY_NECTAR_BOWL.getDefaultInstance(), BovinesItems.TROPICAL_BLUE_NECTAR_BOWL.getDefaultInstance(), BovinesItems.HYACINTH_NECTAR_BOWL.getDefaultInstance(), BovinesItems.CAMELLIA_NECTAR_BOWL.getDefaultInstance(), BovinesItems.PINK_DAISY_NECTAR_BOWL.getDefaultInstance(), BovinesItems.SNOWDROP_NECTAR_BOWL.getDefaultInstance(), BovinesItems.NIGHTSHADE_NECTAR_BOWL.getDefaultInstance(), BovinesItems.SOMBERCUP_NECTAR_BOWL.getDefaultInstance());
    }

    public static List<ItemStack> getFlowerCrownsForCreativeTab(HolderLookup.Provider lookup) {
        HolderLookup.RegistryLookup registry = lookup.lookupOrThrow(BovinesRegistryKeys.FLOWER_CROWN_MATERIAL);
        HolderSet.Named creativeModeTabOrder = registry.getOrThrow(BovinesTags.FlowerCrownMaterialTags.CREATIVE_MENU_ORDER);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(FlowerCrownItem.createRainbowCrown(lookup));
        stacks.addAll(registry.listElements().filter(Holder.Reference::isBound).sorted(Comparator.comparingInt(arg_0 -> CreativeTabHelper.lambda$getFlowerCrownsForCreativeTab$6((HolderSet)creativeModeTabOrder, arg_0))).map(petal -> {
            ItemStack stack = new ItemStack((ItemLike)BovinesItems.FLOWER_CROWN);
            stack.set(BovinesDataComponents.FLOWER_CROWN, (Object)new FlowerCrown((Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal, (Holder<FlowerCrownMaterial>)petal));
            return stack;
        }).toList());
        return stacks;
    }

    public static void addEdibleBlocksToCreativeTabs(HolderLookup.Provider lookup, List<ItemStack> displayStacks, List<ItemStack> searchStacks, ResourceKey<CreativeModeTab> tab, AddFunction addFunction, AddFunction prependFunction, AppendFunction addBeforeFunction, AppendFunction addAfterFunction) {
        HolderLookup.RegistryLookup registry = lookup.lookupOrThrow(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE);
        Optional creativeModeTabOrder = registry.get(BovinesTags.EdibleBlockTypeTags.CREATIVE_MENU_ORDER);
        if (creativeModeTabOrder.isEmpty()) {
            return;
        }
        HashMap prependedItem = new HashMap();
        HashMap<ItemStack, ItemStack> prependedSearchItem = new HashMap<ItemStack, ItemStack>();
        HashMap appendedItem = new HashMap();
        HashMap<ItemStack, ItemStack> appendedSearchItem = new HashMap<ItemStack, ItemStack>();
        for (Holder.Reference type : registry.listElements().filter(ref -> ref.isBound() && ((EdibleBlockType)ref.value()).creativeModeTabs().stream().anyMatch(creativeModeTabEntry -> {
            if (creativeModeTabEntry.tab() == tab) {
                Optional actualTab = ((HolderLookup.RegistryLookup)lookup.lookup(Registries.CREATIVE_MODE_TAB).orElseThrow()).get(tab);
                return actualTab.isPresent() && (creativeModeTabEntry.placement().stack().isEmpty() || displayStacks.stream().anyMatch(stack1 -> (Boolean)creativeModeTabEntry.placement().stack().get().map(stack2 -> ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)stack1), item -> stack1.getItem() == item)));
            }
            return false;
        })).sorted(Comparator.comparingInt(value -> {
            int i = ((HolderSet.Named)creativeModeTabOrder.get()).stream().toList().indexOf(value);
            if (i == -1) {
                return Integer.MAX_VALUE;
            }
            return i;
        })).toList()) {
            Optional<CreativeModeTabEntry> creativeModeTab = ((EdibleBlockType)type.value()).creativeModeTabs().stream().filter(creativeModeTabEntry -> creativeModeTabEntry.tab() == tab).findFirst();
            List<ItemStack> list = creativeModeTab.stream().flatMap(creativeModeTabEntry -> {
                Optional actualTab = ((HolderLookup.RegistryLookup)lookup.lookup(Registries.CREATIVE_MODE_TAB).orElseThrow()).get(tab);
                if (actualTab.isPresent() && creativeModeTabEntry.placement().stack().isPresent()) {
                    return displayStacks.stream().filter(stack1 -> (Boolean)creativeModeTabEntry.placement().stack().get().map(stack2 -> ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)stack1), item -> stack1.getItem() == item));
                }
                return null;
            }).filter(Objects::nonNull).toList();
            MutableObject hasAddedOne = new MutableObject();
            List<Pair> items = creativeModeTab.orElseThrow().componentsToAdd().stream().map(components -> {
                ItemStack stack = new ItemStack((ItemLike)BovinesItems.PLACEABLE_EDIBLE);
                stack.applyComponents(components.map());
                stack.set(BovinesDataComponents.EDIBLE_TYPE, (Object)new ItemEdible((Holder<EdibleBlockType>)type, components.effects()));
                return Pair.of((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }).toList();
            hasAddedOne.setValue(null);
            if (items.isEmpty()) {
                if (type.is(BovinesTags.EdibleBlockTypeTags.IS_SUSPICIOUS)) {
                    items = SuspiciousEffectHolder.getAllEffectHolders().stream().map(suspiciousEffectHolder -> {
                        ItemStack stack = new ItemStack((ItemLike)BovinesItems.PLACEABLE_EDIBLE);
                        List<ItemEdible.MobEffectEntry> entries = suspiciousEffectHolder.getSuspiciousEffects().effects().stream().map(entry -> new ItemEdible.MobEffectEntry(new MobEffectInstance(entry.effect(), Mth.ceil((float)((float)entry.duration() / 4.0f))), entry.duration(), ItemEdible.MobEffectEntry.ShowTooltip.CREATIVE_MENU_ONLY)).toList();
                        stack.set(BovinesDataComponents.EDIBLE_TYPE, (Object)new ItemEdible((Holder<EdibleBlockType>)type, entries));
                        CreativeModeTab.TabVisibility visibility = hasAddedOne.getValue() != null ? CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
                        hasAddedOne.setValue((Object)Unit.INSTANCE);
                        return Pair.of((Object)stack, (Object)visibility);
                    }).toList();
                } else {
                    ItemStack stack = new ItemStack((ItemLike)BovinesItems.PLACEABLE_EDIBLE);
                    stack.set(BovinesDataComponents.EDIBLE_TYPE, (Object)new ItemEdible((Holder<EdibleBlockType>)type, List.of()));
                    items = List.of(Pair.of((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                }
            }
            ArrayList<Pair> deduplicated = new ArrayList<Pair>();
            for (Pair stack : items) {
                if (deduplicated.stream().anyMatch(stack1 -> ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)stack.getFirst()), (ItemStack)((ItemStack)stack1.getFirst())))) continue;
                deduplicated.add(stack);
            }
            if (!list.isEmpty()) {
                HashMap<ItemStack, ItemStack> map;
                if (creativeModeTab.get().placement().ordering() == CreativeModeTabEntry.Ordering.AFTER) {
                    for (Pair stackToAdd : deduplicated) {
                        HashMap<Object, Object> hashMap = map = stackToAdd.getSecond() == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY ? prependedSearchItem : prependedItem;
                        if (!map.containsKey(list.getLast())) {
                            addAfterFunction.accept(list.getLast(), (ItemStack)stackToAdd.getFirst(), (CreativeModeTab.TabVisibility)stackToAdd.getSecond());
                        } else {
                            addAfterFunction.accept((ItemStack)map.get(list.getLast()), (ItemStack)stackToAdd.getFirst(), (CreativeModeTab.TabVisibility)stackToAdd.getSecond());
                        }
                        map.put(list.getLast(), (ItemStack)stackToAdd.getFirst());
                        if (stackToAdd.getSecond() != CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS || !searchStacks.contains(list.getLast())) continue;
                        prependedSearchItem.put(list.getLast(), (ItemStack)stackToAdd.getFirst());
                    }
                    continue;
                }
                for (Pair stackToAdd : deduplicated) {
                    HashMap<Object, Object> hashMap = map = stackToAdd.getSecond() == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY ? appendedSearchItem : appendedItem;
                    if (!map.containsKey(list.getFirst())) {
                        addBeforeFunction.accept(list.getFirst(), (ItemStack)stackToAdd.getFirst(), (CreativeModeTab.TabVisibility)stackToAdd.getSecond());
                    } else {
                        addAfterFunction.accept((ItemStack)map.get(list.getFirst()), (ItemStack)stackToAdd.getFirst(), (CreativeModeTab.TabVisibility)stackToAdd.getSecond());
                    }
                    map.put(list.getFirst(), (ItemStack)stackToAdd.getFirst());
                    if (stackToAdd.getSecond() != CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS || !searchStacks.contains(list.getFirst())) continue;
                    appendedSearchItem.put(list.getFirst(), (ItemStack)stackToAdd.getFirst());
                }
                continue;
            }
            if (creativeModeTab.get().placement().ordering() == CreativeModeTabEntry.Ordering.BEFORE) {
                for (Pair stackToAdd : deduplicated) {
                    addFunction.accept((ItemStack)stackToAdd.getFirst(), (CreativeModeTab.TabVisibility)stackToAdd.getSecond());
                }
                continue;
            }
            for (Pair stackToAdd : deduplicated.reversed()) {
                addFunction.accept((ItemStack)stackToAdd.getFirst(), (CreativeModeTab.TabVisibility)stackToAdd.getSecond());
            }
        }
    }

    private static /* synthetic */ int lambda$getFlowerCrownsForCreativeTab$6(HolderSet creativeModeTabOrder, Holder.Reference value) {
        int i = creativeModeTabOrder.stream().toList().indexOf(value);
        if (i == -1) {
            return Integer.MAX_VALUE;
        }
        return i;
    }

    @FunctionalInterface
    public static interface AppendFunction {
        public void accept(ItemStack var1, ItemStack var2, CreativeModeTab.TabVisibility var3);
    }

    @FunctionalInterface
    public static interface AddFunction {
        public void accept(ItemStack var1, CreativeModeTab.TabVisibility var2);
    }
}

