/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public record FloatRange(Optional<Float> min, Optional<Float> max) {
    public FloatRange {
        if (min.isEmpty() && max.isEmpty()) {
            throw new IllegalArgumentException("Cannot create float range without a \"min\" or a \"max\" field");
        }
    }

    public boolean test(int value) {
        return (this.min.isEmpty() || (float)value >= this.min.get().floatValue()) && (this.max.isEmpty() || (float)value <= this.max.get().floatValue());
    }

    public float randomise(RandomSource source) {
        return Mth.nextFloat((RandomSource)source, (float)this.min.orElse(this.max.get()).floatValue(), (float)this.max.orElse(this.min.get()).floatValue());
    }

    private static Codec<FloatRange> directCodec(float min, float max) {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.floatRange((float)min, (float)max).optionalFieldOf("min").forGetter(FloatRange::min), (App)Codec.floatRange((float)min, (float)max).optionalFieldOf("max").forGetter(FloatRange::max)).apply((Applicative)inst, FloatRange::new));
    }

    public static Codec<FloatRange> codec(float min, float max) {
        return Codec.either((Codec)Codec.floatRange((float)min, (float)max), FloatRange.directCodec(min, max)).xmap(either -> (FloatRange)either.map(flt -> new FloatRange(Optional.of(flt), Optional.of(flt)), Function.identity()), floatRange -> {
            if (floatRange.min().isPresent() && floatRange.max().isPresent() && floatRange.min() == floatRange.max()) {
                return Either.left((Object)floatRange.min().orElseThrow());
            }
            return Either.right((Object)floatRange);
        });
    }

    public static FloatRange exact(float value) {
        return new FloatRange(Optional.of(Float.valueOf(value)), Optional.of(Float.valueOf(value)));
    }

    public static FloatRange range(float min, float max) {
        return new FloatRange(Optional.of(Float.valueOf(min)), Optional.of(Float.valueOf(max)));
    }

    public static FloatRange lowerBound(float min) {
        return new FloatRange(Optional.of(Float.valueOf(min)), Optional.empty());
    }

    public static FloatRange upperBound(float max) {
        return new FloatRange(Optional.empty(), Optional.of(Float.valueOf(max)));
    }
}

