/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public record IntRange(Optional<Integer> min, Optional<Integer> max) {
    public IntRange {
        if (min.isEmpty() && max.isEmpty()) {
            throw new IllegalArgumentException("Cannot create int range without a \"min\" or a \"max\" field");
        }
    }

    public boolean test(int value) {
        return !(!this.min.isEmpty() && value < this.min.get() || !this.max.isEmpty() && value > this.max.get());
    }

    public int randomise(RandomSource source) {
        return Mth.nextInt((RandomSource)source, (int)this.min.orElse(this.max.get()), (int)this.max.orElse(this.min.get()));
    }

    private static Codec<IntRange> directCodec(int min, int max) {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)min, (int)max).optionalFieldOf("min").forGetter(IntRange::min), (App)Codec.intRange((int)min, (int)max).optionalFieldOf("max").forGetter(IntRange::max)).apply((Applicative)inst, IntRange::new));
    }

    public static Codec<IntRange> codec(int min, int max) {
        return Codec.either((Codec)Codec.intRange((int)min, (int)max), IntRange.directCodec(min, max)).xmap(either -> (IntRange)either.map(integer -> new IntRange(Optional.of(integer), Optional.of(integer)), Function.identity()), intRange -> {
            if (intRange.min().isPresent() && intRange.max().isPresent() && intRange.min() == intRange.max()) {
                return Either.left((Object)intRange.min().orElseThrow());
            }
            return Either.right((Object)intRange);
        });
    }

    public static IntRange exact(int value) {
        return new IntRange(Optional.of(value), Optional.of(value));
    }

    public static IntRange range(int min, int max) {
        return new IntRange(Optional.of(min), Optional.of(max));
    }

    public static IntRange lowerBound(int min) {
        return new IntRange(Optional.of(min), Optional.empty());
    }

    public static IntRange upperBound(int max) {
        return new IntRange(Optional.empty(), Optional.of(max));
    }
}

