/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.BovinesCowTypes;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.api.variant.OffspringConditions;
import house.greenhouse.bovinesandbuttercups.content.advancement.criterion.BreedCowWithVariantTrigger;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MooshroomConfiguration;
import house.greenhouse.bovinesandbuttercups.content.loot.BovinesLootContextParamSets;
import house.greenhouse.bovinesandbuttercups.content.loot.BovinesLootContextParams;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MooshroomChildTypeUtil {
    public static Pair<Holder<CowVariant<MooshroomConfiguration>>, Optional<Holder<CowVariant<MooshroomConfiguration>>>> chooseMooshroomBabyVariant(MushroomCow parent, MushroomCow other, MushroomCow child, @Nullable Player player) {
        ArrayList<Holder.Reference> eligibleCowTypes = new ArrayList<Holder.Reference>();
        Registry registry = parent.level().registryAccess().lookupOrThrow(BovinesRegistryKeys.COW_VARIANT);
        Iterator<Holder.Reference> iterator = registry.registryKeySet().stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).filter(type -> type.isBound() && ((CowVariant)type.value()).type() == BovinesCowTypes.MOOSHROOM_TYPE && ((MooshroomConfiguration)((CowVariant)type.value()).configuration()).offspringConditions() != OffspringConditions.EMPTY).toList().iterator();
        while (iterator.hasNext()) {
            Holder.Reference cowVariant;
            Holder.Reference mooshroomVariant = cowVariant = iterator.next();
            OffspringConditions conditions = ((MooshroomConfiguration)((CowVariant)mooshroomVariant.value()).configuration()).offspringConditions();
            LootParams.Builder params = new LootParams.Builder((ServerLevel)parent.level());
            params.withParameter(LootContextParams.THIS_ENTITY, (Object)parent);
            params.withParameter(BovinesLootContextParams.PARTNER, (Object)other);
            params.withParameter(BovinesLootContextParams.CHILD, (Object)child);
            params.withParameter(LootContextParams.ORIGIN, (Object)parent.position());
            params.withParameter(BovinesLootContextParams.BREEDING_TYPE, (Object)cowVariant);
            LootContext thisContext = new LootContext.Builder(params.create(BovinesLootContextParamSets.BREEDING)).create(Optional.empty());
            params.withParameter(LootContextParams.THIS_ENTITY, (Object)other);
            params.withParameter(BovinesLootContextParams.PARTNER, (Object)parent);
            LootContext otherContext = new LootContext.Builder(params.create(BovinesLootContextParamSets.BREEDING)).create(Optional.empty());
            if ((!conditions.thisConditions().stream().allMatch(condition -> condition.test((Object)thisContext)) || !conditions.otherConditions().stream().allMatch(condition -> condition.test((Object)otherContext))) && (!conditions.thisConditions().stream().allMatch(condition -> condition.test((Object)otherContext)) || !conditions.otherConditions().stream().allMatch(condition -> condition.test((Object)thisContext)))) continue;
            eligibleCowTypes.add(mooshroomVariant);
        }
        if (!eligibleCowTypes.isEmpty()) {
            int random = parent.getRandom().nextInt(eligibleCowTypes.size());
            Holder randomType = (Holder)eligibleCowTypes.get(random);
            MooshroomChildTypeUtil.createParticles(child, (Holder<CowVariant<MooshroomConfiguration>>)randomType, parent.position());
            if (parent.getLoveCause() != null) {
                BreedCowWithVariantTrigger.INSTANCE.trigger(parent.getLoveCause(), (Animal)parent, (Animal)other, (AgeableMob)child, true, randomType);
            }
            return ((MooshroomConfiguration)((CowVariant)randomType.value()).configuration()).offspringConditions().inheritance().handleInheritance(randomType, BovinesAndButtercups.getHelper().getCowVariantAttachment((LivingEntity)parent), BovinesAndButtercups.getHelper().getCowVariantAttachment((LivingEntity)other));
        }
        BovinesAndButtercups.getHelper().clearParticlePositions((LivingEntity)child);
        Holder parentType = CowVariantAttachment.getCowVariantHolderFromEntity((LivingEntity)parent, BovinesCowTypes.MOOSHROOM_TYPE);
        Holder otherType = CowVariantAttachment.getCowVariantHolderFromEntity((LivingEntity)other, BovinesCowTypes.MOOSHROOM_TYPE);
        if (parentType == null || otherType == null) {
            return null;
        }
        if (!otherType.equals(parentType) && parent.getRandom().nextBoolean()) {
            if (parent.getLoveCause() != null) {
                BreedCowWithVariantTrigger.INSTANCE.trigger(parent.getLoveCause(), (Animal)parent, (Animal)other, (AgeableMob)child, false, otherType);
            }
            return Pair.of(otherType, Optional.ofNullable(CowVariantAttachment.getPreviousCowVariantHolderFromEntity((LivingEntity)other, BovinesCowTypes.MOOSHROOM_TYPE)));
        }
        if (parent.getLoveCause() != null) {
            BreedCowWithVariantTrigger.INSTANCE.trigger(parent.getLoveCause(), (Animal)parent, (Animal)other, (AgeableMob)child, false, parentType);
        }
        return Pair.of(parentType, Optional.ofNullable(CowVariantAttachment.getPreviousCowVariantHolderFromEntity((LivingEntity)parent, BovinesCowTypes.MOOSHROOM_TYPE)));
    }

    private static void createParticles(MushroomCow child, Holder<CowVariant<MooshroomConfiguration>> type, Vec3 parentPos) {
        if (!type.isBound() || ((MooshroomConfiguration)((CowVariant)type.value()).configuration()).settings().particle().isEmpty()) {
            return;
        }
        if (BovinesAndButtercups.getHelper().getParticlePositions((LivingEntity)child).isEmpty() && !child.level().isClientSide()) {
            ((ServerLevel)child.level()).sendParticles(((MooshroomConfiguration)((CowVariant)type.value()).configuration()).settings().particle().get(), child.getX(), child.getY(0.5), child.getZ(), 6, 0.05, 0.05, 0.05, 0.01);
        }
        for (Vec3 pos : BovinesAndButtercups.getHelper().getParticlePositions((LivingEntity)child).get(type)) {
            MooshroomChildTypeUtil.createParticleTrail((LevelAccessor)child.level(), child.position(), pos, parentPos, ((MooshroomConfiguration)((CowVariant)type.value()).configuration()).settings().particle().get());
        }
        BovinesAndButtercups.getHelper().clearParticlePositions((LivingEntity)child);
    }

    private static void createParticleTrail(LevelAccessor level, Vec3 childPos, Vec3 pos, Vec3 parentPos, ParticleOptions options) {
        double value = (1.0 - 1.0 / (pos.distanceTo(childPos) + 1.0)) / 4.0;
        for (double d = 0.0; d < 1.0; d += value) {
            ((ServerLevel)level).sendParticles(options, Mth.lerp((double)d, (double)pos.x(), (double)parentPos.x()), Mth.lerp((double)d, (double)pos.y(), (double)parentPos.y()), Mth.lerp((double)d, (double)pos.z(), (double)parentPos.z()), 1, 0.05, 0.05, 0.05, 0.01);
        }
    }
}

