/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.util.dfu;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import house.greenhouse.bovinesandbuttercups.mixin.DataFixTypesAccessor;
import house.greenhouse.bovinesandbuttercups.util.dfu.fixer.NectarDecomponentizeFix;
import java.util.function.BiFunction;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;

public record BovinesDataFixer(DataFixer fixer) {
    public static final int CURRENT_VERSION = 100;
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static BovinesDataFixer instance;

    public static BovinesDataFixer get() {
        return instance;
    }

    public static void register() {
        if (instance == null) {
            instance = new BovinesDataFixer(BovinesDataFixer.registerFixers());
        }
    }

    private static DataFixer registerFixers() {
        DataFixerBuilder builder = new DataFixerBuilder(100);
        builder.addSchema(0, (integer, schema) -> DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getDataVersion().getVersion())));
        Schema schema100 = builder.addSchema(100, SAME);
        builder.addFixer((DataFix)new NectarDecomponentizeFix(schema100));
        return builder.build().fixer();
    }

    public <T> Dynamic<T> updateWithFixers(DataFixTypes types, Dynamic<T> dynamic, int originalMinecraftVersion) {
        return this.fixer.update(((DataFixTypesAccessor)types).bovinesandbuttercups$getType(), dynamic, BovinesDataFixer.getModDataVersion(dynamic, originalMinecraftVersion), 100);
    }

    public static <T> int getModDataVersion(Dynamic<T> dynamic, int originalMinecraftVersion) {
        return dynamic.get("bovinesandbuttercups:data_version").asInt(originalMinecraftVersion < 4189 ? 0 : 100);
    }

    public static CompoundTag setModDataVersion(CompoundTag tag) {
        tag.putInt("bovinesandbuttercups:data_version", 100);
        return tag;
    }
}

