/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mns.utils;

import com.finndog.mns.MNSCommon;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class GeneralUtils {
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<BlockState, Boolean>();

    private GeneralUtils() {
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, RandomSource random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(BlockState state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> Block.isShapeFullBlock((VoxelShape)stateIn.getOcclusionShape()));
    }

    public static ItemStack enchantRandomly(RegistryAccess registryAccess, RandomSource random, ItemStack itemToEnchant, float chance) {
        List<Holder.Reference> list;
        if (random.nextFloat() < chance && !(list = registryAccess.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(holder -> ((Enchantment)holder.value()).canEnchant(itemToEnchant) && holder.is(EnchantmentTags.ON_MOB_SPAWN_EQUIPMENT)).toList()).isEmpty()) {
            Holder.Reference enchantment = list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(Mth.nextInt((RandomSource)random, (int)((Enchantment)enchantment.value()).getMinLevel(), (int)((Enchantment)enchantment.value()).getMaxLevel()) + 1);
            itemToEnchant.enchant((Holder)enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.getMinY() + chunkGenerator.getGenDepth();
    }

    public static BlockPos getHighestLand(ChunkGenerator chunkGenerator, RandomState randomState, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(boundingBox.getCenter().getX(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40, boundingBox.getCenter().getZ());
        NoiseColumn blockView = chunkGenerator.getBaseColumn(mutable.getX(), mutable.getZ(), heightLimitView, randomState);
        while (mutable.getY() > chunkGenerator.getSeaLevel()) {
            BlockState currentBlockstate = blockView.getBlock(mutable.getY());
            if (!currentBlockstate.canOcclude()) {
                mutable.move(Direction.DOWN);
                continue;
            }
            if (blockView.getBlock(mutable.getY() + 3).isAir() && (canBeOnLiquid ? !currentBlockstate.isAir() : currentBlockstate.canOcclude())) {
                return mutable;
            }
            mutable.move(Direction.DOWN);
        }
        return mutable;
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, RandomState randomState, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(boundingBox.getCenter().getX(), chunkGenerator.getSeaLevel() + 1, boundingBox.getCenter().getZ());
        NoiseColumn blockView = chunkGenerator.getBaseColumn(mutable.getX(), mutable.getZ(), heightLimitView, randomState);
        BlockState currentBlockstate = blockView.getBlock(mutable.getY());
        while (mutable.getY() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40) {
            if ((canBeOnLiquid ? !currentBlockstate.isAir() : currentBlockstate.canOcclude()) && blockView.getBlock(mutable.getY() + 1).isAir() && blockView.getBlock(mutable.getY() + 5).isAir()) {
                mutable.move(Direction.UP);
                return mutable;
            }
            mutable.move(Direction.UP);
            currentBlockstate = blockView.getBlock(mutable.getY());
        }
        return mutable.set(mutable.getX(), chunkGenerator.getSeaLevel(), mutable.getZ());
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.set((Vec3i)pos);
        ChunkAccess currentChunk = worldView.getChunk((BlockPos)mutable);
        BlockState currentState = currentChunk.getBlockState((BlockPos)mutable);
        while (mutable.getY() >= worldView.getMinY() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.move(Direction.DOWN);
            currentState = currentChunk.getBlockState((BlockPos)mutable);
        }
        return mutable.getY();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.isAir() || !blockState.getFluidState().isEmpty() || blockState.is(BlockTags.REPLACEABLE_BY_TREES);
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).getBoundingBox().getCenter();
        int xOffset = targetPos.getX() - structureCenter.getX();
        int zOffset = targetPos.getZ() - structureCenter.getZ();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.move(xOffset, 0, zOffset);
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.JigsawBlockInfo jigsaw1, StructureTemplate.JigsawBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.info().state().getValue((Property)JigsawBlock.ORIENTATION);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.info().state().getValue((Property)JigsawBlock.ORIENTATION);
        return prop1.front() == prop2.front().getOpposite() && (prop1.top() == prop2.top() || GeneralUtils.isRollableJoint(jigsaw1, prop1)) && GeneralUtils.getStringMicroOptimised(jigsaw1.info().nbt(), "target").equals(GeneralUtils.getStringMicroOptimised(jigsaw2.info().nbt(), "name"));
    }

    private static boolean isRollableJoint(StructureTemplate.JigsawBlockInfo jigsaw1, FrontAndTop prop1) {
        String joint = GeneralUtils.getStringMicroOptimised(jigsaw1.info().nbt(), "joint");
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.front().getAxis().isHorizontal();
        }
        return joint.equals("rollable");
    }

    public static String getStringMicroOptimised(CompoundTag tag, String key) {
        String string;
        Tag tag2 = tag.get(key);
        if (tag2 instanceof StringTag) {
            StringTag stringTag = (StringTag)tag2;
            string = stringTag.getAsString();
        } else {
            string = "";
        }
        return string;
    }

    public static Map<ResourceLocation, List<JsonElement>> getAllDatapacksJSONElement(ResourceManager resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<ResourceLocation, List<JsonElement>> map = new HashMap<ResourceLocation, List<JsonElement>>();
        int dataTypeLength = dataType.length() + 1;
        for (Map.Entry resourceStackEntry : resourceManager.listResourceStacks(dataType, fileString -> fileString.toString().endsWith(".json")).entrySet()) {
            String identifierPath = ((ResourceLocation)resourceStackEntry.getKey()).getPath();
            ResourceLocation fileID = ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)resourceStackEntry.getKey()).getNamespace(), (String)identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                for (Resource resource : (List)resourceStackEntry.getValue()) {
                    InputStream fileStream = resource.open();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                        JsonElement countsJSONElement = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                        if (countsJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(countsJSONElement);
                            continue;
                        }
                        MNSCommon.LOGGER.error("(Moog's Nether Structures {} MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)dataType, (Object)fileID, resourceStackEntry);
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                MNSCommon.LOGGER.error("(Moog's Nether Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, resourceStackEntry, (Object)exception);
            }
        }
        return map;
    }
}

