/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.compat.rei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.mixin.itemgroup.CreativeInventoryScreenAccessor;
import io.wispforest.owo.mixin.ui.access.BaseOwoHandledScreenAccessor;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.ScissorStack;
import io.wispforest.owo.util.pond.OwoCreativeInventoryScreenExtensions;
import java.util.ArrayList;
import java.util.Collections;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

@REIPluginClient
public class OwoReiPlugin
implements REIClientPlugin {
    @Nullable
    private static OverlayRendererProvider.Sink renderSink = null;

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(CreativeModeInventoryScreen.class, screen -> {
            CreativeModeTab group = CreativeInventoryScreenAccessor.owo$getSelectedTab();
            if (!(group instanceof OwoItemGroup)) {
                return Collections.emptySet();
            }
            OwoItemGroup owoGroup = (OwoItemGroup)group;
            if (owoGroup.getButtons().isEmpty()) {
                return Collections.emptySet();
            }
            int x = ((OwoCreativeInventoryScreenExtensions)screen).owo$getRootX();
            int y = ((OwoCreativeInventoryScreenExtensions)screen).owo$getRootY();
            int stackHeight = owoGroup.getButtonStackHeight();
            y -= 13 * (stackHeight - 4);
            ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
            for (int i = 0; i < owoGroup.getButtons().size(); ++i) {
                int xOffset = x + 198 + i / stackHeight * 26;
                int yOffset = y + 10 + i % stackHeight * 30;
                rectangles.add(new Rectangle(xOffset, yOffset, 24, 24));
            }
            return rectangles;
        });
        zones.register(BaseOwoHandledScreen.class, screen -> screen.componentsForExclusionAreas().map(rect -> new Rectangle(rect.x(), rect.y(), rect.width(), rect.height())).toList());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDecider(new OverlayDecider(this){

            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return BaseOwoHandledScreen.class.isAssignableFrom(screen);
            }

            public OverlayRendererProvider getRendererProvider() {
                return new OverlayRendererProvider(this){

                    public void onApplied(OverlayRendererProvider.Sink sink) {
                        renderSink = sink;
                    }

                    public void onRemoved() {
                        renderSink = null;
                    }
                };
            }
        });
    }

    private static void renderOverlay(Screen screen, Runnable renderFunction) {
        if (REIRuntime.getInstance().getSearchTextField().getText().equals("froge")) {
            Matrix4fStack modelView = RenderSystem.getModelViewStack();
            long time = System.currentTimeMillis();
            float scale = 0.75f + (float)(Math.sin((double)time / 500.0) * 0.5);
            modelView.pushMatrix();
            modelView.translate((float)screen.width / 2.0f - scale / 2.0f * (float)screen.width, (float)screen.height / 2.0f - scale / 2.0f * (float)screen.height, 0.0f);
            modelView.scale(scale, scale, 1.0f);
            modelView.translate((float)(Math.sin((double)time / 1000.0) * 0.75) * (float)screen.width, (float)(Math.sin((double)time / 500.0) * 0.75) * (float)screen.height, 0.0f);
            modelView.translate((float)screen.width / 2.0f, (float)screen.height / 2.0f, 0.0f);
            modelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees((float)((double)time / 25.0 % 360.0)));
            modelView.translate((float)screen.width / -2.0f, (float)screen.height / -2.0f, 0.0f);
            for (int i = 0; i < 20; ++i) {
                modelView.pushMatrix();
                modelView.translate((float)screen.width / 2.0f, (float)screen.height / 2.0f, 0.0f);
                modelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees((float)(i * 18)));
                modelView.translate((float)screen.width / -2.0f, (float)screen.height / -2.0f, 0.0f);
                ScissorStack.pushDirect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
                renderFunction.run();
                GlStateManager._enableScissorTest();
                ScissorStack.pop();
                modelView.popMatrix();
            }
            modelView.popMatrix();
        } else {
            ScissorStack.pushDirect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            renderFunction.run();
            GlStateManager._enableScissorTest();
            ScissorStack.pop();
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(event -> {
            Screen patt0$temp = event.getScreen();
            if (!(patt0$temp instanceof BaseOwoHandledScreenAccessor)) {
                return;
            }
            BaseOwoHandledScreenAccessor accessor = (BaseOwoHandledScreenAccessor)patt0$temp;
            Object root = accessor.owo$getUIAdapter().rootComponent;
            Surface patt1$temp = root.surface();
            if (patt1$temp instanceof CallbackSurface) {
                CallbackSurface wrapped;
                surface = wrapped = (CallbackSurface)patt1$temp;
            } else {
                surface = new CallbackSurface(root.surface());
                root.surface(surface);
            }
            surface.callback = () -> {
                if (renderSink == null) {
                    return;
                }
                OwoReiPlugin.renderOverlay(event.getScreen(), () -> renderSink.render(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
            };
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            if (!(event.getScreen() instanceof BaseOwoHandledScreenAccessor)) {
                return;
            }
            if (renderSink == null) {
                return;
            }
            OwoReiPlugin.renderOverlay(event.getScreen(), () -> renderSink.lateRender(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        });
    }

    private static class CallbackSurface
    implements Surface {
        public final Surface inner;
        @NotNull
        public Runnable callback = () -> {};

        private CallbackSurface(Surface inner) {
            this.inner = inner;
        }

        @Override
        public void draw(OwoUIDrawContext context, ParentComponent component) {
            this.inner.draw(context, component);
            this.callback.run();
        }
    }
}

