/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ops;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class WorldOps {
    private WorldOps() {
    }

    public static void breakBlockWithItem(Level world, BlockPos pos, ItemStack breakItem) {
        WorldOps.breakBlockWithItem(world, pos, breakItem, null);
    }

    public static void breakBlockWithItem(Level world, BlockPos pos, ItemStack breakItem, @Nullable Entity breakingEntity) {
        BlockEntity breakEntity = world.getBlockState(pos).getBlock() instanceof EntityBlock ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)world.getBlockState(pos), (Level)world, (BlockPos)pos, (BlockEntity)breakEntity, (Entity)breakingEntity, (ItemStack)breakItem);
        world.destroyBlock(pos, false, breakingEntity);
    }

    public static void playSound(Level world, Vec3 pos, SoundEvent sound, SoundSource category) {
        WorldOps.playSound(world, BlockPos.containing((Position)pos), sound, category, 1.0f, 1.0f);
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent sound, SoundSource category) {
        WorldOps.playSound(world, pos, sound, category, 1.0f, 1.0f);
    }

    public static void playSound(Level world, Vec3 pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        world.playSound(null, BlockPos.containing((Position)pos), sound, category, volume, pitch);
    }

    public static void playSound(Level world, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        world.playSound(null, pos, sound, category, volume, pitch);
    }

    public static void updateIfOnServer(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        serverWorld.getChunkSource().blockChanged(pos);
    }

    public static void teleportToWorld(ServerPlayer player, ServerLevel target, Vec3 pos) {
        WorldOps.teleportToWorld(player, target, pos, 0.0f, 0.0f);
    }

    public static void teleportToWorld(ServerPlayer player, ServerLevel target, Vec3 pos, float yaw, float pitch) {
        player.teleportTo(target, pos.x, pos.y, pos.z, Set.of(), yaw, pitch, false);
        player.giveExperiencePoints(0);
        player.getActiveEffects().forEach(effect -> player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(player.getId(), effect, false)));
    }
}

