/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.shader;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.owo.mixin.shader.ShaderProgramAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class GlProgram {
    private static final List<Runnable> REGISTERED_PROGRAMS = new ArrayList<Runnable>();
    protected CompiledShaderProgram backingProgram;
    protected ShaderProgram programKey;

    public GlProgram(ResourceLocation id, VertexFormat vertexFormat) {
        this.programKey = new ShaderProgram(id.withPrefix("core/"), vertexFormat, ShaderDefines.EMPTY);
        REGISTERED_PROGRAMS.add(() -> {
            try {
                this.backingProgram = Minecraft.getInstance().getShaderManager().getProgramForLoading(this.programKey);
                this.setup();
            }
            catch (ShaderManager.CompilationException e) {
                throw new RuntimeException("Failed to initialized owo shader program", e);
            }
        });
    }

    public RenderStateShard.ShaderStateShard renderPhaseProgram() {
        return new RenderStateShard.ShaderStateShard(this.programKey);
    }

    public void use() {
        RenderSystem.setShader((ShaderProgram)this.programKey);
    }

    protected void setup() {
    }

    @Nullable
    protected Uniform findUniform(String name) {
        return ((ShaderProgramAccessor)this.backingProgram).owo$getUniformsByName().get(name);
    }

    @ApiStatus.Internal
    public static void loadAndSetupPrograms() {
        if (!ModLoader.hasErrors()) {
            REGISTERED_PROGRAMS.forEach(Runnable::run);
        }
    }
}

