/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.google.common.collect.ImmutableMap;
import io.wispforest.endec.Endec;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public record Color(float red, float green, float blue, float alpha) implements Animatable<Color>
{
    public static final Endec<Color> RGBA_HEX_ENDEC = Endec.STRING.xmap(string -> Color.ofArgb(Integer.parseUnsignedInt(string.substring(1), 16)), color -> color.asHexString(true));
    public static final Color BLACK = Color.ofRgb(0);
    public static final Color WHITE = Color.ofRgb(0xFFFFFF);
    public static final Color RED = Color.ofRgb(0xFF0000);
    public static final Color GREEN = Color.ofRgb(65280);
    public static final Color BLUE = Color.ofRgb(255);
    private static final Map<String, Color> NAMED_TEXT_COLORS = (Map)Stream.of(ChatFormatting.values()).filter(ChatFormatting::isColor).collect(ImmutableMap.toImmutableMap(formatting -> formatting.getName().toLowerCase(Locale.ROOT).replace("_", "-"), Color::ofFormatting));

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static Color ofArgb(int argb) {
        return new Color((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >>> 24) / 255.0f);
    }

    public static Color ofRgb(int rgb) {
        return new Color((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public static Color ofHsv(float hue, float saturation, float value) {
        return Color.ofRgb(Mth.hsvToRgb((float)(hue - 5.0E-8f), (float)saturation, (float)value));
    }

    public static Color ofHsv(float hue, float saturation, float value, float alpha) {
        return Color.ofArgb((int)(alpha * 255.0f) << 24 | Mth.hsvToRgb((float)(hue - 5.0E-8f), (float)saturation, (float)value));
    }

    public static Color ofFormatting(@NotNull ChatFormatting formatting) {
        Integer colorValue = formatting.getColor();
        return Color.ofRgb(colorValue == null ? 0 : colorValue);
    }

    public static Color ofDye(@NotNull DyeColor dyeColor) {
        return Color.ofArgb(dyeColor.getTextureDiffuseColor());
    }

    public static Color random() {
        return Color.ofArgb((int)(Math.random() * 1.6777215E7) | 0xFF000000);
    }

    public int rgb() {
        return (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public int argb() {
        return (int)(this.alpha * 255.0f) << 24 | (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public float[] hsv() {
        float hue;
        float cmax = Math.max(Math.max(this.red, this.green), this.blue);
        float cmin = Math.min(Math.min(this.red, this.green), this.blue);
        float value = cmax;
        float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - this.red) / (cmax - cmin);
            float greenc = (cmax - this.green) / (cmax - cmin);
            float bluec = (cmax - this.blue) / (cmax - cmin);
            hue = this.red == cmax ? bluec - greenc : (this.green == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new float[]{hue, saturation, value, this.alpha};
    }

    public String asHexString(boolean includeAlpha) {
        return includeAlpha ? String.format("#%08X", this.argb()) : String.format("#%06X", this.rgb());
    }

    @Override
    public Color interpolate(Color next, float delta) {
        return new Color(Mth.lerp((float)delta, (float)this.red, (float)next.red), Mth.lerp((float)delta, (float)this.green, (float)next.green), Mth.lerp((float)delta, (float)this.blue, (float)next.blue), Mth.lerp((float)delta, (float)this.alpha, (float)next.alpha));
    }

    public static Color parse(Node node) {
        String text = node.getTextContent().strip();
        if (!text.startsWith("#")) {
            Color color = NAMED_TEXT_COLORS.get(text);
            if (color != null) {
                return color;
            }
            throw new UIModelParsingException("Invalid color value '" + text + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
        }
        if (text.matches("#([A-Fa-f\\d]{2}){3,4}")) {
            return text.length() == 7 ? Color.ofRgb(Integer.parseUnsignedInt(text.substring(1), 16)) : Color.ofArgb(Integer.parseUnsignedInt(text.substring(1), 16));
        }
        throw new UIModelParsingException("Invalid color value '" + text + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
    }

    public static int parseAndPack(Node node) {
        return Color.parse(node).argb();
    }
}

