/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.owo.mixin.ui.DrawContextInvoker;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIRenderLayers;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2d;

public class OwoUIDrawContext
extends GuiGraphics {
    @Deprecated
    public static final ResourceLocation PANEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"textures/gui/panel.png");
    @Deprecated
    public static final ResourceLocation DARK_PANEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"textures/gui/dark_panel.png");
    @Deprecated
    public static final ResourceLocation PANEL_INSET_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"textures/gui/panel_inset.png");
    public static final ResourceLocation PANEL_NINE_PATCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"panel/default");
    public static final ResourceLocation DARK_PANEL_NINE_PATCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"panel/dark");
    public static final ResourceLocation PANEL_INSET_NINE_PATCH_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"panel/inset");
    private boolean recording = false;

    private OwoUIDrawContext(Minecraft client, MultiBufferSource.BufferSource vertexConsumers) {
        super(client, vertexConsumers);
    }

    public static OwoUIDrawContext of(GuiGraphics context) {
        OwoUIDrawContext owoContext = new OwoUIDrawContext(Minecraft.getInstance(), ((DrawContextInvoker)context).owo$vertexConsumers());
        ((DrawContextInvoker)((Object)owoContext)).owo$setScissorStack(((DrawContextInvoker)context).owo$getScissorStack());
        ((DrawContextInvoker)((Object)owoContext)).owo$setMatrices(((DrawContextInvoker)context).owo$getMatrices());
        return owoContext;
    }

    public MultiBufferSource.BufferSource vertexConsumers() {
        return ((DrawContextInvoker)((Object)this)).owo$vertexConsumers();
    }

    public static UtilityScreen utilityScreen() {
        return UtilityScreen.get();
    }

    public void drawRectOutline(int x, int y, int width, int height, int color) {
        this.drawRectOutline(RenderType.gui(), x, y, width, height, color);
    }

    public void drawRectOutline(RenderType layer, int x, int y, int width, int height, int color) {
        this.fill(layer, x, y, x + width, y + 1, color);
        this.fill(layer, x, y + height - 1, x + width, y + height, color);
        this.fill(layer, x, y + 1, x + 1, y + height - 1, color);
        this.fill(layer, x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public void drawGradientRect(int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        this.drawGradientRect(RenderType.gui(), x, y, width, height, topLeftColor, topRightColor, bottomRightColor, bottomLeftColor);
    }

    public void drawGradientRect(RenderType layer, int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        VertexConsumer buffer = this.vertexConsumers().getBuffer(layer);
        Matrix4f matrix = this.pose().last().pose();
        buffer.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setColor(topRightColor);
        buffer.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(topLeftColor);
        buffer.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setColor(bottomLeftColor);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setColor(bottomRightColor);
    }

    public void drawPanel(int x, int y, int width, int height, boolean dark) {
        NinePatchTexture.draw(dark ? DARK_PANEL_NINE_PATCH_TEXTURE : PANEL_NINE_PATCH_TEXTURE, this, x, y, width, height);
    }

    public void drawSpectrum(int x, int y, int width, int height, boolean vertical) {
        VertexConsumer buffer = this.vertexConsumers().getBuffer((RenderType)OwoUIRenderLayers.GUI_SPECTRUM);
        Matrix4f matrix = this.pose().last().pose();
        buffer.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setColor(vertical ? 0.0f : 1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setColor(0.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setColor(vertical ? 1.0f : 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawText(net.minecraft.network.chat.Component text, float x, float y, float scale, int color) {
        this.drawText(text, x, y, scale, color, TextAnchor.TOP_LEFT);
    }

    public void drawText(net.minecraft.network.chat.Component text, float x, float y, float scale, int color, TextAnchor anchorPoint) {
        Font textRenderer = Minecraft.getInstance().font;
        this.pose().pushPose();
        this.pose().scale(scale, scale, 1.0f);
        switch (anchorPoint.ordinal()) {
            case 0: {
                x -= (float)textRenderer.width((FormattedText)text) * scale;
                break;
            }
            case 3: {
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
                break;
            }
            case 1: {
                x -= (float)textRenderer.width((FormattedText)text) * scale;
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
            }
        }
        this.drawString(textRenderer, text, (int)(x * (1.0f / scale)), (int)(y * (1.0f / scale)), color, false);
        this.pose().popPose();
    }

    public void drawLine(int x1, int y1, int x2, int y2, double thiccness, Color color) {
        this.drawLine(RenderType.gui(), x1, y1, x2, y2, thiccness, color);
    }

    public void drawLine(RenderType layer, int x1, int y1, int x2, int y2, double thiccness, Color color) {
        Vector2d offset = new Vector2d((double)(x2 - x1), (double)(y2 - y1)).perpendicular().normalize().mul(thiccness * 0.5);
        VertexConsumer buffer = this.vertexConsumers().getBuffer(layer);
        Matrix4f matrix = this.pose().last().pose();
        int vColor = color.argb();
        buffer.addVertex(matrix, (float)((double)x1 + offset.x), (float)((double)y1 + offset.y), 0.0f).setColor(vColor);
        buffer.addVertex(matrix, (float)((double)x1 - offset.x), (float)((double)y1 - offset.y), 0.0f).setColor(vColor);
        buffer.addVertex(matrix, (float)((double)x2 - offset.x), (float)((double)y2 - offset.y), 0.0f).setColor(vColor);
        buffer.addVertex(matrix, (float)((double)x2 + offset.x), (float)((double)y2 + offset.y), 0.0f).setColor(vColor);
    }

    public void drawCircle(int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle((RenderType)OwoUIRenderLayers.GUI_TRIANGLE_FAN, centerX, centerY, segments, radius, color);
    }

    public void drawCircle(int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        this.drawCircle((RenderType)OwoUIRenderLayers.GUI_TRIANGLE_FAN, centerX, centerY, angleFrom, angleTo, segments, radius, color);
    }

    public void drawCircle(RenderType renderLayer, int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle(renderLayer, centerX, centerY, 0.0, 360.0, segments, radius, color);
    }

    public void drawCircle(RenderType renderLayer, int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        VertexConsumer buffer = this.vertexConsumers().getBuffer(renderLayer);
        Matrix4f matrix = this.pose().last().pose();
        double angleStep = Math.toRadians(angleTo - angleFrom) / (double)segments;
        int vColor = color.argb();
        buffer.addVertex(matrix, (float)centerX, (float)centerY, 0.0f).setColor(vColor);
        for (int i = segments; i >= 0; --i) {
            double theta = Math.toRadians(angleFrom) + (double)i * angleStep;
            buffer.addVertex(matrix, (float)((double)centerX - Math.cos(theta) * radius), (float)((double)centerY - Math.sin(theta) * radius), 0.0f).setColor(vColor);
        }
    }

    public void drawRing(int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing((RenderType)OwoUIRenderLayers.GUI_TRIANGLE_STRIP, centerX, centerY, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing((RenderType)OwoUIRenderLayers.GUI_TRIANGLE_STRIP, centerX, centerY, angleFrom, angleTo, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(RenderType renderLayer, int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(renderLayer, centerX, centerY, 0.0, 360.0, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(RenderType renderLayer, int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        Preconditions.checkArgument((innerRadius < outerRadius ? 1 : 0) != 0, (Object)"innerRadius must be less than outerRadius");
        VertexConsumer buffer = this.vertexConsumers().getBuffer(renderLayer);
        Matrix4f matrix = this.pose().last().pose();
        double angleStep = Math.toRadians(angleTo - angleFrom) / (double)segments;
        int inColor = innerColor.argb();
        int outColor = outerColor.argb();
        for (int i = 0; i <= segments; ++i) {
            double theta = Math.toRadians(angleFrom) + (double)i * angleStep;
            buffer.addVertex(matrix, (float)((double)centerX - Math.cos(theta) * outerRadius), (float)((double)centerY - Math.sin(theta) * outerRadius), 0.0f).setColor(outColor);
            buffer.addVertex(matrix, (float)((double)centerX - Math.cos(theta) * innerRadius), (float)((double)centerY - Math.sin(theta) * innerRadius), 0.0f).setColor(inColor);
        }
    }

    public void drawTooltip(Font textRenderer, int x, int y, List<ClientTooltipComponent> components) {
        this.drawTooltip(textRenderer, x, y, components, null);
    }

    public void drawTooltip(Font textRenderer, int x, int y, List<ClientTooltipComponent> components, @Nullable ResourceLocation texture) {
        ((DrawContextInvoker)((Object)this)).owo$renderTooltipFromComponents(textRenderer, components, x, y, DefaultTooltipPositioner.INSTANCE, texture);
    }

    public void drawInsets(int x, int y, int width, int height, Insets insets, int color) {
        this.drawInsets(RenderType.gui(), x, y, width, height, insets, color);
    }

    public void drawInsets(RenderType layer, int x, int y, int width, int height, Insets insets, int color) {
        this.fill(layer, x - insets.left(), y - insets.top(), x + width + insets.right(), y, color);
        this.fill(layer, x - insets.left(), y + height, x + width + insets.right(), y + height + insets.bottom(), color);
        this.fill(layer, x - insets.left(), y, x, y + height, color);
        this.fill(layer, x + width, y, x + width + insets.right(), y + height, color);
    }

    public void drawInspector(ParentComponent root, double mouseX, double mouseY, boolean onlyHovered) {
        Minecraft client = Minecraft.getInstance();
        Font textRenderer = client.font;
        ArrayList<Component> children = new ArrayList<Component>();
        if (!onlyHovered) {
            root.collectDescendants(children);
        } else if (root.childAt((int)mouseX, (int)mouseY) != null) {
            children.add(root.childAt((int)mouseX, (int)mouseY));
        }
        RenderType.CompositeRenderType renderLayer = OwoUIRenderLayers.GUI_NO_DEPTH;
        for (Component child : children) {
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                this.drawInsets((RenderType)renderLayer, parentComponent.x(), parentComponent.y(), parentComponent.width(), parentComponent.height(), ((Insets)parentComponent.padding().get()).inverted(), -1492325155);
            }
            Insets margins = (Insets)child.margins().get();
            this.drawInsets((RenderType)renderLayer, child.x(), child.y(), child.width(), child.height(), margins, -1476398280);
            this.drawRectOutline((RenderType)renderLayer, child.x(), child.y(), child.width(), child.height(), -12930817);
            if (!onlyHovered) continue;
            int inspectorX = child.x() + 1;
            int inspectorY = child.y() + child.height() + ((Insets)child.margins().get()).bottom() + 1;
            Objects.requireNonNull(textRenderer);
            int inspectorHeight = 9 * 2 + 4;
            if (inspectorY > client.getWindow().getGuiScaledHeight() - inspectorHeight) {
                if ((inspectorY -= child.fullSize().height() + inspectorHeight + 1) < 0) {
                    inspectorY = 1;
                }
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    inspectorX += ((Insets)parentComponent.padding().get()).left();
                    inspectorY += ((Insets)parentComponent.padding().get()).top();
                }
            }
            net.minecraft.network.chat.Component nameText = net.minecraft.network.chat.Component.nullToEmpty((String)(child.getClass().getSimpleName() + (String)(child.id() != null ? " '" + child.id() + "'" : "")));
            MutableComponent descriptor = net.minecraft.network.chat.Component.literal((String)(child.x() + "," + child.y() + " (" + child.width() + "," + child.height() + ") <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + "> "));
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                Insets padding = (Insets)parentComponent.padding().get();
                descriptor.append(" >" + padding.top() + "," + padding.bottom() + "," + padding.left() + "," + padding.right() + "<");
            }
            int width = Math.max(textRenderer.width((FormattedText)nameText), textRenderer.width((FormattedText)descriptor));
            this.fill((RenderType)renderLayer, inspectorX, inspectorY, inspectorX + width + 3, inspectorY + inspectorHeight, -1493172224);
            this.drawRectOutline((RenderType)renderLayer, inspectorX, inspectorY, width + 3, inspectorHeight, -1493172224);
            this.drawString(textRenderer, nameText, inspectorX + 2, inspectorY + 2, 0xFFFFFF, false);
            Objects.requireNonNull(textRenderer);
            this.drawString(textRenderer, (net.minecraft.network.chat.Component)descriptor, inspectorX + 2, inspectorY + 9 + 2, 0xFFFFFF, false);
        }
    }

    public static class UtilityScreen
    extends Screen {
        private static UtilityScreen INSTANCE;
        private Screen linkSourceScreen = null;

        private UtilityScreen() {
            super((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.empty());
        }

        public static UtilityScreen get() {
            if (INSTANCE == null) {
                INSTANCE = new UtilityScreen();
                Minecraft client = Minecraft.getInstance();
                INSTANCE.init(client, client.getWindow().getGuiScaledWidth(), client.getWindow().getGuiScaledHeight());
            }
            return INSTANCE;
        }

        public void setLinkSource(Screen screen) {
            this.linkSourceScreen = screen;
        }

        public void captureLinkSource() {
            this.setLinkSource(this.minecraft.screen);
        }

        @ApiStatus.Internal
        @Nullable
        public Screen getAndClearLinkSource() {
            Screen source = this.linkSourceScreen;
            this.linkSourceScreen = null;
            return source;
        }

        public boolean handleComponentClicked(@Nullable Style style) {
            return super.handleComponentClicked(style);
        }

        static {
            WindowResizeCallback.EVENT.register((client, window) -> {
                if (INSTANCE == null) {
                    return;
                }
                INSTANCE.init(client, window.getGuiScaledWidth(), window.getGuiScaledHeight());
            });
        }
    }

    public static enum TextAnchor {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

