/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.PositionedRectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public final class ScissorStack {
    private static final PoseStack EMPTY_STACK = new PoseStack();
    private static final Deque<PositionedRectangle> STACK = new ArrayDeque<PositionedRectangle>();

    private ScissorStack() {
    }

    public static void pushDirect(int x, int y, int width, int height) {
        Window window = Minecraft.getInstance().getWindow();
        double scale = window.getGuiScale();
        ScissorStack.push((int)((double)x / scale), (int)((double)window.getGuiScaledHeight() - (double)y / scale - (double)height / scale), (int)((double)width / scale), (int)((double)height / scale), (PoseStack)null);
    }

    public static void push(int x, int y, int width, int height, GuiGraphics context) {
        context.flush();
        ScissorStack.push(x, y, width, height, context.pose());
    }

    public static void push(int x, int y, int width, int height, @Nullable PoseStack matrices) {
        PositionedRectangle newFrame = ScissorStack.withGlTransform(x, y, width, height, matrices);
        if (STACK.isEmpty()) {
            STACK.push(newFrame);
        } else {
            PositionedRectangle top = STACK.peek();
            STACK.push(top.intersection(newFrame));
        }
        ScissorStack.applyState();
    }

    public static void pop() {
        if (STACK.isEmpty()) {
            throw new IllegalStateException("Cannot pop frame from empty scissor stack");
        }
        STACK.pop();
        ScissorStack.applyState();
    }

    private static void applyState() {
        if (STACK.isEmpty()) {
            Window window = Minecraft.getInstance().getWindow();
            GL11.glScissor((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
            return;
        }
        if (!GL11.glIsEnabled((int)3089)) {
            return;
        }
        PositionedRectangle newFrame = STACK.peek();
        Window window = Minecraft.getInstance().getWindow();
        double scale = window.getGuiScale();
        GL11.glScissor((int)Math.max(0, (int)((double)newFrame.x() * scale)), (int)Math.max((int)((double)window.getHeight() - (double)newFrame.y() * scale - (double)newFrame.height() * scale), 0), (int)Math.min(Mth.clamp((int)((int)((double)newFrame.width() * scale)), (int)0, (int)window.getWidth()), window.getWidth()), (int)Math.min(Mth.clamp((int)((int)((double)newFrame.height() * scale)), (int)0, (int)window.getHeight()), window.getHeight()));
    }

    public static void drawUnclipped(Runnable action) {
        boolean scissorEnabled = GL11.glIsEnabled((int)3089);
        if (scissorEnabled) {
            GlStateManager._disableScissorTest();
        }
        action.run();
        if (scissorEnabled) {
            GlStateManager._enableScissorTest();
        }
    }

    public static void popFramesAndDraw(int maxPopFrames, Runnable action) {
        ArrayList<PositionedRectangle> previousFrames = new ArrayList<PositionedRectangle>();
        while (maxPopFrames > 1 && STACK.size() > 1) {
            previousFrames.add(0, STACK.pop());
            --maxPopFrames;
        }
        ScissorStack.applyState();
        action.run();
        previousFrames.forEach(STACK::push);
        ScissorStack.applyState();
    }

    public static boolean isVisible(int x, int y, @Nullable PoseStack matrices) {
        PositionedRectangle top = STACK.peek();
        if (top == null) {
            return true;
        }
        return top.intersects(ScissorStack.withGlTransform(x, y, 0, 0, matrices));
    }

    public static boolean isVisible(Component component, @Nullable PoseStack matrices) {
        PositionedRectangle top = STACK.peek();
        if (top == null) {
            return true;
        }
        Insets margins = (Insets)component.margins().get();
        return top.intersects(ScissorStack.withGlTransform(component.x() - margins.left(), component.y() - margins.top(), component.width() + margins.right(), component.height() + margins.bottom(), matrices));
    }

    private static PositionedRectangle withGlTransform(int x, int y, int width, int height, @Nullable PoseStack matrices) {
        if (matrices == null) {
            matrices = EMPTY_STACK;
        }
        matrices.pushPose();
        matrices.mulPose(RenderSystem.getModelViewMatrix());
        Vector4f root = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
        Vector4f end = new Vector4f((float)(x + width), (float)(y + height), 0.0f, 1.0f);
        root.mul((Matrix4fc)matrices.last().pose());
        end.mul((Matrix4fc)matrices.last().pose());
        x = (int)root.x;
        y = (int)root.y;
        width = (int)Math.ceil(end.x - root.x);
        height = (int)Math.ceil(end.y - root.y);
        matrices.popPose();
        return PositionedRectangle.of(x, y, width, height);
    }
}

