/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.util;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UIErrorToast
implements Toast {
    private final List<FormattedCharSequence> errorMessage;
    private final Font textRenderer;
    private final int width;
    private Toast.Visibility visibility = Toast.Visibility.HIDE;

    public UIErrorToast(Throwable error) {
        this.textRenderer = Minecraft.getInstance().font;
        List<Component> texts = this.initText(String.valueOf(error.getMessage()), consumer -> {
            StackTraceElement stackTop = error.getStackTrace()[0];
            String[] errorLocation = stackTop.getClassName().split("\\.");
            consumer.accept(Component.literal((String)"Type: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)error.getClass().getSimpleName()).withStyle(ChatFormatting.GRAY)));
            consumer.accept(Component.literal((String)"Thrown by: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)(errorLocation[errorLocation.length - 1] + ":" + stackTop.getLineNumber())).withStyle(ChatFormatting.GRAY)));
        });
        this.width = Math.min(240, TextOps.width(this.textRenderer, texts) + 8);
        this.errorMessage = this.wrap(texts);
    }

    public UIErrorToast(String message) {
        this.textRenderer = Minecraft.getInstance().font;
        List<Component> texts = this.initText(message, consumer -> consumer.accept(Component.literal((String)"No context provided").withStyle(ChatFormatting.GRAY)));
        this.width = Math.min(240, TextOps.width(this.textRenderer, texts) + 8);
        this.errorMessage = this.wrap(texts);
    }

    public static void report(String message) {
        UIErrorToast.logErrorsDuringInitialLoad();
        Minecraft.getInstance().getToastManager().addToast((Toast)new UIErrorToast(message));
    }

    public static void report(Throwable error) {
        UIErrorToast.logErrorsDuringInitialLoad();
        Minecraft.getInstance().getToastManager().addToast((Toast)new UIErrorToast(error));
    }

    private static void logErrorsDuringInitialLoad() {
        if (UIModelLoader.hasCompletedInitialLoad()) {
            return;
        }
        Throwable throwable = new Throwable();
        Owo.LOGGER.error("An owo-ui error has occurred during the initial resource reload (on thread {}). This is likely a bug caused by *some* other mod initializing an owo-config screen significantly too early - please report it at https://github.com/wisp-forest/owo-lib/issues", (Object)Thread.currentThread().getName(), (Object)throwable);
    }

    public void update(ToastManager manager, long time) {
        this.visibility = time > 10000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public void render(GuiGraphics context, Font textRenderer, long startTime) {
        OwoUIDrawContext owoContext = OwoUIDrawContext.of(context);
        owoContext.fill(0, 0, this.width(), this.height(), 0x77000000);
        owoContext.drawRectOutline(0, 0, this.width(), this.height(), -1476460544);
        int xOffset = this.width() / 2 - this.textRenderer.width(this.errorMessage.get(0)) / 2;
        owoContext.drawString(this.textRenderer, this.errorMessage.get(0), 4 + xOffset, 4, 0xFFFFFF);
        for (int i = 1; i < this.errorMessage.size(); ++i) {
            owoContext.drawString(this.textRenderer, this.errorMessage.get(i), 4, 4 + i * 11, 0xFFFFFF, false);
        }
    }

    public int height() {
        return 6 + this.errorMessage.size() * 11;
    }

    public int width() {
        return this.width;
    }

    private List<Component> initText(String errorMessage, Consumer<Consumer<Component>> contextAppender) {
        ArrayList<Component> texts = new ArrayList<Component>();
        texts.add((Component)Component.literal((String)"owo-ui error").withStyle(ChatFormatting.RED));
        texts.add((Component)Component.literal((String)" "));
        contextAppender.accept(texts::add);
        texts.add((Component)Component.literal((String)" "));
        texts.add((Component)Component.literal((String)errorMessage));
        texts.add((Component)Component.literal((String)" "));
        texts.add((Component)Component.literal((String)"Check your log for details").withStyle(ChatFormatting.GRAY));
        return texts;
    }

    private List<FormattedCharSequence> wrap(List<Component> message) {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        for (Component text : message) {
            list.addAll(this.textRenderer.split((FormattedText)text, this.width() - 8));
        }
        return list;
    }

    public Object getToken() {
        return Type.VERY_TYPE;
    }

    static enum Type {
        VERY_TYPE;

    }
}

