/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.compat.skinshuffle;

import com.mojang.authlib.properties.Property;
import java.util.Collections;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshPayload;
import net.lionarius.skinrestorer.platform.Services;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SkinShuffleCompatibility {
    public static final String MOD_ID = "skinshuffle";
    private static final boolean SHOULD_APPLY = !Services.PLATFORM.isModLoaded("skinshuffle");

    private SkinShuffleCompatibility() {
    }

    public static boolean shouldApply() {
        return SHOULD_APPLY;
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        Services.COMPATIBILITY.skinShuffle_sendHandshake(player);
    }

    public static void handleSkinRefresh(MinecraftServer server, ServerPlayer player, SkinShuffleSkinRefreshPayload payload) {
        Property property = payload.textureProperty();
        if (!property.name().equals("textures")) {
            return;
        }
        if (!property.hasSignature()) {
            return;
        }
        server.execute(() -> {
            SkinRestorer.applySkin(server, Collections.singleton(player.getGameProfile()), new SkinValue(MOD_ID, null, null, property), !server.usesAuthentication());
            if (server.usesAuthentication() && SkinRestorer.getSkinStorage().hasSavedSkin(player.getUUID())) {
                SkinRestorer.getSkinStorage().deleteSkin(player.getUUID());
            }
        });
    }
}

