/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import java.util.Collections;
import java.util.List;
import net.lionarius.skinrestorer.SkinRestorer;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin {
    @Shadow
    @Final
    private MinecraftServer server;

    @Shadow
    public abstract List<ServerPlayer> getPlayers();

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    private void remove(ServerPlayer player, CallbackInfo ci) {
        SkinRestorer.Events.onPlayerDisconnect(player);
    }

    @Inject(method={"removeAll"}, at={@At(value="HEAD")})
    private void removeAll(CallbackInfo ci) {
        for (ServerPlayer player : this.getPlayers()) {
            SkinRestorer.Events.onPlayerDisconnect(player);
        }
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="HEAD")})
    private void placeNewPlayer(Connection connection, ServerPlayer player, CommonListenerCookie cookie, CallbackInfo ci) {
        if (SkinRestorer.getSkinStorage().hasSavedSkin(player.getUUID())) {
            SkinRestorer.applySkin(this.server, Collections.singleton(player.getGameProfile()), SkinRestorer.getSkinStorage().getSkin(player.getUUID()));
        }
    }
}

