/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin {
    @Shadow
    @Nullable
    private GameProfile authenticatedProfile;
    @Unique
    private CompletableFuture<Void> skinrestorer$pendingSkin;

    @Inject(method={"verifyLoginAndFinishConnectionSetup"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;")}, cancellable=true)
    public void waitForSkin(CallbackInfo ci) {
        if (this.skinrestorer$pendingSkin == null) {
            this.skinrestorer$pendingSkin = CompletableFuture.supplyAsync(() -> {
                GameProfile profile = this.authenticatedProfile;
                assert (profile != null);
                Property originalSkin = PlayerUtils.getPlayerSkin(profile);
                if (SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
                    if (originalSkin != null) {
                        SkinValue value = SkinRestorer.getSkinStorage().getSkin(profile.getId());
                        SkinRestorer.getSkinStorage().setSkin(profile.getId(), value.setOriginalValue(originalSkin));
                    }
                    if (SkinRestorer.getConfig().refreshSkinOnJoin()) {
                        SkinValue currentSkin = SkinRestorer.getSkinStorage().getSkin(profile.getId());
                        SkinProviderContext context = currentSkin.toProviderContext();
                        ServerLoginPacketListenerImplMixin.skinrestorer$fetchSkin(profile, context);
                    }
                    return null;
                }
                if (originalSkin == null && SkinRestorer.getConfig().fetchSkinOnFirstJoin()) {
                    SkinProviderContext context = new SkinProviderContext(SkinRestorer.getConfig().firstJoinSkinProvider().getName(), profile.getName(), null);
                    ServerLoginPacketListenerImplMixin.skinrestorer$fetchSkin(profile, context);
                }
                return null;
            });
        }
        if (!this.skinrestorer$pendingSkin.isDone()) {
            ci.cancel();
        }
    }

    @Unique
    private static void skinrestorer$fetchSkin(GameProfile profile, SkinProviderContext context) {
        SkinRestorer.LOGGER.debug("Fetching {}'s skin", (Object)profile.getName());
        Result result = SkinRestorer.getProvider(context.name()).map(provider -> provider.fetchSkin(context.argument(), context.variant())).orElseGet(() -> Result.error(new IllegalArgumentException("Skin provider is not registered: " + context.name())));
        if (!result.isError()) {
            SkinValue value = SkinValue.fromProviderContextWithValue(context, ((Optional)result.getSuccessValue()).orElse(null));
            SkinRestorer.getSkinStorage().setSkin(profile.getId(), value);
        } else {
            SkinRestorer.LOGGER.warn("Failed to fetch skin: {}", (Object)((Exception)result.getErrorValue()).getMessage());
        }
    }
}

