/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class GrowingPlantBehavior
implements BoneMealBehavior {
    protected final Direction growthDirection;

    public GrowingPlantBehavior(Direction growthDirection) {
        this.growthDirection = growthDirection;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos blockPos, BlockState blockState) {
        BlockPos headPos = this.getHeadPos((BlockGetter)level, blockPos, blockState.getBlock());
        return this.canGrowInto(level.getBlockState(headPos.relative(this.growthDirection)));
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos sourcePos, BlockState sourceState) {
        BlockPos topPos = this.getHeadPos((BlockGetter)level, sourcePos, sourceState.getBlock());
        this.performBonemealTop(level, random, topPos, sourceState);
    }

    private void performBonemealTop(ServerLevel level, RandomSource randomSource, BlockPos topPos, BlockState sourceState) {
        BlockPos blockpos = topPos.relative(this.growthDirection);
        int j = this.getBlocksToGrowWhenBonemealed(randomSource);
        for (int k = 0; k < j && this.canGrowInto(level.getBlockState(blockpos)); ++k) {
            level.setBlockAndUpdate(blockpos, this.getGrownBlockState(sourceState.getBlock(), sourceState));
            blockpos = blockpos.relative(this.growthDirection);
        }
    }

    private BlockPos getHeadPos(BlockGetter level, BlockPos blockPos, Block block) {
        return GrowingPlantBehavior.getTopConnectedBlock(level, blockPos, block, this.growthDirection);
    }

    public static BlockPos getTopConnectedBlock(BlockGetter level, BlockPos pos, Block block, Direction direction) {
        BlockState blockstate;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        do {
            mutable.move(direction);
        } while ((blockstate = level.getBlockState((BlockPos)mutable)).is(block));
        return mutable.move(direction.getOpposite());
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(BlockState var1);

    protected abstract BlockState getGrownBlockState(Block var1, BlockState var2);
}

