/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class NetherWartBehavior
implements BoneMealBehavior {
    public boolean isValidBonemealTarget(LevelReader level, BlockPos blockPos, BlockState blockState) {
        return !this.isMaxAge(blockState);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        this.growCrops((Level)level, blockPos, blockState);
    }

    public void growCrops(Level level, BlockPos blockPos, BlockState blockState) {
        int j;
        int i = this.getAge(blockState) + this.getBonemealAgeIncrease(level);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        level.setBlock(blockPos, this.getStateForAge(blockState, i), 2);
    }

    public BlockState getStateForAge(BlockState blockState, int plantAge) {
        return (BlockState)blockState.getBlock().defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(plantAge));
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.nextInt((RandomSource)level.random, (int)2, (int)5) / 3;
    }

    protected int getAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.getAgeProperty());
    }

    public IntegerProperty getAgeProperty() {
        return NetherWartBlock.AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public boolean isMaxAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.getAgeProperty()) >= this.getMaxAge();
    }
}

