/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.config.EDhApiBlocksToAvoid;
import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGLErrorHandlingMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGrassSideRendering;
import com.seibel.distanthorizons.api.enums.config.EDhApiHorizontalQuality;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.api.enums.config.EDhApiLoggerMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EDhApiMcRenderingFadeMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiServerFolderNameMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiUpdateBranch;
import com.seibel.distanthorizons.api.enums.config.EDhApiVerticalQuality;
import com.seibel.distanthorizons.api.enums.config.EDhApiWorldCompressionMode;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EDhApiQualityPreset;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EDhApiThreadPreset;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogColorMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogFalloff;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiHeightFogDirection;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiHeightFogMixMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRendererMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiTransparency;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorProgressDisplayLocation;
import com.seibel.distanthorizons.core.config.eventHandlers.QuickRenderToggleConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.ReloadLodsConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.RenderCacheConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.UnsafeValuesConfigListener;
import com.seibel.distanthorizons.core.config.eventHandlers.WorldCurvatureConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.QuickShowWorldGenProgressConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.RenderQualityPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryAppearance;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryPerformance;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class Config {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static ConfigCategory client = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Client.class)).build();
    private static boolean complicatedListenerSetupComplete = false;

    public static void completeDelayedSetup() {
        if (!complicatedListenerSetupComplete) {
            complicatedListenerSetupComplete = true;
            try {
                ThreadPresetConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                RenderQualityPresetConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                QuickRenderToggleConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                QuickShowWorldGenProgressConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                RenderCacheConfigEventHandler.getInstance();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception when running config delayed UI setup. Error: [" + e.getMessage() + "].", (Throwable)e);
            }
        }
    }

    private static boolean isRunningInDevEnvironment() {
        IMinecraftSharedWrapper mcShared = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
        File installFolder = mcShared.getInstallationDirectory();
        File installParentFolder = installFolder.getParentFile();
        if (installParentFolder != null && installParentFolder.getName().equals("run") && (installFolder.getName().equals("client") || installFolder.getName().equals("server"))) {
            return true;
        }
        return installFolder.getName().equals("run");
    }

    static /* synthetic */ boolean access$200() {
        return Config.isRunningInDevEnvironment();
    }

    public static class Client {
        public static ConfigEntry<Boolean> quickEnableRendering = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true, Distant Horizons will render LODs beyond the vanilla render distance.").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).build();
        public static ConfigUiLinkedEntry quickLodChunkRenderDistance = new ConfigUiLinkedEntry(Advanced.Graphics.Quality.lodChunkRenderDistanceRadius);
        public static ConfigEntry<EDhApiQualityPreset> qualityPresetSetting = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiQualityPreset.MEDIUM)).comment("Changing this setting will modify a number of different settings that will change the \nvisual fidelity of the rendered LODs.\n\nHigher settings will improve the graphical quality while increasing GPU and memory use.\n").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(RenderQualityPresetConfigEventHandler.INSTANCE).build();
        public static ConfigEntry<EDhApiThreadPreset> threadPresetSetting = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("common.threadPreset").set((Object)EDhApiThreadPreset.BALANCED)).comment("Changing this setting will modify a number of different settings that will change \nthe load that Distant Horizons is allowed to put on your CPU. \n\nHigher options will improve LOD generation and loading speed, \nbut will increase CPU load and may introduce stuttering.\n\nNote: This is a CPU relative setting. \nIt should put an equal amount of strain on a 2 core CPU as a 64 core CPU.\n").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ThreadPresetConfigEventHandler.INSTANCE).build();
        public static ConfigUiLinkedEntry quickEnableWorldGenerator = new ConfigUiLinkedEntry(Common.WorldGenerator.enableDistantGeneration);
        public static ConfigEntry<Boolean> quickShowWorldGenProgress = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).build();
        public static ConfigUiLinkedEntry quickLodCloudRendering = new ConfigUiLinkedEntry(Advanced.Graphics.GenericRendering.enableCloudRendering);
        public static ConfigEntry<Boolean> showDhOptionsButtonInMinecraftUi = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).setAppearance(EConfigEntryAppearance.ONLY_IN_FILE)).comment("Should Distant Horizon's config button appear in Minecraft's options screen next to the fov slider?").build();
        public static ConfigCategory advanced = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Advanced.class)).build();

        public static class Advanced {
            public static ConfigCategory graphics = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Graphics.class)).build();
            public static ConfigCategory worldGenerator = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Common.WorldGenerator.class)).setDestination("common.worldGenerator").build();
            public static ConfigCategory multiplayer = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Multiplayer.class)).build();
            public static ConfigCategory server = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Server.class)).setDestination("server").build();
            public static ConfigCategory lodBuilding = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Common.LodBuilding.class)).setDestination("common.lodBuilding").build();
            public static ConfigCategory multiThreading = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Common.MultiThreading.class)).setDestination("common.multiThreading").build();
            public static ConfigCategory autoUpdater = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AutoUpdater.class)).build();
            public static ConfigCategory logging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Common.Logging.class)).setDestination("common.logging").build();
            public static ConfigCategory debugging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Debugging.class)).build();

            public static class Graphics {
                public static ConfigCategory quality = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Quality.class)).build();
                public static ConfigUiLinkedEntry quickEnableSsao = new ConfigUiLinkedEntry(Ssao.enableSsao);
                public static ConfigCategory ssao = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Ssao.class)).build();
                public static ConfigUiLinkedEntry quickEnableGenericRendering = new ConfigUiLinkedEntry(GenericRendering.enableGenericRendering);
                public static ConfigCategory genericRendering = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(GenericRendering.class)).build();
                public static ConfigUiLinkedEntry quickEnableDhFog = new ConfigUiLinkedEntry(Fog.enableDhFog);
                public static ConfigUiLinkedEntry quickEnableMcFog = new ConfigUiLinkedEntry(Fog.enableVanillaFog);
                public static ConfigCategory fog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Fog.class)).build();
                public static ConfigUiLinkedEntry quickEnableNoiseTexture = new ConfigUiLinkedEntry(NoiseTexture.enableNoiseTexture);
                public static ConfigCategory noiseTexture = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(NoiseTexture.class)).build();
                public static ConfigUiLinkedEntry quickEnableCaveCulling = new ConfigUiLinkedEntry(Culling.enableCaveCulling);
                public static ConfigCategory culling = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Culling.class)).build();
                public static ConfigCategory experimental = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Experimental.class)).build();

                public static class Quality {
                    public static ConfigEntry<Integer> lodChunkRenderDistanceRadius = new ConfigEntry.Builder<Integer>().setMinDefaultMax(32, 256, 4096).comment("The radius of the mod's render distance. (measured in chunks)\n").setPerformance(EConfigEntryPerformance.HIGH).build();
                    public static ConfigEntry<EDhApiHorizontalQuality> horizontalQuality = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiHorizontalQuality.MEDIUM)).comment("This indicates how quickly LODs decrease in quality the further away they are. \nHigher settings will render higher quality fake chunks farther away, \nbut will increase memory and GPU usage.").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<EDhApiMaxHorizontalResolution> maxHorizontalResolution = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiMaxHorizontalResolution.BLOCK)).comment("What is the maximum detail LODs should be drawn at? \nHigher settings will increase memory and GPU usage. \n\n" + (Object)((Object)EDhApiMaxHorizontalResolution.CHUNK) + ": render 1 LOD for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.HALF_CHUNK) + ": render 4 LODs for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.FOUR_BLOCKS) + ": render 16 LODs for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.TWO_BLOCKS) + ": render 64 LODs for each Chunk. \n" + (Object)((Object)EDhApiMaxHorizontalResolution.BLOCK) + ": render 256 LODs for each Chunk (width of one block). \n\nLowest Quality: " + (Object)((Object)EDhApiMaxHorizontalResolution.CHUNK) + "\nHighest Quality: " + (Object)((Object)EDhApiMaxHorizontalResolution.BLOCK)).setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<EDhApiVerticalQuality> verticalQuality = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiVerticalQuality.MEDIUM)).comment("This indicates how well LODs will represent \noverhangs, caves, floating islands, etc. \nHigher options will make the world more accurate, butwill increase memory and GPU usage. \n\nLowest Quality: " + (Object)((Object)EDhApiVerticalQuality.HEIGHT_MAP) + "\nHighest Quality: " + (Object)((Object)EDhApiVerticalQuality.EXTREME)).setPerformance(EConfigEntryPerformance.VERY_HIGH).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<EDhApiTransparency> transparency = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiTransparency.COMPLETE)).comment("How should LOD transparency be handled. \n\n" + (Object)((Object)EDhApiTransparency.COMPLETE) + ": LODs will render transparent. \n" + (Object)((Object)EDhApiTransparency.FAKE) + ": LODs will be opaque, but shaded to match the blocks underneath. \n" + (Object)((Object)EDhApiTransparency.DISABLED) + ": LODs will be opaque. \n").setPerformance(EConfigEntryPerformance.MEDIUM).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<EDhApiBlocksToAvoid> blocksToIgnore = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiBlocksToAvoid.NON_COLLIDING)).comment("What blocks shouldn't be rendered as LODs? \n\n" + (Object)((Object)EDhApiBlocksToAvoid.NONE) + ": Represent all blocks in the LODs \n" + (Object)((Object)EDhApiBlocksToAvoid.NON_COLLIDING) + ": Only represent solid blocks in the LODs (tall grass, torches, etc. won't count for a LOD's height) \n").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> tintWithAvoidedBlocks = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should the blocks underneath avoided blocks gain the color of the avoided block? \n\nTrue: a red flower will tint the grass below it red. \nFalse: skipped blocks will not change color of surface below them. ").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Double> lodBias = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.0, null).comment("What the value should vanilla Minecraft's texture LodBias be? \nIf set to 0 the mod wont overwrite vanilla's default (which so happens to also be 0)").build();
                    public static ConfigEntry<EDhApiLodShading> lodShading = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiLodShading.AUTO)).comment("How should LODs be shaded? \n\n" + (Object)((Object)EDhApiLodShading.AUTO) + ": Uses the same side shading as vanilla Minecraft blocks. \n" + (Object)((Object)EDhApiLodShading.ENABLED) + ": Simulates Minecraft's block shading for LODs. \n              Can be used to force LOD shading when using some shaders. \n" + (Object)((Object)EDhApiLodShading.DISABLED) + ": All LOD sides will be rendered with the same brightness. \n").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<EDhApiGrassSideRendering> grassSideRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiGrassSideRendering.FADE_TO_DIRT)).comment("How should the sides and bottom of grass block LODs render? \n\n" + (Object)((Object)EDhApiGrassSideRendering.AS_GRASS) + ": all sides of dirt LOD's render using the top (green) color. \n" + (Object)((Object)EDhApiGrassSideRendering.FADE_TO_DIRT) + ": sides fade from grass to dirt. \n" + (Object)((Object)EDhApiGrassSideRendering.AS_DIRT) + ": sides render entirely as dirt. \n").setPerformance(EConfigEntryPerformance.NONE).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> ditherDhFade = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true LODs will fade away as you get closer to them. \nIf false LODs will cut off abruptly at a set distance from the camera. \nThis setting is affected by the vanilla overdraw prevention config. \n").setPerformance(EConfigEntryPerformance.LOW).build();
                    public static ConfigEntry<EDhApiMcRenderingFadeMode> vanillaFadeMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiMcRenderingFadeMode.DOUBLE_PASS)).comment("How should vanilla Minecraft fade into Distant Horizons LODs? \n\n" + (Object)((Object)EDhApiMcRenderingFadeMode.NONE) + ": Fastest, there will be a pronounced border between DH and MC rendering. \n" + (Object)((Object)EDhApiMcRenderingFadeMode.SINGLE_PASS) + ": Fades after MC's transparent pass, opaque blocks underwater won't be faded. \n" + (Object)((Object)EDhApiMcRenderingFadeMode.DOUBLE_PASS) + ": Slowest, fades after both MC's opaque and transparent passes, provides the smoothest transition. \n").setPerformance(EConfigEntryPerformance.LOW).build();
                    public static ConfigEntry<Double> brightnessMultiplier = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)1.0)).comment("How bright LOD colors are. \n\n0 = black \n1 = normal \n2 = near white").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Double> saturationMultiplier = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)1.0)).comment("How saturated LOD colors are. \n\n0 = black and white \n1 = normal \n2 = very saturated").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                }

                public static class Ssao {
                    public static ConfigEntry<Boolean> enableSsao = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Enable Screen Space Ambient Occlusion").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Integer> sampleCount = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)6)).comment("Determines how many points in space are sampled for the occlusion test. \nHigher numbers will improve quality and reduce banding, but will increase GPU load.").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Double> radius = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)4.0)).comment("Determines the radius Screen Space Ambient Occlusion is applied, measured in blocks.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> strength = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.2)).comment("Determines how dark the Screen Space Ambient Occlusion effect will be.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> bias = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.02)).comment("Increasing the value can reduce banding at the cost of reducing the strength of the effect.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> minLight = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.25)).comment("Determines how dark the occlusion shadows can be. \n0 = totally black at the corners \n1 = no shadow").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Integer> blurRadius = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)2)).comment("The radius, measured in pixels, that blurring is calculated for the SSAO. \nHigher numbers will reduce banding at the cost of GPU performance.").setPerformance(EConfigEntryPerformance.HIGH).build();
                }

                public static class GenericRendering {
                    public static ConfigEntry<Boolean> enableGenericRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true non terrain objects will be rendered in DH's terrain. \nThis includes beacon beams and clouds. \n").build();
                    public static ConfigEntry<Boolean> enableBeaconRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true LOD beacon beams will be rendered. \n").build();
                    public static ConfigEntry<Boolean> enableCloudRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true LOD clouds will be rendered. \n").build();
                    public static ConfigEntry<Boolean> enableInstancedRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Can be disabled to use much slower but more compatible direct rendering. \nDisabling this can be used to fix some crashes on Mac. \n").build();
                }

                public static class Fog {
                    private static final Double FOG_RANGE_MIN = 0.0;
                    private static final Double FOG_RANGE_MAX = Math.sqrt(2.0);
                    public static ConfigEntry<Boolean> enableDhFog = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Determines if fog is drawn on DH LODs. \n").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<EDhApiFogColorMode> colorMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogColorMode.USE_WORLD_FOG_COLOR)).comment("What color should fog use? \n\n" + (Object)((Object)EDhApiFogColorMode.USE_WORLD_FOG_COLOR) + ": Use the world's fog color. \n" + (Object)((Object)EDhApiFogColorMode.USE_SKY_COLOR) + ": Use the sky's color.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Boolean> enableVanillaFog = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Should Minecraft's fog render? \nNote: Other mods may conflict with this setting. \n").build();
                    @Deprecated
                    public static ConfigEntry<Boolean> disableVanillaFog = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(enableVanillaFog.get() == false ? 1 : 0))).setAppearance(EConfigEntryAppearance.ONLY_IN_API)).build();
                    public static ConfigEntry<Double> farFogStart = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 0.4, FOG_RANGE_MAX).comment("At what distance should the far fog start? \n\n0.0: Fog starts at the player's position. \n1.0: Fog starts at the closest edge of the vanilla render distance. \n1.414: Fog starts at the corner of the vanilla render distance.").build();
                    public static ConfigEntry<Double> farFogEnd = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 1.0, FOG_RANGE_MAX).comment("Where should the far fog end? \n\n0.0: Fog ends at player's position.\n1.0: Fog ends at the closest edge of the vanilla render distance. \n1.414: Fog ends at the corner of the vanilla render distance.").build();
                    public static ConfigEntry<Double> farFogMin = new ConfigEntry.Builder<Double>().setMinDefaultMax(-5.0, 0.0, FOG_RANGE_MAX).comment("What is the minimum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                    public static ConfigEntry<Double> farFogMax = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 1.0, 5.0).comment("What is the maximum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                    public static ConfigEntry<EDhApiFogFalloff> farFogFalloff = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED)).comment("How should the fog thickness should be calculated? \n\n" + (Object)((Object)EDhApiFogFalloff.LINEAR) + ": Linear based on distance (will ignore 'density')\n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL) + ": 1/(e^(distance*density)) \n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED) + ": 1/(e^((distance*density)^2)").build();
                    public static ConfigEntry<Double> farFogDensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, 2.5, 50.0).comment("Used in conjunction with the Fog Falloff.").build();
                    public static ConfigCategory heightFog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(HeightFog.class)).build();

                    static /* synthetic */ Double access$000() {
                        return FOG_RANGE_MIN;
                    }

                    static /* synthetic */ Double access$100() {
                        return FOG_RANGE_MAX;
                    }

                    static {
                        Fog.disableVanillaFog.addListener(new ConfigChangeListener<Boolean>(Fog.disableVanillaFog, disableVanillaFog -> enableVanillaFog.setApiValue((Boolean)disableVanillaFog)));
                    }

                    public static class HeightFog {
                        public static ConfigEntry<EDhApiHeightFogMixMode> heightFogMixMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiHeightFogMixMode.SPHERICAL)).comment("How should height effect the fog thickness? \nNote: height fog is combined with the other fog settings. \n\n" + (Object)((Object)EDhApiHeightFogMixMode.SPHERICAL) + ": Fog is calculated based on camera distance. \n" + (Object)((Object)EDhApiHeightFogMixMode.CYLINDRICAL) + ": Ignore height, fog is calculated based on horizontal distance. \n\n" + (Object)((Object)EDhApiHeightFogMixMode.MAX) + ": max(heightFog, farFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.ADDITION) + ": heightFog + farFog \n" + (Object)((Object)EDhApiHeightFogMixMode.MULTIPLY) + ": heightFog * farFog \n" + (Object)((Object)EDhApiHeightFogMixMode.INVERSE_MULTIPLY) + ": 1 - (1-heightFog) * (1-farFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.LIMITED_ADDITION) + ": farFog + max(farFog, heightFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.MULTIPLY_ADDITION) + ": farFog + farFog * heightFog \n" + (Object)((Object)EDhApiHeightFogMixMode.INVERSE_MULTIPLY_ADDITION) + ": farFog + 1 - (1-heightFog) * (1-farFog) \n" + (Object)((Object)EDhApiHeightFogMixMode.AVERAGE) + ": farFog*0.5 + heightFog*0.5 \n\n").build();
                        public static ConfigEntry<EDhApiHeightFogDirection> heightFogDirection = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiHeightFogDirection.BELOW_SET_HEIGHT)).comment("Where should the height fog start? \n\n" + (Object)((Object)EDhApiHeightFogDirection.ABOVE_CAMERA) + ": Height fog starts at the camera and goes towards the sky \n" + (Object)((Object)EDhApiHeightFogDirection.BELOW_CAMERA) + ": Height fog starts at the camera and goes towards the void \n" + (Object)((Object)EDhApiHeightFogDirection.ABOVE_AND_BELOW_CAMERA) + ": Height fog starts from the camera to goes towards both the sky and void \n" + (Object)((Object)EDhApiHeightFogDirection.ABOVE_SET_HEIGHT) + ": Height fog starts from a set height and goes towards the sky \n" + (Object)((Object)EDhApiHeightFogDirection.BELOW_SET_HEIGHT) + ": Height fog starts from a set height and goes towards the void \n" + (Object)((Object)EDhApiHeightFogDirection.ABOVE_AND_BELOW_SET_HEIGHT) + ": Height fog starts from a set height and goes towards both the sky and void").build();
                        public static ConfigEntry<Double> heightFogBaseHeight = new ConfigEntry.Builder<Double>().setMinDefaultMax(-4096.0, 80.0, 4096.0).comment("If the height fog is calculated around a set height, what is that height position?").build();
                        public static ConfigEntry<Double> heightFogStart = new ConfigEntry.Builder<Double>().setMinDefaultMax(Fog.access$000(), 0.0, Fog.access$100()).comment("Should the start of the height fog be offset? \n\n0.0: Fog start with no offset.\n1.0: Fog start with offset of the entire world's height. (Includes depth)").build();
                        public static ConfigEntry<Double> heightFogEnd = new ConfigEntry.Builder<Double>().setMinDefaultMax(Fog.access$000(), 0.6, Fog.access$100()).comment("Should the end of the height fog be offset? \n\n0.0: Fog end with no offset.\n1.0: Fog end with offset of the entire world's height. (Include depth)").build();
                        public static ConfigEntry<Double> heightFogMin = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.0, Fog.access$100()).comment("What is the minimum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                        public static ConfigEntry<Double> heightFogMax = new ConfigEntry.Builder<Double>().setMinDefaultMax(Fog.access$000(), 1.0, 5.0).comment("What is the maximum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                        public static ConfigEntry<EDhApiFogFalloff> heightFogFalloff = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED)).comment("How should the height fog thickness should be calculated? \n\n" + (Object)((Object)EDhApiFogFalloff.LINEAR) + ": Linear based on height (will ignore 'density')\n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL) + ": 1/(e^(height*density)) \n" + (Object)((Object)EDhApiFogFalloff.EXPONENTIAL_SQUARED) + ": 1/(e^((height*density)^2)").build();
                        public static ConfigEntry<Double> heightFogDensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, 20.0, 50.0).comment("What is the height fog's density?").build();
                    }
                }

                public static class NoiseTexture {
                    public static ConfigEntry<Boolean> enableNoiseTexture = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should a noise texture be applied to LODs? \n\nThis is done to simulate textures and make the LODs appear more detailed. \n").build();
                    public static ConfigEntry<Integer> noiseSteps = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, 4, null).comment("How many steps of noise should be applied to LODs?").build();
                    public static ConfigEntry<Double> noiseIntensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 5.0, 100.0).comment("How intense should the noise should be?").build();
                    public static ConfigEntry<Integer> noiseDropoff = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 1024, null).comment("Defines how far should the noise texture render before it fades away. (in blocks) \nSet to 0 to disable noise from fading away \n").build();
                }

                public static class Culling {
                    public static ConfigEntry<Double> overdrawPrevention = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.4, 1.0).comment("Determines how far from the camera Distant Horizons will start rendering. \nMeasured as a percentage of the vanilla render distance.\n\nHigher values will prevent LODs from rendering behind vanilla blocks at a higher distance,\nbut may cause holes to appear in the LODs. \nHoles are most likely to appear when flying through unloaded terrain. \n\nIncreasing the vanilla render distance increases the effectiveness of this setting.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Boolean> enableCaveCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled caves will be culled \n\nNOTE: This feature is under development and \n it is VERY experimental! Please don't report \n any issues related to this feature. \n\nAdditional Info: Currently this cull all faces \n with skylight value of 0 in dimensions that \n does not have a ceiling.").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> caveCullingHeight = new ConfigEntry.Builder<Integer>().setMinDefaultMax(-4096, 60, 4096).comment("At what Y value should cave culling start? \nLower this value if you get walls for areas with 0 light.").addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Boolean> disableBeaconDistanceCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If false all beacons near the camera won't be drawn to prevent vanilla overdraw. \nIf true all beacons will be rendered. \n\nGenerally this should be left as true. It's main purpose is for debugging\nbeacon updating/rendering.\n").build();
                    public static ConfigEntry<Boolean> disableFrustumCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true LODs outside the player's camera \naren't drawn, increasing GPU performance. \n\nIf false all LODs are drawn, even those behind \nthe player's camera, decreasing GPU performance. \n\nDisable this if you see LODs disappearing at the corners of your vision.").build();
                    public static ConfigEntry<Boolean> disableShadowPassFrustumCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Identical to the other frustum culling option\nonly used when a shader mod is present using the DH API\nand the shadow pass is being rendered.\n\nDisable this if shadows render incorrectly.").build();
                    public static ConfigEntry<String> ignoredRenderBlockCsv = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("minecraft:barrier,minecraft:structure_void,minecraft:light,minecraft:tripwire,minecraft:brown_mushroom")).comment("A comma separated list of block resource locations that won't be rendered by DH. \nNote: air is always included in this list. \n").build();
                    public static ConfigEntry<String> ignoredRenderCaveBlockCsv = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("minecraft:glow_lichen,minecraft:rail,minecraft:water,minecraft:lava,minecraft:bubble_column")).comment("A comma separated list of block resource locations that shouldn't be rendered \nif they are in a 0 sky light underground area. \nNote: air is always included in this list. \n").build();

                    static {
                        ignoredRenderBlockCsv.addListener(new ConfigChangeListener<String>(ignoredRenderBlockCsv, blockCsv -> {
                            IWrapperFactory wrapperFactory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
                            if (wrapperFactory != null) {
                                wrapperFactory.resetRendererIgnoredBlocksSet();
                                DhApi.Delayed.renderProxy.clearRenderDataCache();
                            }
                        }));
                        ignoredRenderCaveBlockCsv.addListener(new ConfigChangeListener<String>(ignoredRenderCaveBlockCsv, blockCsv -> {
                            IWrapperFactory wrapperFactory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
                            if (wrapperFactory != null) {
                                wrapperFactory.resetRendererIgnoredCaveBlocks();
                                DhApi.Delayed.renderProxy.clearRenderDataCache();
                            }
                        }));
                    }
                }

                public static class Experimental {
                    public static ConfigEntry<Integer> earthCurveRatio = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 0, 5000).comment("This is the earth size ratio when applying the curvature shader effect. \nNote: Enabling this feature may cause rendering bugs. \n\n0 = flat/disabled \n1 = 1 to 1 (6,371,000 blocks) \n100 = 1 to 100 (63,710 blocks) \n10000 = 1 to 10000 (637.1 blocks) \n\nNote: Due to current limitations, the min value is 50 \nand the max value is 5000. Any values outside this range \nwill be set to 0 (disabled).").addListener(WorldCurvatureConfigEventHandler.INSTANCE).build();
                }
            }

            public static class Multiplayer {
                public static ConfigEntry<EDhApiServerFolderNameMode> serverFolderNameMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiServerFolderNameMode.NAME_ONLY)).comment("How should multiplayer save folders should be named? \n\n" + (Object)((Object)EDhApiServerFolderNameMode.NAME_ONLY) + ": Example: \"Minecraft Server\" \n" + (Object)((Object)EDhApiServerFolderNameMode.IP_ONLY) + ": Example: \"192.168.1.40\" \n" + (Object)((Object)EDhApiServerFolderNameMode.NAME_IP) + ": Example: \"Minecraft Server IP 192.168.1.40\" \n" + (Object)((Object)EDhApiServerFolderNameMode.NAME_IP_PORT) + ": Example: \"Minecraft Server IP 192.168.1.40:25565\"" + (Object)((Object)EDhApiServerFolderNameMode.NAME_IP_PORT_MC_VERSION) + ": Example: \"Minecraft Server IP 192.168.1.40:25565 GameVersion 1.16.5\"").build();
            }

            public static class AutoUpdater {
                public static ConfigEntry<Boolean> enableAutoUpdater = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(!Config.access$200() ? 1 : 0))).comment("Automatically check for updates on game launch? \n").build();
                public static ConfigEntry<Boolean> enableSilentUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Should Distant Horizons silently, automatically download and install new versions? \nThis setting is force disabled on dedicated servers for stability reasons. \n").build();
                public static ConfigEntry<EDhApiUpdateBranch> updateBranch = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiUpdateBranch.AUTO)).comment("If DH should use the nightly (provided by Gitlab), or stable (provided by Modrinth) build. \nIf [" + (Object)((Object)EDhApiUpdateBranch.AUTO) + "] is selected DH will update to new stable releases if the current jar is a stable jar \nand will update to new nightly builds if the current jar is a nightly jar (IE the version number ends in '-dev').").build();
            }

            public static class Debugging {
                public static ConfigEntry<EDhApiRendererMode> rendererMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiRendererMode.DEFAULT)).comment("What renderer is active? \n\n" + (Object)((Object)EDhApiRendererMode.DEFAULT) + ": Default lod renderer \n" + (Object)((Object)EDhApiRendererMode.DEBUG) + ": Debug testing renderer \n" + (Object)((Object)EDhApiRendererMode.DISABLED) + ": Disable rendering").build();
                public static ConfigEntry<EDhApiDebugRendering> debugRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiDebugRendering.OFF)).comment("Should specialized colors/rendering modes be used? \n\n" + (Object)((Object)EDhApiDebugRendering.OFF) + ": LODs will be drawn with their normal colors. \n" + (Object)((Object)EDhApiDebugRendering.SHOW_DETAIL) + ": LODs' color will be based on their detail level. \n" + (Object)((Object)EDhApiDebugRendering.SHOW_BLOCK_MATERIAL) + ": LODs' color will be based on their material. \n" + (Object)((Object)EDhApiDebugRendering.SHOW_OVERLAPPING_QUADS) + ": LODs will be drawn with total white, but overlapping quads will be drawn with red. \n").build();
                public static ConfigEntry<Boolean> lodOnlyMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled this will disable (most) vanilla Minecraft rendering. \n\nNOTE: Do not report any issues when this mode is on! \n   This setting is only for fun and debugging. \n   Mod compatibility is not guaranteed.").build();
                public static ConfigEntry<Boolean> renderWireframe = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled the LODs will render as wireframe.").build();
                public static ConfigEntry<Boolean> enableDebugKeybindings = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true the F8 key can be used to cycle through the different debug modes. \nand the F6 key can be used to enable and disable LOD rendering.").build();
                public static ConfigEntry<Boolean> enableWhiteWorld = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Stops vertex colors from being passed. \nUseful for debugging shaders").build();
                public static ConfigEntry<Boolean> showOverlappingQuadErrors = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true overlapping quads will be rendered as bright red for easy identification. \nIf false the quads will be rendered normally. \n").build();
                public static ConfigEntry<Boolean> logBufferGarbageCollection = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true OpenGL Buffer garbage collection will be logged \nthis also includes the number of live buffers. \n").build();
                public static ConfigEntry<Boolean> allowUnsafeValues = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(UnsafeValuesConfigListener.INSTANCE).build();
                public static ConfigCategory debugWireframe = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(DebugWireframe.class)).build();
                public static ConfigCategory openGl = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(OpenGl.class)).build();
                public static ConfigCategory columnBuilderDebugging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(ColumnBuilderDebugging.class)).build();
                public static ConfigCategory f3Screen = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(F3Screen.class)).build();
                public static ConfigCategory exampleConfigScreen = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(ExampleConfigScreen.class)).build();

                public static class DebugWireframe {
                    public static ConfigEntry<Boolean> enableRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled, various wireframes for debugging internal functions will be drawn. \n\nNOTE: There WILL be performance hit! \n   Additionally, only stuff that's loaded after you enable this \n   will render their debug wireframes. \n").build();
                    public static ConfigEntry<Boolean> showWorldGenQueue = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render queued world gen tasks?").build();
                    public static ConfigEntry<Boolean> showRenderSectionStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render LOD section status?").build();
                    public static ConfigEntry<Boolean> showRenderSectionToggling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("A white box will be drawn when an LOD starts rendering \nand a purple box when an LOD stops rendering. \n\nThis can be used to debug Quad Tree holes.\n").build();
                    public static ConfigEntry<Boolean> showQuadTreeRenderStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render Quad Tree Rendering status?").build();
                    public static ConfigEntry<Boolean> showFullDataUpdateStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render full data update/lock status?").build();
                }

                public static class OpenGl {
                    public static ConfigEntry<Boolean> overrideVanillaGLLogger = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ModInfo.IS_DEV_BUILD)).comment("Requires a reboot to change. \n").build();
                    public static ConfigEntry<EDhApiGLErrorHandlingMode> glErrorHandlingMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(ModInfo.IS_DEV_BUILD ? EDhApiGLErrorHandlingMode.LOG : EDhApiGLErrorHandlingMode.IGNORE))).comment("Defines how OpenGL errors are handled. \nMay incorrectly catch OpenGL errors thrown by other mods. \n\n" + (Object)((Object)EDhApiGLErrorHandlingMode.IGNORE) + ": Do nothing. \n" + (Object)((Object)EDhApiGLErrorHandlingMode.LOG) + ": write an error to the log. \n" + (Object)((Object)EDhApiGLErrorHandlingMode.LOG_THROW) + ": write to the log and throw an exception. \n           Warning: this should only be enabled when debugging the LOD renderer \n           as it may break Minecraft's renderer when an exception is thrown. \n").build();
                    public static ConfigEntry<Boolean> validateBufferIdsBeforeRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Massively reduces FPS. \nShould only be used if mysterious EXCEPTION_ACCESS_VIOLATION crashes are happening in DH's rendering code for troubleshooting. \n").build();
                }

                public static class ColumnBuilderDebugging {
                    public static ConfigEntry<Boolean> columnBuilderDebugEnable = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> columnBuilderDebugDetailLevel = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)6)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> columnBuilderDebugXPos = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> columnBuilderDebugZPos = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> columnBuilderDebugXRow = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)-1)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> columnBuilderDebugZRow = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)-1)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Integer> columnBuilderDebugColumnIndex = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)-1)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ReloadLodsConfigEventHandler.INSTANCE).build();
                }

                public static class F3Screen {
                    public static ConfigEntry<Boolean> showPlayerPos = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Shows info about each thread pool.").build();
                    public static ConfigEntry<Integer> playerPosSectionDetailLevel = new ConfigEntry.Builder<Integer>().setMinDefaultMax(6, 6, 16).comment("Defines what internal detail level the player position will be shown as. \nInternal detail level means: 6 = 1x1 block, 7 = 2x2 blocks, etc. \n").build();
                    public static ConfigEntry<Boolean> showThreadPools = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Shows info about each thread pool.").build();
                    public static ConfigEntry<Boolean> showCombinedObjectPools = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Shows the combined memory use and array counts for all DH pooled objects.").build();
                    public static ConfigEntry<Boolean> showSeparatedObjectPools = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Shows the memory use and array counts for each DH object pool.").build();
                    public static ConfigEntry<Boolean> showQueuedChunkUpdateCount = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Shows how many chunks are queud for processing and the max count that can be queued.").build();
                    public static ConfigEntry<Boolean> showLevelStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Shows what levels are loaded and world gen/rendering info about those levels.").build();
                }

                public static class ExampleConfigScreen {
                    public static ConfigUIComment debugConfigScreenNote = new ConfigUIComment();
                    public static ConfigEntry<Boolean> boolTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).build();
                    public static ConfigEntry<Byte> byteTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)8)).build();
                    public static ConfigEntry<Integer> intTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)69420)).build();
                    public static ConfigEntry<Double> doubleTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)420.69)).build();
                    public static ConfigEntry<Short> shortTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)69)).build();
                    public static ConfigEntry<Long> longTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)42069L)).build();
                    public static ConfigEntry<Float> floatTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(Float.valueOf(0.42069f))).build();
                    public static ConfigEntry<String> stringTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("Test input box")).build();
                    public static ConfigEntry<List<String>> listTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(new ArrayList<String>(Arrays.asList("option 1", "option 2", "option 3")))).build();
                    public static ConfigEntry<Map<String, String>> mapTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(new HashMap())).build();
                    public static ConfigUIButton uiButtonTest = new ConfigUIButton(() -> new Thread(() -> {
                        if (!GraphicsEnvironment.isHeadless()) {
                            LOGGER.info("Attempting to show tinyfd message box...");
                            boolean buttonPress = TinyFileDialogs.tinyfd_messageBox((CharSequence)"Button pressed!", (CharSequence)"UITester dialog", (CharSequence)"ok", (CharSequence)"info", (boolean)false);
                            LOGGER.info("dialog returned with [" + (buttonPress ? "TRUE" : "FALSE") + "]");
                        } else {
                            LOGGER.info("button pressed!");
                        }
                    }).start());
                    public static ConfigCategory categoryTest = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(CategoryTest.class)).build();
                    public static ConfigEntry<Integer> linkableTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)420)).build();

                    public static class CategoryTest {
                        public static ConfigUiLinkedEntry linkableTest = new ConfigUiLinkedEntry(linkableTest);
                    }
                }
            }
        }
    }

    public static class Server {
        public static ConfigEntry<Boolean> sendLevelKeys = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("levelKeys.send").setAppearance(EConfigEntryAppearance.ONLY_IN_FILE)).set((Object)true)).comment("Makes the server send level keys for each world.\nDisable this if you use alternative ways to send level keys.\n").build();
        public static ConfigEntry<String> levelKeyPrefix = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("levelKeys.prefix").set("")).comment("Prefix of the level keys sent to the clients.\nIf the mod is running behind a proxy, each backend should use a unique value.\nIf this value is empty, level key will be based on the server's seed hash.\n").build();
        public static ConfigEntry<Integer> generationRequestRateLimit = new ConfigEntry.Builder().setChatCommandName("generation.requestRateLimit").setMinDefaultMax(1, 20, 100).comment("How many LOD generation requests per second should a client send? \nAlso limits the number of client requests allowed to stay in the server's queue.").build();
        public static ConfigEntry<Integer> maxGenerationRequestDistance = new ConfigEntry.Builder().setChatCommandName("generation.maxRequestDistance").setMinDefaultMax(256, 4096, 4096).comment("Defines the distance allowed to generate around the player.").setPerformance(EConfigEntryPerformance.HIGH).build();
        public static ConfigEntry<Boolean> generateOnlyInHighestDetail = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("generation.highestDetailOnly").set((Object)false)).comment("Makes the server reject all generation requests for detail levels below the highest one.\n").build();
        public static ConfigEntry<Boolean> enableRealTimeUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("realTimeUpdates.enable").set((Object)true)).comment("If true, clients will receive real-time LOD updates for chunks outside the client's render distance.").build();
        public static ConfigEntry<Integer> realTimeUpdateDistanceRadiusInChunks = new ConfigEntry.Builder().setChatCommandName("realTimeUpdates.playerDistance").setMinDefaultMax(32, 256, 4096).comment("Defines the distance the player will receive updates around.").setPerformance(EConfigEntryPerformance.HIGH).build();
        public static ConfigEntry<Boolean> synchronizeOnLoad = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("syncOnLoad.enable").set((Object)true)).comment("If true, clients will receive updated LODs when joining or loading new LODs. \n").build();
        public static ConfigEntry<Integer> syncOnLoadRateLimit = new ConfigEntry.Builder().setChatCommandName("syncOnLoad.rateLimit").setMinDefaultMax(1, 50, 100).comment("How many LOD sync requests per second should a client send? \nAlso limits the amount of player's requests allowed to stay in the server's queue.").build();
        public static ConfigEntry<Integer> maxSyncOnLoadRequestDistance = new ConfigEntry.Builder().setChatCommandName("syncOnLoad.maxRequestDistance").setMinDefaultMax(256, 4096, 4096).comment("Defines the distance allowed to be synchronized around the player. \nShould be the same or larger than maxGenerationRequestDistance in most cases.").setPerformance(EConfigEntryPerformance.HIGH).build();
        public static ConfigEntry<Integer> maxDataTransferSpeed = new ConfigEntry.Builder().setChatCommandName("common.maxDataTransferSpeed").setMinDefaultMax(0, 500, 1000000).comment("Maximum speed for uploading LODs to the clients, in KB/s.\nValue of 0 disables the limit.").build();
    }

    public static class Common {

        public static class Logging {
            public static ConfigEntry<EDhApiLoggerMode> logWorldGenEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("logging.logWorldGenEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the world generation process. \nThis can be useful for debugging.").build();
            public static ConfigEntry<EDhApiLoggerMode> logWorldGenPerformance = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("logging.logWorldGenPerformance").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log performance about the world generation process. \nThis can be useful for debugging.").build();
            public static ConfigEntry<EDhApiLoggerMode> logWorldGenLoadEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("logging.logWorldGenPerformance").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the world generation process. \nThis can be useful for debugging.").build();
            public static ConfigEntry<EDhApiLoggerMode> logRendererBufferEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the renderer buffer process. \nThis can be useful for debugging.").build();
            public static ConfigEntry<EDhApiLoggerMode> logRendererGLEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the renderer OpenGL process. \nThis can be useful for debugging.").build();
            public static ConfigEntry<EDhApiLoggerMode> logNetworkEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("logging.logNetworkEvent").set((Object)EDhApiLoggerMode.LOG_ERROR_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about network operations. \nThis can be useful for debugging.").build();
            public static ConfigCategory warning = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Warning.class)).build();

            public static class Warning {
                public static ConfigEntry<Boolean> showLowMemoryWarningOnStartup = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed if Java doesn't have enough \nmemory allocated to run DH well. \n").build();
                public static ConfigEntry<Boolean> showPoolInsufficientMemoryWarning = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed if DH detects \nthat any pooled objects have been garbage collected. \n").build();
                public static ConfigEntry<Boolean> showHighVanillaRenderDistanceWarning = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed if vanilla MC's \nrender distance is higher than the recommended amount. \n").build();
                public static ConfigEntry<Boolean> showReplayWarningOnStartup = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed when a replay is started \ngiving some basic information about how DH will function. \n").build();
                public static ConfigEntry<Boolean> showUpdateQueueOverloadedChatWarning = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled, a chat message will be displayed when DH has too many chunks \nqueued for updating. \n").build();
                public static ConfigEntry<Boolean> showModCompatibilityWarningsOnStartup = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled, a chat message will be displayed when a potentially problematic \nmod is installed alongside DH. \n").build();
            }
        }

        public static class MultiThreading {
            public static final ConfigEntry<Integer> numberOfThreads = new ConfigEntry.Builder().setChatCommandName("threading.numberOfThreads").setMinDefaultMax(1, ThreadPresetConfigEventHandler.getDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used by Distant Horizons? \n").build();
            public static final ConfigEntry<Double> threadRunTimeRatio = new ConfigEntry.Builder().setChatCommandName("threading.threadRunTimeRatio").setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getDefaultRunTimeRatio(), 1.0).comment("A value between 1.0 and 0.0 that represents the percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance. \n").build();
        }

        public static class LodBuilding {
            public static ConfigEntry<Boolean> disableUnchangedChunkCheck = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(Config.access$200() ? EConfigEntryAppearance.ALL : EConfigEntryAppearance.ONLY_IN_FILE)).comment("Enabling this will drastically increase chunk processing time\nand you may need to increase your CPU load to handle it.\n\nNormally DH will attempt to skip creating LODs for chunks it's already seen\nand that haven't changed.\n\nHowever sometimes that logic incorrectly prevents LODs from being updated.\nDisabling this check may fix issues where LODs aren't updated after\nblocks have been changed.\n").build();
            public static ConfigEntry<EDhApiDataCompressionMode> dataCompression = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiDataCompressionMode.LZMA2)).comment("What algorithm should be used to compress new LOD data? \nThis setting will only affect new or updated LOD data, \nany data already generated when this setting is changed will be\nunaffected until it needs to be re-written to the database.\n\n" + (Object)((Object)EDhApiDataCompressionMode.UNCOMPRESSED) + " \nShould only be used for testing, is worse in every way vs [" + (Object)((Object)EDhApiDataCompressionMode.LZ4) + "].\nExpected Compression Ratio: 1.0\nEstimated average DTO read speed: 1.64 milliseconds\nEstimated average DTO write speed: 12.44 milliseconds\n\n" + (Object)((Object)EDhApiDataCompressionMode.LZ4) + " \nA good option if you're CPU limited and have plenty of hard drive space.\nExpected Compression Ratio: 0.36\nEstimated average DTO read speed: 1.85 ms\nEstimated average DTO write speed: 9.46 ms\n\n" + (Object)((Object)EDhApiDataCompressionMode.LZMA2) + " \nSlow but very good compression.\nExpected Compression Ratio: 0.14\nEstimated average DTO read speed: 11.89 ms\nEstimated average DTO write speed: 192.01 ms\n").build();
            public static ConfigEntry<EDhApiWorldCompressionMode> worldCompression = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiWorldCompressionMode.VISUALLY_EQUAL)).comment("How should block data be compressed when creating LOD data? \nThis setting will only affect new or updated LOD data, \nany data already generated when this setting is changed will be\nunaffected until it is modified or re-loaded.\n\n" + (Object)((Object)EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS) + " \nEvery block/biome change is recorded in the database. \nThis is what DH 2.0 and 2.0.1 all used by default and will store a lot of data. \nExpected Compression Ratio: 1.0\n\n" + (Object)((Object)EDhApiWorldCompressionMode.VISUALLY_EQUAL) + " \nOnly visible block/biome changes are recorded in the database. \nHidden blocks (IE ores) are ignored.  \nExpected Compression Ratio: 0.7\n").build();
            public static ConfigEntry<Boolean> recalculateChunkHeightmaps = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("True: Recalculate chunk height maps before chunks can be used by DH.\n      This can fix problems with worlds created by World Painter or \n      other external tools where the heightmap format may be incorrect. \nFalse: Assume any height maps handled by Minecraft are correct. \n\nFastest: False\nMost Compatible: True\n").build();
            public static ConfigEntry<Boolean> pullLightingForPregeneratedChunks = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true LOD generation for pre-existing chunks will attempt to pull the lighting data \nsaved in Minecraft's Region files. \nIf false DH will pull in chunks without lighting and re-light them. \n \nSetting this to true will result in faster LOD generation \nfor already generated worlds, but is broken by most lighting mods. \n \nSet this to false if LODs are black. \n").build();
            public static ConfigEntry<Boolean> assumePreExistingChunksAreFinished = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("When DH pulls in pre-existing chunks it will attempt to \nrun any missing world generation steps; for example: \nif a chunk has the status SURFACE, DH will skip BIOMES \nand SURFACE, but will run FEATURES. \n \nHowever if for some reason the chunks are malformed \nor there's some other issue that causes the status \nto be incorrect that can either cause world gen \nlock-ups and/or crashes. \nIf either of those happen try setting this to True. \n").build();
        }

        public static class WorldGenerator {
            public static ConfigEntry<Boolean> enableDistantGeneration = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("generation.enable").set((Object)true)).comment(" Should Distant Horizons slowly generate LODs \n outside the vanilla render distance? \nDepending on the generator mode, this will import existing chunks \nand/or generating missing chunks.").build();
            public static ConfigEntry<EDhApiDistantGeneratorMode> distantGeneratorMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().setChatCommandName("generation.mode").set((Object)EDhApiDistantGeneratorMode.FEATURES)).comment("How detailed should LODs be generated outside the vanilla render distance? \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + " \nOnly create LOD data for already generated chunks. \n\n\n" + (Object)((Object)EDhApiDistantGeneratorMode.SURFACE) + " \nGenerate the world surface, \nthis does NOT include trees, \nor structures. \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.FEATURES) + " \nGenerate everything except structures. \nWARNING: This may cause world generator bugs or instability when paired with certain world generator mods. \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.INTERNAL_SERVER) + " \nAsk the local server to generate/load each chunk. \nThis is the most compatible and will generate structures correctly, \nbut may cause server/simulation lag. \nNote: unlike other modes this option DOES save generated chunks to \nMinecraft's region files. \n").build();
            public static ConfigEntry<EDhApiDistantGeneratorProgressDisplayLocation> showGenerationProgress = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiDistantGeneratorProgressDisplayLocation.OVERLAY)).comment("How should distant generator progress be displayed? \n\n" + (Object)((Object)EDhApiDistantGeneratorProgressDisplayLocation.OVERLAY) + ": may be the same as " + (Object)((Object)EDhApiDistantGeneratorProgressDisplayLocation.CHAT) + " for some Minecraft versions \n" + (Object)((Object)EDhApiDistantGeneratorProgressDisplayLocation.CHAT) + " \n" + (Object)((Object)EDhApiDistantGeneratorProgressDisplayLocation.LOG) + " \n" + (Object)((Object)EDhApiDistantGeneratorProgressDisplayLocation.DISABLED) + " \n").build();
            public static ConfigEntry<Integer> generationProgressDisplayIntervalInSeconds = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, 2, 14400).comment("How often should the distant generator progress be displayed? \n").build();
        }
    }
}

