/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources;

import com.seibel.distanthorizons.api.enums.config.EDhApiWorldCompressionMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.api.objects.data.DhApiTerrainDataPoint;
import com.seibel.distanthorizons.api.objects.data.IDhApiFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV1;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.file.IDataSource;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListParent;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.DhApiTerrainDataPointUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.ListUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FullDataSourceV2
extends PhantomArrayListParent
implements IDataSource<IDhLevel>,
IDhApiFullDataSource {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final boolean RUN_UPDATE_DEV_VALIDATION = false;
    private static final boolean RUN_DATA_ORDER_VALIDATION = ModInfo.IS_DEV_BUILD;
    public static final int WIDTH = 64;
    public static final int NUMB_OF_CHUNKS_WIDE = 4;
    public static final byte DATA_FORMAT_VERSION = 1;
    public static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("FullDataV2");
    private int cachedHashCode = 0;
    private final long pos;
    public final FullDataPointIdMap mapping;
    public long lastModifiedUnixDateTime;
    public long createdUnixDateTime;
    public int levelMinY;
    public final ByteArrayList columnGenerationSteps;
    public final ByteArrayList columnWorldCompressionMode;
    public final LongArrayList[] dataPoints;
    public boolean isEmpty;
    public boolean applyToParent = false;
    private boolean runApiChunkValidation = false;

    @Override
    public Long getKey() {
        return this.pos;
    }

    @Override
    public String getKeyDisplayString() {
        return DhSectionPos.toString(this.pos);
    }

    public static FullDataSourceV2 createFromChunk(IChunkWrapper chunkWrapper) {
        return LodDataBuilder.createFromChunk(chunkWrapper);
    }

    public static FullDataSourceV2 createFromLegacyDataSourceV1(FullDataSourceV1 legacyData) {
        if (FullDataSourceV1.WIDTH != 64) {
            throw new UnsupportedOperationException("Unable to convert [" + FullDataSourceV1.class.getSimpleName() + "] into [" + FullDataSourceV2.class.getSimpleName() + "]. Data sources have different data point widths and no converter is present. input width [" + FullDataSourceV1.WIDTH + "], recipient width [" + 64 + "].");
        }
        byte[] columnGenerationSteps = new byte[4096];
        byte[] columnWorldCompressionMode = new byte[4096];
        LongArrayList[] dataPoints = new LongArrayList[4096];
        for (int x = 0; x < 64; ++x) {
            for (int z = 0; z < 64; ++z) {
                long[] legacyDataColumn = legacyData.get(x, z);
                if (legacyDataColumn == null || legacyDataColumn.length == 0) continue;
                int index = FullDataSourceV2.relativePosToIndex(x, z);
                LongArrayList newDataColumn = new LongArrayList(legacyDataColumn);
                boolean columnHasNonAirBlock = false;
                for (int i = 0; i < legacyDataColumn.length; ++i) {
                    long dataPoint = legacyDataColumn[i];
                    boolean isAir = legacyData.mapping.getBlockStateWrapper(FullDataPointUtil.getId(dataPoint)).isAir();
                    byte blockLight = (byte)FullDataPointUtil.getBlockLight(dataPoint);
                    if (isAir) {
                        blockLight = 0;
                    }
                    dataPoint = FullDataPointUtil.setBlockLight(dataPoint, blockLight);
                    newDataColumn.set(i, dataPoint);
                    if (columnHasNonAirBlock || isAir) continue;
                    columnHasNonAirBlock = true;
                }
                FullDataSourceV2.ensureDataColumnOrder(newDataColumn);
                dataPoints[index] = newDataColumn;
                columnGenerationSteps[index] = columnHasNonAirBlock ? EDhApiWorldGenerationStep.LIGHT.value : EDhApiWorldGenerationStep.EMPTY.value;
                columnWorldCompressionMode[index] = EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS.value;
            }
        }
        FullDataSourceV2 fullDataSource = FullDataSourceV2.createWithData(legacyData.getPos(), legacyData.mapping, dataPoints, columnGenerationSteps, columnWorldCompressionMode);
        return fullDataSource;
    }

    public static FullDataSourceV2 createEmpty(long pos) {
        return new FullDataSourceV2(pos, new FullDataPointIdMap(pos), null, null, null, true);
    }

    public static FullDataSourceV2 createWithData(long pos, FullDataPointIdMap mapping, LongArrayList[] data, byte[] columnGenerationStep, byte[] columnWorldCompressionMode) {
        return new FullDataSourceV2(pos, mapping, data, columnGenerationStep, columnWorldCompressionMode, false);
    }

    private FullDataSourceV2(long pos, FullDataPointIdMap mapping, @Nullable LongArrayList[] data, @Nullable byte[] columnGenerationSteps, @Nullable byte[] columnWorldCompressionMode, boolean empty) {
        super(ARRAY_LIST_POOL, 2, 0, 4096);
        int i;
        LodUtil.assertTrue(data == null || data.length == 4096);
        this.pos = pos;
        this.mapping = mapping;
        this.isEmpty = empty;
        this.dataPoints = new LongArrayList[4096];
        for (i = 0; i < 4096; ++i) {
            this.dataPoints[i] = this.pooledArraysCheckout.getLongArray(i, 0);
        }
        if (data != null) {
            for (i = 0; i < 4096; ++i) {
                this.dataPoints[i].addAll((LongList)data[i]);
            }
        }
        this.columnGenerationSteps = this.pooledArraysCheckout.getByteArray(0, 0);
        if (columnGenerationSteps != null) {
            this.columnGenerationSteps.addElements(0, columnGenerationSteps);
        } else {
            ListUtil.clearAndSetSize(this.columnGenerationSteps, 4096);
        }
        this.columnWorldCompressionMode = this.pooledArraysCheckout.getByteArray(1, 0);
        if (columnWorldCompressionMode != null) {
            this.columnWorldCompressionMode.addElements(0, columnWorldCompressionMode);
        } else {
            ListUtil.clearAndSetSize(this.columnWorldCompressionMode, 4096);
        }
        this.pooledArraysCheckout = null;
    }

    public LongArrayList get(int relX, int relZ) throws IndexOutOfBoundsException {
        return this.dataPoints[FullDataSourceV2.relativePosToIndex(relX, relZ)];
    }

    @Override
    public boolean update(@NotNull FullDataSourceV2 inputDataSource, @Nullable IDhLevel level) {
        return this.update(inputDataSource);
    }

    public boolean update(@NotNull FullDataSourceV2 inputDataSource) {
        boolean dataChanged;
        if (inputDataSource.mapping.isEmpty()) {
            return false;
        }
        byte thisDetailLevel = DhSectionPos.getDetailLevel(this.pos);
        byte inputDetailLevel = DhSectionPos.getDetailLevel(inputDataSource.pos);
        int[] remappedIds = this.mapping.mergeAndReturnRemappedEntityIds(inputDataSource.mapping);
        if (inputDetailLevel == thisDetailLevel) {
            dataChanged = this.updateFromSameDetailLevel(inputDataSource, remappedIds);
        } else if (inputDetailLevel + 1 == thisDetailLevel) {
            dataChanged = this.updateFromOneBelowDetailLevel(inputDataSource, remappedIds);
        } else {
            throw new UnsupportedOperationException("Unsupported data source update. Expected input detail level of [" + thisDetailLevel + "] or [" + (thisDetailLevel + 1) + "], received detail level [" + inputDetailLevel + "].");
        }
        boolean bl = this.applyToParent = dataChanged && DhSectionPos.getDetailLevel(this.pos) < 15;
        if (dataChanged) {
            this.generateHashCode();
        }
        return dataChanged;
    }

    public boolean updateFromSameDetailLevel(FullDataSourceV2 inputDataSource, int[] remappedIds) {
        if (DhSectionPos.getDetailLevel(inputDataSource.pos) != DhSectionPos.getDetailLevel(this.pos)) {
            throw new IllegalArgumentException("Both data sources must have the same detail level. Expected [" + DhSectionPos.getDetailLevel(this.pos) + "], received [" + DhSectionPos.getDetailLevel(inputDataSource.pos) + "].");
        }
        boolean dataChanged = false;
        for (int x = 0; x < 64; ++x) {
            for (int z = 0; z < 64; ++z) {
                int index = FullDataSourceV2.relativePosToIndex(x, z);
                LongArrayList inputDataArray = inputDataSource.dataPoints[index];
                if (inputDataArray == null) continue;
                byte thisGenState = this.columnGenerationSteps.getByte(index);
                byte inputGenState = inputDataSource.columnGenerationSteps.getByte(index);
                if (inputGenState == EDhApiWorldGenerationStep.EMPTY.value || thisGenState > inputGenState) continue;
                if (this.dataPoints[index] == null) {
                    this.dataPoints[index] = new LongArrayList((LongList)inputDataArray);
                    dataChanged = true;
                } else if (this.dataPoints[index].size() != inputDataArray.size()) {
                    dataChanged = true;
                }
                int oldDataHash = 0;
                if (!dataChanged) {
                    oldDataHash = this.dataPoints[index].hashCode();
                }
                this.dataPoints[index].clear();
                this.dataPoints[index].addAll((LongList)inputDataArray);
                this.remapDataColumn(index, remappedIds);
                if (RUN_DATA_ORDER_VALIDATION) {
                    FullDataSourceV2.throwIfDataColumnInWrongOrder(inputDataSource.pos, this.dataPoints[index]);
                }
                if (!dataChanged && oldDataHash != this.dataPoints[index].hashCode()) {
                    dataChanged = true;
                }
                this.columnGenerationSteps.set(index, inputGenState);
                this.columnWorldCompressionMode.set(index, inputDataSource.columnWorldCompressionMode.getByte(index));
                this.isEmpty = false;
            }
        }
        return dataChanged;
    }

    public boolean updateFromOneBelowDetailLevel(FullDataSourceV2 inputDataSource, int[] remappedIds) {
        if (DhSectionPos.getDetailLevel(inputDataSource.pos) + 1 != DhSectionPos.getDetailLevel(this.pos)) {
            throw new IllegalArgumentException("Input data source must be exactly 1 detail level below this data source. Expected [" + (DhSectionPos.getDetailLevel(this.pos) - 1) + "], received [" + DhSectionPos.getDetailLevel(inputDataSource.pos) + "].");
        }
        int minChildXPos = DhSectionPos.getX(DhSectionPos.getChildByIndex(this.pos, 0));
        int recipientOffsetX = DhSectionPos.getX(inputDataSource.pos) == minChildXPos ? 0 : 32;
        int minChildZPos = DhSectionPos.getZ(DhSectionPos.getChildByIndex(this.pos, 0));
        int recipientOffsetZ = DhSectionPos.getZ(inputDataSource.pos) == minChildZPos ? 0 : 32;
        boolean dataChanged = false;
        for (int x = 0; x < 64; x += 2) {
            for (int z = 0; z < 64; z += 2) {
                int recipientX = x / 2 + recipientOffsetX;
                int recipientZ = z / 2 + recipientOffsetZ;
                int recipientIndex = FullDataSourceV2.relativePosToIndex(recipientX, recipientZ);
                byte inputGenStep = FullDataSourceV2.determineMinWorldGenStepForTwoByTwoColumn(inputDataSource.columnGenerationSteps, x, z);
                this.columnGenerationSteps.set(recipientIndex, inputGenStep);
                byte worldCompressionMode = FullDataSourceV2.determineHighestWorldCompressionForTwoByTwoColumn(inputDataSource.columnWorldCompressionMode, x, z);
                this.columnWorldCompressionMode.set(recipientIndex, worldCompressionMode);
                LongArrayList mergedInputDataArray = FullDataSourceV2.mergeInputTwoByTwoDataColumn(inputDataSource, x, z);
                if (this.dataPoints[recipientIndex] == null) {
                    dataChanged = true;
                } else if (this.dataPoints[recipientIndex].size() != mergedInputDataArray.size()) {
                    dataChanged = true;
                }
                int oldDataHash = 0;
                if (!dataChanged) {
                    oldDataHash = this.dataPoints[recipientIndex].hashCode();
                }
                this.dataPoints[recipientIndex] = mergedInputDataArray;
                this.remapDataColumn(recipientIndex, remappedIds);
                if (RUN_DATA_ORDER_VALIDATION) {
                    FullDataSourceV2.throwIfDataColumnInWrongOrder(inputDataSource.pos, this.dataPoints[recipientIndex]);
                }
                if (!dataChanged && oldDataHash != this.dataPoints[recipientIndex].hashCode()) {
                    dataChanged = true;
                }
                this.isEmpty = false;
            }
        }
        return dataChanged;
    }

    private static byte determineMinWorldGenStepForTwoByTwoColumn(ByteArrayList columnGenerationSteps, int relX, int relZ) {
        byte minWorldGenStepValue = 127;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                int index = FullDataSourceV2.relativePosToIndex(x + relX, z + relZ);
                byte worldGenStepValue = columnGenerationSteps.getByte(index);
                minWorldGenStepValue = (byte)Math.min(minWorldGenStepValue, worldGenStepValue);
            }
        }
        return minWorldGenStepValue;
    }

    private static byte determineHighestWorldCompressionForTwoByTwoColumn(ByteArrayList columnCompressionMode, int relX, int relZ) {
        byte minWorldGenStepValue = -128;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                int index = FullDataSourceV2.relativePosToIndex(x + relX, z + relZ);
                byte worldGenStepValue = columnCompressionMode.getByte(index);
                minWorldGenStepValue = (byte)Math.max(minWorldGenStepValue, worldGenStepValue);
            }
        }
        return minWorldGenStepValue;
    }

    private static LongArrayList mergeInputTwoByTwoDataColumn(FullDataSourceV2 inputDataSource, int x, int z) {
        LongArrayList newColumnList = new LongArrayList();
        int[] currentDatapointIndex = new int[]{-2, -2, -2, -2};
        int lastId = 0;
        byte lastBlockLight = 0;
        byte lastSkyLight = 0;
        int height = 0;
        int minY = 0;
        long[] datapointsForYSlice = new long[4];
        int[] mergeIds = new int[4];
        int[] mergeBlockLights = new int[4];
        int[] mergeSkyLights = new int[4];
        int blockY = 0;
        while (blockY < 4096 && (currentDatapointIndex[0] != -1 || currentDatapointIndex[1] != -1 || currentDatapointIndex[2] != -1 || currentDatapointIndex[3] != -1)) {
            Arrays.fill(datapointsForYSlice, 0L);
            int colIndex = 0;
            for (int inputX = x; inputX < x + 2; ++inputX) {
                int inputZ = z;
                while (inputZ < z + 2) {
                    LongArrayList inputDataArray = inputDataSource.dataPoints[FullDataSourceV2.relativePosToIndex(inputX, inputZ)];
                    if (inputDataArray == null || inputDataArray.size() == 0) {
                        currentDatapointIndex[colIndex] = -1;
                    } else {
                        int dataPointIndex;
                        if (currentDatapointIndex[colIndex] == -2) {
                            currentDatapointIndex[colIndex] = inputDataArray.size() - 1;
                            if (RUN_DATA_ORDER_VALIDATION) {
                                FullDataSourceV2.throwIfDataColumnInWrongOrder(inputDataSource.pos, inputDataArray);
                            }
                        }
                        if ((dataPointIndex = currentDatapointIndex[colIndex]) != -1) {
                            long datapoint = inputDataArray.getLong(dataPointIndex);
                            int datapointMinY = FullDataPointUtil.getBottomY(datapoint);
                            int numbOfBlocksTall = FullDataPointUtil.getHeight(datapoint);
                            int datapointMaxY = datapointMinY + numbOfBlocksTall;
                            if (blockY >= datapointMinY) {
                                if (blockY >= datapointMaxY) {
                                    int newDatapointIndex = currentDatapointIndex[colIndex] - 1;
                                    if (newDatapointIndex < 0) {
                                        newDatapointIndex = -1;
                                    }
                                    currentDatapointIndex[colIndex] = newDatapointIndex;
                                    --inputZ;
                                    --colIndex;
                                } else {
                                    datapointsForYSlice[colIndex] = datapoint;
                                }
                            }
                        }
                    }
                    ++inputZ;
                    ++colIndex;
                }
            }
            Arrays.fill(mergeIds, 0);
            Arrays.fill(mergeBlockLights, 0);
            Arrays.fill(mergeSkyLights, 0);
            for (int i = 0; i < 4; ++i) {
                mergeIds[i] = FullDataPointUtil.getId(datapointsForYSlice[i]);
                mergeBlockLights[i] = FullDataPointUtil.getBlockLight(datapointsForYSlice[i]);
                mergeSkyLights[i] = FullDataPointUtil.getSkyLight(datapointsForYSlice[i]);
            }
            int id = FullDataSourceV2.determineMostValueInColumnSlice(mergeIds, inputDataSource.mapping);
            byte blockLight = (byte)FullDataSourceV2.determineAverageValueInColumnSlice(mergeBlockLights);
            byte skyLight = (byte)FullDataSourceV2.determineAverageValueInColumnSlice(mergeSkyLights);
            if (id != lastId || blockLight != lastBlockLight || skyLight != lastSkyLight) {
                if (height != 0) {
                    try {
                        long datapoint = FullDataPointUtil.encode(lastId, height, minY, lastBlockLight, lastSkyLight);
                        newColumnList.add(datapoint);
                    }
                    catch (DataCorruptedException e) {
                        LOGGER.warn("Skipping corrupt datapoint for pos " + inputDataSource.pos + " at relative position [" + x + "," + z + "] with data: ID[" + lastId + "], Height[" + height + "], minY[" + minY + "], lastBlockLight[" + lastBlockLight + "], lastSkyLight[" + lastSkyLight + "].");
                    }
                }
                lastId = id;
                lastBlockLight = blockLight;
                lastSkyLight = skyLight;
                height = 0;
                minY = blockY;
            }
            ++blockY;
            ++height;
        }
        if (height != 0) {
            try {
                newColumnList.add(FullDataPointUtil.encode(lastId, height, minY, lastBlockLight, lastSkyLight));
            }
            catch (DataCorruptedException e) {
                LOGGER.warn("Skipping corrupt datapoint for pos " + inputDataSource.pos + " at relative position [" + x + "," + z + "] with data: ID[" + lastId + "], Height[" + height + "], minY[" + minY + "], lastBlockLight[" + lastBlockLight + "], lastSkyLight[" + lastSkyLight + "].");
            }
        }
        FullDataSourceV2.ensureDataColumnOrder(newColumnList);
        return newColumnList;
    }

    private void remapDataColumn(int dataPointIndex, int[] remappedIds) {
        LongArrayList dataColumn = this.dataPoints[dataPointIndex];
        for (int i = 0; i < dataColumn.size(); ++i) {
            dataColumn.set(i, FullDataPointUtil.remap(remappedIds, dataColumn.getLong(i)));
        }
    }

    private static boolean areDataColumnsDifferent(long[] oldDataArray, long[] newDataArray) {
        if (oldDataArray == null || oldDataArray.length != newDataArray.length) {
            return true;
        }
        int oldArrayHash = Arrays.hashCode(oldDataArray);
        int newArrayHash = Arrays.hashCode(newDataArray);
        return newArrayHash != oldArrayHash;
    }

    private static int determineMostValueInColumnSlice(int[] sliceArray, @Nullable FullDataPointIdMap mapping) {
        int value0 = sliceArray[0];
        int count0 = 0;
        int value1 = sliceArray[1];
        int count1 = 0;
        int value2 = sliceArray[2];
        int count2 = 0;
        int value3 = sliceArray[3];
        int count3 = 0;
        for (int i = 0; i < 4; ++i) {
            int value = sliceArray[i];
            if (mapping != null && mapping.getBlockStateWrapper(value).isAir()) continue;
            if (value == value0) {
                ++count0;
                continue;
            }
            if (value == value1) {
                ++count1;
                continue;
            }
            if (value == value2) {
                ++count2;
                continue;
            }
            ++count3;
        }
        int maxCount = Math.max(count0, Math.max(count1, Math.max(count2, count3)));
        if (maxCount == count0) {
            return value0;
        }
        if (maxCount == count1) {
            return value1;
        }
        if (maxCount == count2) {
            return value2;
        }
        return value3;
    }

    private static int determineAverageValueInColumnSlice(int[] sliceArray) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value += sliceArray[i];
        }
        return value /= 4;
    }

    public static int relativePosToIndex(int relX, int relZ) throws IndexOutOfBoundsException {
        if (relX < 0 || relZ < 0 || relX > 64 || relZ > 64) {
            throw new IndexOutOfBoundsException("Relative data source positions must be between [0] and [64] (inclusive) the relative pos: [" + relX + "," + relZ + "] is outside of those boundaries.");
        }
        return relX * 64 + relZ;
    }

    public static void throwIfDataColumnInWrongOrder(long pos, LongArrayList dataArray) throws IllegalStateException {
        long lastDataPoint;
        int lastBottomY;
        long firstDataPoint = dataArray.getLong(0);
        int firstBottomY = FullDataPointUtil.getBottomY(firstDataPoint);
        if (firstBottomY < (lastBottomY = FullDataPointUtil.getBottomY(lastDataPoint = dataArray.getLong(dataArray.size() - 1)))) {
            throw new IllegalStateException("Incorrect data point order at pos: [" + DhSectionPos.toString(pos) + "], first datapoint bottom Y [" + firstBottomY + "], last datapoint bottom Y [" + lastBottomY + "].");
        }
    }

    private static void ensureDataColumnOrder(LongArrayList dataColumn) {
        long lastDataPoint;
        int lastBottomY;
        long firstDataPoint = dataColumn.getLong(0);
        int firstBottomY = FullDataPointUtil.getBottomY(firstDataPoint);
        if (firstBottomY < (lastBottomY = FullDataPointUtil.getBottomY(lastDataPoint = dataColumn.getLong(dataColumn.size() - 1)))) {
            for (int i = 0; i < dataColumn.size() / 2; ++i) {
                long temp = dataColumn.getLong(i);
                dataColumn.set(i, dataColumn.getLong(dataColumn.size() - i - 1));
                dataColumn.set(dataColumn.size() - i - 1, temp);
            }
        }
    }

    @Override
    public Long getPos() {
        return this.pos;
    }

    @Override
    public byte getDataDetailLevel() {
        return (byte)(DhSectionPos.getDetailLevel(this.pos) - 6);
    }

    public EDhApiWorldGenerationStep getWorldGenStepAtRelativePos(int relX, int relZ) {
        int index = FullDataSourceV2.relativePosToIndex(relX, relZ);
        return EDhApiWorldGenerationStep.fromValue(this.columnGenerationSteps.getByte(index));
    }

    public void setSingleColumn(LongArrayList longArray, int relX, int relZ, EDhApiWorldGenerationStep worldGenStep, EDhApiWorldCompressionMode worldCompressionMode) {
        int index = FullDataSourceV2.relativePosToIndex(relX, relZ);
        this.dataPoints[index] = longArray;
        this.columnGenerationSteps.set(index, worldGenStep.value);
        this.columnWorldCompressionMode.set(index, worldCompressionMode.value);
    }

    public void setRunApiChunkValidation(boolean runValidation) {
        this.runApiChunkValidation = runValidation;
    }

    @Override
    public int getWidthInDataColumns() {
        return 64;
    }

    @Override
    public List<DhApiTerrainDataPoint> setApiDataPointColumn(int relX, int relZ, List<DhApiTerrainDataPoint> columnDataPoints) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            LodDataBuilder.correctDataColumnOrder(columnDataPoints);
            if (this.runApiChunkValidation) {
                LodDataBuilder.validateOrThrowApiDataColumn(columnDataPoints);
            }
            LongArrayList packedDataPoints = LodDataBuilder.convertApiDataPointListToPackedLongArray(columnDataPoints, this, 0);
            this.setSingleColumn(packedDataPoints, relX, relZ, EDhApiWorldGenerationStep.LIGHT, EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS);
            return columnDataPoints;
        }
        catch (DataCorruptedException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public List<DhApiTerrainDataPoint> getApiDataPointColumn(int relX, int relZ) throws IndexOutOfBoundsException {
        LongArrayList dataColumn = this.get(relX, relZ);
        ArrayList<DhApiTerrainDataPoint> apiList = new ArrayList<DhApiTerrainDataPoint>();
        for (int i = 0; i < dataColumn.size(); ++i) {
            long datapoint = dataColumn.getLong(i);
            DhApiTerrainDataPoint apiDataPoint = DhApiTerrainDataPointUtil.createApiDatapoint(this.levelMinY, this.mapping, DhSectionPos.getDetailLevel(this.pos), datapoint);
            apiList.add(apiDataPoint);
        }
        return apiList;
    }

    public String toString() {
        return DhSectionPos.toString(this.pos);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.generateHashCode();
        }
        return this.cachedHashCode;
    }

    private void generateHashCode() {
        int result = DhSectionPos.hashCode(this.pos);
        result = 31 * result + Arrays.deepHashCode(this.dataPoints);
        result = 17 * result + this.columnGenerationSteps.hashCode();
        this.cachedHashCode = result = 43 * result + this.columnWorldCompressionMode.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FullDataSourceV2)) {
            return false;
        }
        FullDataSourceV2 other = (FullDataSourceV2)obj;
        if (other.pos != this.pos) {
            return false;
        }
        return other.hashCode() == this.hashCode();
    }
}

