/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.texture;

import org.jetbrains.annotations.Nullable;

public enum EDhDepthBufferFormat {
    DEPTH(false),
    DEPTH16(false),
    DEPTH24(false),
    DEPTH32(false),
    DEPTH32F(false),
    DEPTH_STENCIL(true),
    DEPTH24_STENCIL8(true),
    DEPTH32F_STENCIL8(true);

    private final boolean combinedStencil;

    private EDhDepthBufferFormat(boolean combinedStencil) {
        this.combinedStencil = combinedStencil;
    }

    @Nullable
    public static EDhDepthBufferFormat fromGlEnum(int glenum) {
        switch (glenum) {
            case 6402: {
                return DEPTH;
            }
            case 33189: {
                return DEPTH16;
            }
            case 33190: {
                return DEPTH24;
            }
            case 33191: {
                return DEPTH32;
            }
            case 36012: {
                return DEPTH32F;
            }
            case 34041: {
                return DEPTH_STENCIL;
            }
            case 35056: {
                return DEPTH24_STENCIL8;
            }
            case 36013: {
                return DEPTH32F_STENCIL8;
            }
        }
        return null;
    }

    public static EDhDepthBufferFormat fromGlEnumOrDefault(int glenum) {
        EDhDepthBufferFormat format = EDhDepthBufferFormat.fromGlEnum(glenum);
        if (format == null) {
            return DEPTH;
        }
        return format;
    }

    public int getGlInternalFormat() {
        switch (this.ordinal()) {
            case 0: {
                return 6402;
            }
            case 1: {
                return 33189;
            }
            case 2: {
                return 33190;
            }
            case 3: {
                return 33191;
            }
            case 4: {
                return 36012;
            }
            case 5: {
                return 34041;
            }
            case 6: {
                return 35056;
            }
            case 7: {
                return 36013;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public int getGlType() {
        return this.isCombinedStencil() ? 34041 : 6402;
    }

    public int getGlFormat() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return 5123;
            }
            case 2: 
            case 3: {
                return 5125;
            }
            case 4: {
                return 5126;
            }
            case 5: 
            case 6: {
                return 34042;
            }
            case 7: {
                return 36269;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public boolean isCombinedStencil() {
        return this.combinedStencil;
    }
}

