/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import org.lwjgl.opengl.GL32;

public class FadeShader
extends AbstractShaderRenderer {
    public static FadeShader INSTANCE = new FadeShader();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public int frameBuffer = -1;
    private Mat4f inverseMcMvmProjMatrix;
    private Mat4f inverseDhMvmProjMatrix;
    private float levelMaxHeight;
    public int uMcDepthTexture = -1;
    public int uDhDepthTexture = -1;
    public int uCombinedMcDhColorTexture = -1;
    public int uDhColorTexture = -1;
    public int uDhInvMvmProj = -1;
    public int uMcInvMvmProj = -1;
    public int uStartFadeBlockDistance = -1;
    public int uEndFadeBlockDistance = -1;
    public int uMaxLevelHeight = -1;

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/fade/fade.frag", "fragColor", new String[]{"vPosition"});
        this.uDhInvMvmProj = this.shader.tryGetUniformLocation("uDhInvMvmProj");
        this.uMcInvMvmProj = this.shader.tryGetUniformLocation("uMcInvMvmProj");
        this.uMcDepthTexture = this.shader.tryGetUniformLocation("uMcDepthMap");
        this.uDhDepthTexture = this.shader.tryGetUniformLocation("uDhDepthTexture");
        this.uCombinedMcDhColorTexture = this.shader.tryGetUniformLocation("uCombinedMcDhColorTexture");
        this.uDhColorTexture = this.shader.tryGetUniformLocation("uDhColorTexture");
        this.uStartFadeBlockDistance = this.shader.tryGetUniformLocation("uStartFadeBlockDistance");
        this.uEndFadeBlockDistance = this.shader.tryGetUniformLocation("uEndFadeBlockDistance");
        this.uMaxLevelHeight = this.shader.tryGetUniformLocation("uMaxLevelHeight");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        if (this.inverseMcMvmProjMatrix != null) {
            this.shader.setUniform(this.uMcInvMvmProj, this.inverseMcMvmProjMatrix);
        }
        if (this.inverseDhMvmProjMatrix != null) {
            this.shader.setUniform(this.uDhInvMvmProj, this.inverseDhMvmProjMatrix);
        }
        float dhNearClipDistance = RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks);
        float fadeStartDistance = (dhNearClipDistance += 16.0f) * 1.5f;
        float fadeEndDistance = dhNearClipDistance * 1.9f;
        if (this.uStartFadeBlockDistance != -1) {
            this.shader.setUniform(this.uStartFadeBlockDistance, fadeStartDistance);
        }
        if (this.uEndFadeBlockDistance != -1) {
            this.shader.setUniform(this.uEndFadeBlockDistance, fadeEndDistance);
        }
        if (this.uMaxLevelHeight != -1) {
            this.shader.setUniform(this.uMaxLevelHeight, this.levelMaxHeight);
        }
    }

    public void setProjectionMatrix(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        Mat4f inverseMcModelViewProjectionMatrix = new Mat4f(mcProjectionMatrix);
        inverseMcModelViewProjectionMatrix.multiply(mcModelViewMatrix);
        inverseMcModelViewProjectionMatrix.invert();
        this.inverseMcMvmProjMatrix = inverseMcModelViewProjectionMatrix;
        Mat4f dhProjectionMatrix = RenderUtil.createLodProjectionMatrix(mcProjectionMatrix, partialTicks);
        Mat4f dhModelViewMatrix = RenderUtil.createLodModelViewMatrix(mcModelViewMatrix);
        Mat4f inverseDhModelViewProjectionMatrix = new Mat4f(dhProjectionMatrix);
        inverseDhModelViewProjectionMatrix.multiply(dhModelViewMatrix);
        inverseDhModelViewProjectionMatrix.invert();
        this.inverseDhMvmProjMatrix = inverseDhModelViewProjectionMatrix;
    }

    public void setLevelMaxHeight(int levelMaxHeight) {
        this.levelMaxHeight = levelMaxHeight;
    }

    @Override
    protected void onRender() {
        GLMC.glBindFramebuffer(36160, this.frameBuffer);
        GLMC.disableScissorTest();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(MC_RENDER.getDepthTextureId());
        GL32.glUniform1i((int)this.uMcDepthTexture, (int)0);
        GLMC.glActiveTexture(33985);
        GLMC.glBindTexture(LodRenderer.getActiveDepthTextureId());
        GL32.glUniform1i((int)this.uDhDepthTexture, (int)1);
        GLMC.glActiveTexture(33986);
        GLMC.glBindTexture(MC_RENDER.getColorTextureId());
        GL32.glUniform1i((int)this.uCombinedMcDhColorTexture, (int)2);
        GLMC.glActiveTexture(33987);
        GLMC.glBindTexture(LodRenderer.getActiveColorTextureId());
        GL32.glUniform1i((int)this.uDhColorTexture, (int)3);
        ScreenQuad.INSTANCE.render();
    }
}

