/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;

public final class GLMessage {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    static final String HEADER = "[LWJGL] OpenGL debug message";
    public final EType type;
    public final ESeverity severity;
    public final ESource source;
    public final String id;
    public final String message;

    static void initLoadClass() {
        Builder dummy = new Builder();
        dummy.add(HEADER);
        dummy.add("ID");
        dummy.add(":");
        dummy.add("dummyId");
        dummy.add("Source");
        dummy.add(":");
        dummy.add(ESource.API.name);
        dummy.add("Type");
        dummy.add(":");
        dummy.add(EType.OTHER.name);
        dummy.add("Severity");
        dummy.add(":");
        dummy.add(ESeverity.LOW.name);
        dummy.add("Message");
        dummy.add(":");
        dummy.add("dummyMessage");
    }

    GLMessage(EType type2, ESeverity severity, ESource source, String id, String message) {
        this.type = type2;
        this.source = source;
        this.severity = severity;
        this.id = id;
        this.message = message;
    }

    public String toString() {
        return "[level:" + (Object)((Object)this.severity) + ", type:" + (Object)((Object)this.type) + ", source:" + (Object)((Object)this.source) + ", id:" + this.id + ", msg:{" + this.message + "}]";
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static {
        GLMessage.initLoadClass();
    }

    public static class Builder {
        private static final int FINAL_PARSER_STAGE_INDEX = 15;
        public static final Builder DEFAULT_MESSAGE_BUILDER = new Builder(type2 -> {
            if (type2 == EType.POP_GROUP) {
                return false;
            }
            if (type2 == EType.PUSH_GROUP) {
                return false;
            }
            if (type2 == EType.MARKER) {
                return false;
            }
            return true;
        }, severity -> {
            if (severity == ESeverity.NOTIFICATION) {
                return false;
            }
            return true;
        }, null);
        private final StringBuilder inProgressMessageBuilder = new StringBuilder();
        private EType type;
        private ESeverity severity;
        private ESource source;
        private final Function<EType, Boolean> typeFilter;
        private final Function<ESeverity, Boolean> severityFilter;
        private final Function<ESource, Boolean> sourceFilter;
        private String id;
        private String message;
        private int parserStage = 0;

        public Builder() {
            this(null, null, null);
        }

        public Builder(Function<EType, Boolean> typeFilter, Function<ESeverity, Boolean> severityFilter, Function<ESource, Boolean> sourceFilter) {
            this.typeFilter = typeFilter;
            this.severityFilter = severityFilter;
            this.sourceFilter = sourceFilter;
        }

        public GLMessage add(String str) {
            return null;
        }

        private boolean doesMessagePassFilters(GLMessage msg) {
            if (this.sourceFilter != null && !this.sourceFilter.apply(msg.source).booleanValue()) {
                return false;
            }
            if (this.typeFilter != null && !this.typeFilter.apply(msg.type).booleanValue()) {
                return false;
            }
            return this.severityFilter == null || this.severityFilter.apply(msg.severity) != false;
        }

        private boolean runNextParserStage(String str) {
            switch (this.parserStage) {
                case 0: {
                    return this.checkAndIncStage(str, GLMessage.HEADER);
                }
                case 1: {
                    return this.checkAndIncStage(str, "ID");
                }
                case 2: {
                    return this.checkAndIncStage(str, ":");
                }
                case 3: {
                    this.id = str;
                    ++this.parserStage;
                    return true;
                }
                case 4: {
                    return this.checkAndIncStage(str, "Source");
                }
                case 5: {
                    return this.checkAndIncStage(str, ":");
                }
                case 6: {
                    this.source = ESource.get(str);
                    ++this.parserStage;
                    return true;
                }
                case 7: {
                    return this.checkAndIncStage(str, "Type");
                }
                case 8: {
                    return this.checkAndIncStage(str, ":");
                }
                case 9: {
                    this.type = EType.get(str);
                    ++this.parserStage;
                    return true;
                }
                case 10: {
                    return this.checkAndIncStage(str, "Severity");
                }
                case 11: {
                    return this.checkAndIncStage(str, ":");
                }
                case 12: {
                    this.severity = ESeverity.get(str);
                    ++this.parserStage;
                    return true;
                }
                case 13: {
                    return this.checkAndIncStage(str, "Message");
                }
                case 14: {
                    return this.checkAndIncStage(str, ":");
                }
                case 15: {
                    this.message = str;
                    ++this.parserStage;
                    return true;
                }
            }
            return false;
        }

        private boolean checkAndIncStage(String givenString, String expectedString) {
            boolean equal = givenString.equals(expectedString);
            if (equal) {
                ++this.parserStage;
            }
            return equal;
        }

        static {
            GLMessage.initLoadClass();
        }
    }

    public static enum ESource {
        API,
        WINDOW_SYSTEM,
        SHADER_COMPILER,
        THIRD_PARTY,
        APPLICATION,
        OTHER;

        private static final HashMap<String, ESource> ENUM_BY_NAME;
        public final String name = super.toString().toUpperCase();

        public final String toString() {
            return this.name;
        }

        public static ESource get(String name) {
            return ENUM_BY_NAME.get(name.toUpperCase());
        }

        static {
            ENUM_BY_NAME = new HashMap();
            for (ESource source : ESource.values()) {
                ENUM_BY_NAME.put(source.name, source);
            }
        }
    }

    public static enum EType {
        ERROR,
        DEPRECATED_BEHAVIOR,
        UNDEFINED_BEHAVIOR,
        PORTABILITY,
        PERFORMANCE,
        MARKER,
        PUSH_GROUP,
        POP_GROUP,
        OTHER;

        private static final HashMap<String, EType> ENUM_BY_NAME;
        private final String name = super.toString().toUpperCase();

        public final String toString() {
            return this.name;
        }

        public static EType get(String name) {
            return ENUM_BY_NAME.get(name.toUpperCase());
        }

        static {
            ENUM_BY_NAME = new HashMap();
            for (EType type2 : EType.values()) {
                ENUM_BY_NAME.put(type2.name, type2);
            }
        }
    }

    public static enum ESeverity {
        HIGH,
        MEDIUM,
        LOW,
        NOTIFICATION;

        public final String name = super.toString().toUpperCase();
        static final HashMap<String, ESeverity> ENUM_BY_NAME;

        public final String toString() {
            return this.name;
        }

        public static ESeverity get(String name) {
            return ENUM_BY_NAME.get(name.toUpperCase());
        }

        static {
            ENUM_BY_NAME = new HashMap();
            for (ESeverity severity : ESeverity.values()) {
                ENUM_BY_NAME.put(severity.name, severity);
            }
        }
    }
}

