/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.wrapperInterfaces.world;

import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;

public interface IServerLevelWrapper
extends ILevelWrapper {
    public File getMcSaveFolder();

    public String getWorldFolderName();

    default public String getKeyedLevelDimensionName() {
        String dimensionName = this.getDhIdentifier();
        if (Config.Server.sendLevelKeys.get().booleanValue()) {
            String levelKeyPrefix = Config.Server.levelKeyPrefix.get();
            if (SharedApi.getEnvironment() == EWorldEnvironment.CLIENT_SERVER) {
                String cleanWorldFolderName = this.getWorldFolderName().replaceAll("[^a-zA-Z0-9-_ ]", "").replaceAll(" ", "_");
                levelKeyPrefix = levelKeyPrefix + (!levelKeyPrefix.isEmpty() ? "_" : "") + cleanWorldFolderName + "_" + this.getHashedSeedEncoded();
            }
            if (levelKeyPrefix.isEmpty()) {
                levelKeyPrefix = this.getHashedSeedEncoded();
            }
            String mainPart = "@" + dimensionName;
            return levelKeyPrefix.substring(0, Math.min(150 - mainPart.length(), levelKeyPrefix.length())) + mainPart;
        }
        return dimensionName;
    }
}

